/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.SingleOwnerAndAsyncMethodsTest")
public class SingleOwnerAndAsyncMethodsTest
extends BaseDistFunctionalTest<Object, String> {
    public SingleOwnerAndAsyncMethodsTest() {
        this.INIT_CLUSTER_SIZE = 2;
        this.numOwners = 1;
        this.l1CacheEnabled = false;
    }

    public void testAsyncPut(Method m) throws Exception {
        Cache<Object, String> ownerCache = this.getOwner(TestingUtil.k(m));
        ownerCache.put((Object)TestingUtil.k(m), (Object)TestingUtil.v(m));
        CompletableFuture f = ownerCache.putAsync((Object)TestingUtil.k(m), (Object)TestingUtil.v(m, 1));
        assert (f != null);
        Assert.assertEquals((String)TestingUtil.v(m), (String)((String)f.get()));
    }

    public void testAsyncGet(Method m) throws Exception {
        String key = TestingUtil.k(m);
        String value = TestingUtil.v(m);
        Cache<Object, String> ownerCache = this.getOwner(key);
        ownerCache.put((Object)key, (Object)value);
        AdvancedCache nonOwnerCache = this.getNonOwner(key).getAdvancedCache();
        CompletableFuture f = nonOwnerCache.getAsync((Object)key);
        assert (f != null);
        assert (((String)f.get()).equals(value));
        f = nonOwnerCache.withFlags(Flag.SKIP_REMOTE_LOOKUP).getAsync((Object)key);
        assert (f != null);
        assert (f.get() == null);
        f = nonOwnerCache.getAsync((Object)key);
        assert (f != null);
        assert (((String)f.get()).equals(value));
        f = nonOwnerCache.withFlags(Flag.CACHE_MODE_LOCAL).getAsync((Object)key);
        assert (f != null);
        assert (f.get() == null);
        f = nonOwnerCache.getAsync((Object)key);
        assert (f != null);
        assert (((String)f.get()).equals(value));
    }

    public void testAsyncGetAll(Method m) throws Exception {
        String k2;
        String k1 = TestingUtil.k(m, 1);
        String v1 = TestingUtil.v(m, 1);
        String v2 = TestingUtil.v(m, 2);
        Cache<Object, String> ownerCache = this.getOwner(k1);
        AdvancedCache nonOwnerCache = this.getNonOwner(k1).getAdvancedCache();
        int counter = 2;
        while (!this.getOwner(k2 = TestingUtil.k(m, counter)).equals((Object)nonOwnerCache)) {
            if (counter > 1000) {
                throw new IllegalStateException("Cannot find suitable key");
            }
            ++counter;
        }
        HashSet<String> keys = new HashSet<String>(Arrays.asList(k1, k2));
        HashMap<String, String> entries = new HashMap<String, String>();
        entries.put(k1, v1);
        entries.put(k2, v2);
        ownerCache.put((Object)k1, (Object)v1);
        nonOwnerCache.put((Object)k2, (Object)v2);
        CompletableFuture f = nonOwnerCache.getAllAsync(keys);
        Assert.assertNotNull((Object)f);
        Assert.assertEquals(entries, f.get());
        f = nonOwnerCache.withFlags(Flag.SKIP_REMOTE_LOOKUP).getAllAsync(keys);
        Assert.assertNotNull((Object)f);
        Assert.assertEquals(Collections.singletonMap(k2, v2), f.get());
        f = nonOwnerCache.withFlags(Flag.SKIP_REMOTE_LOOKUP).getAllAsync(Collections.singleton(k1));
        Assert.assertNotNull((Object)f);
        Assert.assertEquals(Collections.emptyMap(), f.get());
        f = nonOwnerCache.getAllAsync(keys);
        Assert.assertNotNull((Object)f);
        Assert.assertEquals(entries, f.get());
        f = nonOwnerCache.withFlags(Flag.CACHE_MODE_LOCAL).getAllAsync(keys);
        Assert.assertNotNull((Object)f);
        Assert.assertEquals(Collections.singletonMap(k2, v2), f.get());
        f = nonOwnerCache.withFlags(Flag.CACHE_MODE_LOCAL).getAllAsync(Collections.singleton(k1));
        Assert.assertNotNull((Object)f);
        Assert.assertEquals(Collections.emptyMap(), f.get());
        f = nonOwnerCache.getAllAsync(keys);
        Assert.assertNotNull((Object)f);
        Assert.assertEquals(entries, f.get());
    }

    public void testAsyncReplace(Method m) throws Exception {
        CompletableFuture f = this.getOwner(TestingUtil.k(m)).replaceAsync((Object)TestingUtil.k(m), (Object)TestingUtil.v(m));
        assert (f != null);
        assert (f.get() == null);
        this.getOwner(TestingUtil.k(m)).put((Object)TestingUtil.k(m), (Object)TestingUtil.v(m));
        f = this.getNonOwner(TestingUtil.k(m)).replaceAsync((Object)TestingUtil.k(m), (Object)TestingUtil.v(m, 1));
        assert (f != null);
        assert (((String)f.get()).equals(TestingUtil.v(m)));
    }

    public void testAsyncGetThenPutOnSameNode(Method m) throws Exception {
        Cache<Object, String> ownerCache = this.getOwner(TestingUtil.k(m));
        Cache<Object, String> nonOwnerCache = this.getNonOwner(TestingUtil.k(m));
        ownerCache.put((Object)TestingUtil.k(m), (Object)TestingUtil.v(m));
        CompletableFuture f = nonOwnerCache.getAsync((Object)TestingUtil.k(m));
        assert (f != null);
        assert (((String)f.get()).equals(TestingUtil.v(m)));
        nonOwnerCache.put((Object)TestingUtil.k(m, 1), (Object)TestingUtil.v(m, 1));
    }

    public void testParallelAsyncGets(Method m) throws Exception {
        this.getOwner(TestingUtil.k(m, 1)).put((Object)TestingUtil.k(m, 1), (Object)TestingUtil.v(m, 1));
        this.getOwner(TestingUtil.k(m, 2)).put((Object)TestingUtil.k(m, 2), (Object)TestingUtil.v(m, 2));
        this.getOwner(TestingUtil.k(m, 3)).put((Object)TestingUtil.k(m, 3), (Object)TestingUtil.v(m, 3));
        CompletableFuture f1 = this.getNonOwner(TestingUtil.k(m, 1)).getAsync((Object)TestingUtil.k(m, 1));
        CompletableFuture f2 = this.getNonOwner(TestingUtil.k(m, 2)).getAsync((Object)TestingUtil.k(m, 2));
        CompletableFuture f3 = this.getNonOwner(TestingUtil.k(m, 3)).getAsync((Object)TestingUtil.k(m, 3));
        assert (f1 != null);
        assert (((String)f1.get()).equals(TestingUtil.v(m, 1)));
        assert (f2 != null);
        assert (((String)f2.get()).equals(TestingUtil.v(m, 2)));
        assert (f3 != null);
        assert (((String)f3.get()).equals(TestingUtil.v(m, 3)));
        this.getNonOwner(TestingUtil.k(m, 1)).put((Object)TestingUtil.k(m, 1), (Object)TestingUtil.v(m, 11));
        this.getNonOwner(TestingUtil.k(m, 2)).put((Object)TestingUtil.k(m, 2), (Object)TestingUtil.v(m, 22));
        this.getNonOwner(TestingUtil.k(m, 3)).put((Object)TestingUtil.k(m, 3), (Object)TestingUtil.v(m, 33));
        f1 = this.getOwner(TestingUtil.k(m, 1)).getAsync((Object)TestingUtil.k(m, 1));
        f2 = this.getOwner(TestingUtil.k(m, 2)).getAsync((Object)TestingUtil.k(m, 2));
        f3 = this.getOwner(TestingUtil.k(m, 3)).getAsync((Object)TestingUtil.k(m, 3));
        assert (f1 != null);
        assert (((String)f1.get()).equals(TestingUtil.v(m, 11)));
        assert (f2 != null);
        assert (((String)f2.get()).equals(TestingUtil.v(m, 22)));
        assert (f3 != null);
        assert (((String)f3.get()).equals(TestingUtil.v(m, 33)));
    }

    public void testLocalAsyncGet(Method m) throws Exception {
        Cache<Object, String> ownerCache = this.getOwner(TestingUtil.k(m));
        ownerCache.put((Object)TestingUtil.k(m), (Object)TestingUtil.v(m));
        CompletableFuture f = this.getNonOwner(TestingUtil.k(m)).getAdvancedCache().withFlags(Flag.SKIP_REMOTE_LOOKUP).getAsync((Object)TestingUtil.k(m));
        assert (f != null);
        assert (f.get() == null);
    }

    protected Cache<Object, String> getOwner(Object key) {
        return this.getOwners(key)[0];
    }

    protected Cache<Object, String> getNonOwner(Object key) {
        return this.getNonOwners(key)[0];
    }

    @Override
    public Cache<Object, String>[] getOwners(Object key) {
        return this.getOwners(key, 1);
    }

    @Override
    public Cache<Object, String>[] getNonOwners(Object key) {
        return this.getNonOwners(key, 1);
    }
}

