/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.encode;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.Set;
import org.immutables.generator.Naming;
import org.immutables.value.Value;
import org.immutables.value.processor.encode.Code;
import org.immutables.value.processor.encode.EncodedElement;
import org.immutables.value.processor.encode.EncodingInfo;
import org.immutables.value.processor.encode.Instantiator;
import org.immutables.value.processor.encode.Mirrors;
import org.immutables.value.processor.encode.StandardNaming;
import org.immutables.value.processor.encode.Type;

@Value.Enclosing
public final class Inflater
implements Function<Mirrors.EncMetadata, EncodingInfo> {
    private final Type.Factory typeFactory;

    public Inflater(Type.Factory typeFactory) {
        this.typeFactory = typeFactory;
    }

    public Instantiator instantiatorFor(Set<EncodingInfo> encodinds) {
        return new Instantiator(this.typeFactory, encodinds);
    }

    public EncodingInfo apply(Mirrors.EncMetadata input) {
        Type.Parameters typeParameters = this.typeFactory.parameters();
        for (String t : input.typeParams()) {
            typeParameters = typeParameters.introduce(t, (Iterable<? extends Type.Defined>)ImmutableList.of());
        }
        EncodingInfo.Builder builder = new EncodingInfo.Builder().name(input.name()).addImports(input.imports()).typeFactory(this.typeFactory).typeParameters(typeParameters);
        for (Mirrors.EncElement e : input.elements()) {
            builder.addElement(this.elementFor(e, typeParameters));
        }
        return builder.build();
    }

    private EncodedElement elementFor(Mirrors.EncElement e, Type.Parameters typeParameters) {
        EncodedElement.Builder builder = new EncodedElement.Builder();
        for (String input : e.typeParams()) {
            EncodedElement.TypeParam p = EncodedElement.TypeParam.from(input, this.typeFactory, typeParameters);
            typeParameters = typeParameters.introduce(input, p.bounds());
            builder.addTypeParams(p);
        }
        Type.Parser parser = new Type.Parser(this.typeFactory, typeParameters);
        builder.typeParameters(typeParameters).name(e.name()).naming(Naming.from((String)e.naming())).standardNaming(StandardNaming.valueOf(e.stdNaming())).type(parser.parse(e.type())).addDoc(e.doc()).addAnnotations(e.annotations()).addAllCode(Code.termsFrom(e.code()));
        for (String input : e.params()) {
            builder.addParams(EncodedElement.Param.from(input, parser));
        }
        for (String input : e.tags()) {
            builder.addTags(EncodedElement.Tag.valueOf(input));
        }
        return builder.build();
    }
}

