/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SourceTypes {
    private SourceTypes() {
    }

    public static Map.Entry<String, List<String>> extract(CharSequence typeString) {
        String lastArgument;
        StringBuilder typeName = new StringBuilder();
        StringBuilder typeArgument = new StringBuilder();
        ArrayList typeArguments = Lists.newArrayList();
        int anglesOpened = 0;
        int parensOpened = 0;
        block9: for (int i = 0; i < typeString.length(); ++i) {
            char c = typeString.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': {
                    i = SourceTypes.transferStringLiteral(anglesOpened == 0 ? typeName : typeArgument, typeString, c, i + 1) - 1;
                    continue block9;
                }
                case '(': {
                    ++parensOpened;
                    if (anglesOpened == 0) {
                        typeName.append(c);
                        continue block9;
                    }
                    typeArgument.append(c);
                    continue block9;
                }
                case ')': {
                    --parensOpened;
                    if (anglesOpened == 0) {
                        typeName.append(c);
                        continue block9;
                    }
                    typeArgument.append(c);
                    continue block9;
                }
                case '<': {
                    if (++anglesOpened <= 1) continue block9;
                    typeArgument.append(c);
                    continue block9;
                }
                case '>': {
                    if (--anglesOpened <= 0) break block9;
                    typeArgument.append(c);
                    continue block9;
                }
                case ',': {
                    if (parensOpened > 0) {
                        if (anglesOpened == 0) {
                            typeName.append(c);
                            continue block9;
                        }
                        typeArgument.append(c);
                        continue block9;
                    }
                    if (anglesOpened == 1) {
                        typeArguments.add(typeArgument.toString());
                        typeArgument = new StringBuilder();
                        continue block9;
                    }
                    typeArgument.append(c);
                    continue block9;
                }
                case ' ': {
                    if (anglesOpened == 0) {
                        typeName.append(c);
                        continue block9;
                    }
                    if (anglesOpened == 1) {
                        if (parensOpened > 0) {
                            typeArgument.append(c);
                            continue block9;
                        }
                        if (typeArgument.length() <= 0 || typeArgument.charAt(typeArgument.length() - 1) != ')') continue block9;
                        typeArgument.append(c);
                        continue block9;
                    }
                    typeArgument.append(c);
                    continue block9;
                }
                default: {
                    if (anglesOpened == 0) {
                        typeName.append(c);
                        continue block9;
                    }
                    typeArgument.append(c);
                }
            }
        }
        if (!(lastArgument = typeArgument.toString()).isEmpty()) {
            typeArguments.add(lastArgument);
        }
        return Maps.immutableEntry((Object)typeName.toString(), (Object)typeArguments);
    }

    private static int transferStringLiteral(StringBuilder target, CharSequence typeString, char end, int i) {
        target.append(end);
        while (i < typeString.length()) {
            char c = typeString.charAt(i);
            if (c == '\\') {
                target.append(c);
                c = typeString.charAt(++i);
                target.append(c);
            } else {
                if (c == end) {
                    target.append(c);
                    ++i;
                    break;
                }
                target.append(c);
            }
            ++i;
        }
        return i;
    }

    public static String stringify(Map.Entry<String, ? extends List<String>> types) {
        if (types.getValue().isEmpty()) {
            return types.getKey();
        }
        return types.getKey() + "<" + Joiner.on((String)", ").join((Iterable)types.getValue()) + ">";
    }
}

