/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko.xerces.dom;

import org.htmlunit.cyberneko.xerces.dom.AttrImpl;
import org.htmlunit.cyberneko.xerces.dom.AttrNSImpl;
import org.htmlunit.cyberneko.xerces.dom.AttributeMap;
import org.htmlunit.cyberneko.xerces.dom.CoreDocumentImpl;
import org.htmlunit.cyberneko.xerces.dom.DeepNodeListImpl;
import org.htmlunit.cyberneko.xerces.dom.ParentNode;
import org.htmlunit.cyberneko.xerces.util.DOMMessageFormatter;
import org.htmlunit.cyberneko.xerces.util.URI;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends ParentNode
implements Element,
TypeInfo {
    protected String name_;
    protected AttributeMap attributes_;

    public ElementImpl(CoreDocumentImpl ownerDoc, String name) {
        super(ownerDoc);
        this.name_ = name;
    }

    void rename(String name) {
        if (this.ownerDocument.errorChecking) {
            int colon1 = name.indexOf(58);
            if (colon1 != -1) {
                String msg = DOMMessageFormatter.formatMessage("NAMESPACE_ERR", null);
                throw new DOMException(14, msg);
            }
            if (!CoreDocumentImpl.isXMLName(name, this.ownerDocument.isXML11Version())) {
                String msg = DOMMessageFormatter.formatMessage("INVALID_CHARACTER_ERR", null);
                throw new DOMException(5, msg);
            }
        }
        this.name_ = name;
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public String getNodeName() {
        return this.name_;
    }

    @Override
    public NamedNodeMap getAttributes() {
        if (this.attributes_ == null) {
            this.attributes_ = new AttributeMap(this);
        }
        return this.attributes_;
    }

    @Override
    public Node cloneNode(boolean deep) {
        ElementImpl newnode = (ElementImpl)super.cloneNode(deep);
        if (this.attributes_ != null) {
            newnode.attributes_ = (AttributeMap)this.attributes_.cloneMap(newnode);
        }
        return newnode;
    }

    @Override
    public String getBaseURI() {
        String uri;
        Attr attrNode;
        if (this.attributes_ != null && (attrNode = this.getXMLBaseAttribute()) != null && (uri = attrNode.getNodeValue()).length() != 0) {
            try {
                String parentBaseURI;
                URI _uri = new URI(uri, true);
                if (_uri.isAbsoluteURI()) {
                    return _uri.toString();
                }
                String string = parentBaseURI = this.ownerNode_ != null ? this.ownerNode_.getBaseURI() : null;
                if (parentBaseURI != null) {
                    try {
                        URI _parentBaseURI = new URI(parentBaseURI);
                        _uri.absolutize(_parentBaseURI);
                        return _uri.toString();
                    }
                    catch (URI.MalformedURIException ex) {
                        return null;
                    }
                }
                return null;
            }
            catch (URI.MalformedURIException ex) {
                return null;
            }
        }
        return this.ownerNode_ != null ? this.ownerNode_.getBaseURI() : null;
    }

    protected Attr getXMLBaseAttribute() {
        return (Attr)this.attributes_.getNamedItem("xml:base");
    }

    @Override
    protected void setOwnerDocument(CoreDocumentImpl doc) {
        super.setOwnerDocument(doc);
        if (this.attributes_ != null) {
            this.attributes_.setOwnerDocument(doc);
        }
    }

    @Override
    public String getAttribute(String name) {
        if (this.attributes_ == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes_.getNamedItem(name);
        return attr == null ? "" : attr.getValue();
    }

    @Override
    public Attr getAttributeNode(String name) {
        if (this.attributes_ == null) {
            return null;
        }
        return (Attr)this.attributes_.getNamedItem(name);
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        return new DeepNodeListImpl(this, tagname);
    }

    @Override
    public String getTagName() {
        return this.name_;
    }

    @Override
    public void removeAttribute(String name) {
        if (this.attributes_ == null) {
            return;
        }
        this.attributes_.internalRemoveNamedItem(name, false);
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        if (this.attributes_ == null) {
            String msg = DOMMessageFormatter.formatMessage("NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        return (Attr)this.attributes_.removeItem(oldAttr);
    }

    @Override
    public void setAttribute(String name, String value) {
        Attr newAttr = this.getAttributeNode(name);
        if (newAttr == null) {
            newAttr = this.getOwnerDocument().createAttribute(name);
            if (this.attributes_ == null) {
                this.attributes_ = new AttributeMap(this);
            }
            newAttr.setNodeValue(value);
            this.attributes_.setNamedItem(newAttr);
        } else {
            newAttr.setNodeValue(value);
        }
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        if (this.ownerDocument.errorChecking && newAttr.getOwnerDocument() != this.ownerDocument) {
            String msg = DOMMessageFormatter.formatMessage("WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, msg);
        }
        if (this.attributes_ == null) {
            this.attributes_ = new AttributeMap(this);
        }
        return (Attr)this.attributes_.setNamedItem(newAttr);
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) {
        if (this.attributes_ == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes_.getNamedItemNS(namespaceURI, localName);
        return attr == null ? "" : attr.getValue();
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        String localName;
        String prefix;
        int index = qualifiedName.indexOf(58);
        if (index < 0) {
            prefix = null;
            localName = qualifiedName;
        } else {
            prefix = qualifiedName.substring(0, index);
            localName = qualifiedName.substring(index + 1);
        }
        Attr newAttr = this.getAttributeNodeNS(namespaceURI, localName);
        if (newAttr == null) {
            newAttr = this.getOwnerDocument().createAttributeNS(namespaceURI, qualifiedName);
            if (this.attributes_ == null) {
                this.attributes_ = new AttributeMap(this);
            }
            newAttr.setNodeValue(value);
            this.attributes_.setNamedItemNS(newAttr);
        } else {
            if (newAttr instanceof AttrNSImpl) {
                ((AttrNSImpl)newAttr).name = prefix != null ? prefix + ":" + localName : localName;
            } else {
                newAttr = ((CoreDocumentImpl)this.getOwnerDocument()).createAttributeNS(namespaceURI, qualifiedName, localName);
                this.attributes_.setNamedItemNS(newAttr);
            }
            newAttr.setNodeValue(value);
        }
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) {
        if (this.attributes_ == null) {
            return;
        }
        this.attributes_.internalRemoveNamedItemNS(namespaceURI, this.name_, false);
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        if (this.attributes_ == null) {
            return null;
        }
        return (Attr)this.attributes_.getNamedItemNS(namespaceURI, localName);
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        if (this.ownerDocument.errorChecking && newAttr.getOwnerDocument() != this.ownerDocument) {
            String msg = DOMMessageFormatter.formatMessage("WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, msg);
        }
        if (this.attributes_ == null) {
            this.attributes_ = new AttributeMap(this);
        }
        return (Attr)this.attributes_.setNamedItemNS(newAttr);
    }

    @Override
    public boolean hasAttributes() {
        return this.attributes_ != null && this.attributes_.getLength() != 0;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeNodeNS(namespaceURI, localName) != null;
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return new DeepNodeListImpl(this, namespaceURI, localName);
    }

    @Override
    public boolean isEqualNode(Node arg) {
        if (!super.isEqualNode(arg)) {
            return false;
        }
        boolean hasAttrs = this.hasAttributes();
        if (hasAttrs != arg.hasAttributes()) {
            return false;
        }
        if (hasAttrs) {
            NamedNodeMap map1 = this.getAttributes();
            NamedNodeMap map2 = arg.getAttributes();
            int len = map1.getLength();
            if (len != map2.getLength()) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                Node n2;
                Node n1 = map1.item(i);
                if (!(n1.getLocalName() == null ? (n2 = map2.getNamedItem(n1.getNodeName())) == null || !n1.isEqualNode(n2) : (n2 = map2.getNamedItemNS(n1.getNamespaceURI(), n1.getLocalName())) == null || !n1.isEqualNode(n2))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void setIdAttributeNode(Attr at, boolean makeId) {
        if (this.ownerDocument.errorChecking && at.getOwnerElement() != this) {
            String msg = DOMMessageFormatter.formatMessage("NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        ((AttrImpl)at).isIdAttribute(makeId);
        if (!makeId) {
            this.ownerDocument.removeIdentifier(at.getValue());
        } else {
            this.ownerDocument.putIdentifier(at.getValue(), this);
        }
    }

    @Override
    public void setIdAttribute(String name, boolean makeId) {
        Attr at = this.getAttributeNode(name);
        if (at == null) {
            String msg = DOMMessageFormatter.formatMessage("NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        if (this.ownerDocument.errorChecking && at.getOwnerElement() != this) {
            String msg = DOMMessageFormatter.formatMessage("NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        ((AttrImpl)at).isIdAttribute(makeId);
        if (!makeId) {
            this.ownerDocument.removeIdentifier(at.getValue());
        } else {
            this.ownerDocument.putIdentifier(at.getValue(), this);
        }
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean makeId) {
        Attr at = this.getAttributeNodeNS(namespaceURI, localName);
        if (at == null) {
            String msg = DOMMessageFormatter.formatMessage("NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        if (this.ownerDocument.errorChecking && at.getOwnerElement() != this) {
            String msg = DOMMessageFormatter.formatMessage("NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        ((AttrImpl)at).isIdAttribute(makeId);
        if (!makeId) {
            this.ownerDocument.removeIdentifier(at.getValue());
        } else {
            this.ownerDocument.putIdentifier(at.getValue(), this);
        }
    }

    @Override
    public String getTypeName() {
        return null;
    }

    @Override
    public String getTypeNamespace() {
        return null;
    }

    @Override
    public boolean isDerivedFrom(String typeNamespaceArg, String typeNameArg, int derivationMethod) {
        return false;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return this;
    }

    void moveSpecifiedAttributes(ElementImpl el) {
        if (el.hasAttributes()) {
            if (this.attributes_ == null) {
                this.attributes_ = new AttributeMap(this);
            }
            this.attributes_.moveSpecifiedAttributes(el.attributes_);
        }
    }
}

