/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.typedarrays;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.RandomAccess;
import org.htmlunit.corejs.javascript.AbstractEcmaObjectOperations;
import org.htmlunit.corejs.javascript.ArrayLikeAbstractOperations;
import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.Constructable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ExternalArrayData;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.IdFunctionObject;
import org.htmlunit.corejs.javascript.NativeArray;
import org.htmlunit.corejs.javascript.NativeArrayIterator;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Symbol;
import org.htmlunit.corejs.javascript.SymbolKey;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.corejs.javascript.Wrapper;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBufferView;
import org.htmlunit.corejs.javascript.typedarrays.NativeTypedArrayIterator;

public abstract class NativeTypedArrayView<T>
extends NativeArrayBufferView
implements List<T>,
RandomAccess,
ExternalArrayData {
    private static final long serialVersionUID = -4963053773152251274L;
    protected final int length;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_includes = 4;
    private static final int Id_indexOf = 5;
    private static final int Id_lastIndexOf = 6;
    private static final int Id_slice = 7;
    private static final int Id_join = 8;
    private static final int Id_reverse = 9;
    private static final int Id_fill = 10;
    private static final int Id_sort = 11;
    private static final int Id_copyWithin = 12;
    private static final int Id_get = 13;
    private static final int Id_set = 14;
    private static final int Id_subarray = 15;
    private static final int Id_at = 16;
    private static final int Id_entries = 17;
    private static final int Id_keys = 18;
    private static final int Id_values = 19;
    private static final int Id_every = 20;
    private static final int Id_filter = 21;
    private static final int Id_forEach = 22;
    private static final int Id_map = 23;
    private static final int Id_some = 24;
    private static final int Id_find = 25;
    private static final int Id_findIndex = 26;
    private static final int Id_findLast = 27;
    private static final int Id_findLastIndex = 28;
    private static final int Id_reduce = 29;
    private static final int Id_reduceRight = 30;
    private static final int Id_toReversed = 31;
    private static final int Id_toSorted = 32;
    private static final int Id_with = 33;
    private static final int SymbolId_iterator = 34;
    protected static final int MAX_PROTOTYPE_ID = 34;
    private static final int Id_length = 4;
    private static final int Id_BYTES_PER_ELEMENT = 5;
    private static final int MAX_INSTANCE_ID = 5;

    protected NativeTypedArrayView() {
        this.length = 0;
    }

    protected NativeTypedArrayView(NativeArrayBuffer ab, int off, int len, int byteLen) {
        super(ab, off, byteLen);
        this.length = len;
    }

    @Override
    public Object get(int index, Scriptable start) {
        return this.js_get(index);
    }

    @Override
    public Object get(String name, Scriptable start) {
        int ix;
        Optional<Double> num = ScriptRuntime.canonicalNumericIndexString(name);
        if (num.isPresent() && (ix = NativeTypedArrayView.toIndex(num.get())) >= 0) {
            return this.js_get(ix);
        }
        return super.get(name, start);
    }

    @Override
    public boolean has(int index, Scriptable start) {
        return !this.checkIndex(index);
    }

    @Override
    public boolean has(String name, Scriptable start) {
        int ix;
        Optional<Double> num = ScriptRuntime.canonicalNumericIndexString(name);
        if (num.isPresent() && (ix = NativeTypedArrayView.toIndex(num.get())) >= 0) {
            return !this.checkIndex(ix);
        }
        return super.has(name, start);
    }

    @Override
    public void put(int index, Scriptable start, Object val) {
        this.js_set(index, val);
    }

    @Override
    public void put(String name, Scriptable start, Object val) {
        Optional<Double> num = ScriptRuntime.canonicalNumericIndexString(name);
        if (num.isPresent()) {
            int ix = NativeTypedArrayView.toIndex(num.get());
            if (ix >= 0) {
                this.js_set(ix, val);
            }
        } else {
            super.put(name, start, val);
        }
    }

    @Override
    public void delete(int index) {
    }

    @Override
    public void delete(String name) {
        Optional<Double> num = ScriptRuntime.canonicalNumericIndexString(name);
        if (!num.isPresent()) {
            super.delete(name);
        }
    }

    @Override
    public Object[] getIds() {
        Object[] ret = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            ret[i] = i;
        }
        return ret;
    }

    private static int toIndex(double num) {
        int ix = (int)num;
        if ((double)ix == num && ix >= 0) {
            return ix;
        }
        return -1;
    }

    protected boolean checkIndex(int index) {
        return index < 0 || index >= this.length;
    }

    public abstract int getBytesPerElement();

    protected abstract NativeTypedArrayView<T> construct(NativeArrayBuffer var1, int var2, int var3);

    protected abstract Object js_get(int var1);

    protected abstract Object js_set(int var1, Object var2);

    protected abstract NativeTypedArrayView<T> realThis(Scriptable var1, IdFunctionObject var2);

    private NativeArrayBuffer makeArrayBuffer(Context cx, Scriptable scope, int length) {
        return (NativeArrayBuffer)cx.newObject(scope, "ArrayBuffer", new Object[]{(double)length * (double)this.getBytesPerElement()});
    }

    private NativeTypedArrayView<T> js_constructor(Context cx, Scriptable scope, Object[] args) {
        if (!NativeTypedArrayView.isArg(args, 0)) {
            return this.construct(new NativeArrayBuffer(), 0, 0);
        }
        Object arg0 = args[0];
        if (arg0 == null) {
            return this.construct(new NativeArrayBuffer(), 0, 0);
        }
        if (arg0 instanceof Number || arg0 instanceof String) {
            int length = ScriptRuntime.toInt32(arg0);
            NativeArrayBuffer buffer = this.makeArrayBuffer(cx, scope, length);
            return this.construct(buffer, 0, length);
        }
        if (arg0 instanceof NativeTypedArrayView) {
            NativeTypedArrayView src = (NativeTypedArrayView)arg0;
            NativeArrayBuffer na = this.makeArrayBuffer(cx, scope, src.length);
            NativeTypedArrayView<T> v = this.construct(na, 0, src.length);
            for (int i = 0; i < src.length; ++i) {
                v.js_set(i, src.js_get(i));
            }
            return v;
        }
        if (arg0 instanceof NativeArrayBuffer) {
            NativeArrayBuffer na = (NativeArrayBuffer)arg0;
            int byteOff = NativeTypedArrayView.isArg(args, 1) ? ScriptRuntime.toInt32(args[1]) : 0;
            int byteLen = NativeTypedArrayView.isArg(args, 2) ? ScriptRuntime.toInt32(args[2]) * this.getBytesPerElement() : na.getLength() - byteOff;
            if (byteOff < 0 || byteOff > na.buffer.length) {
                throw ScriptRuntime.rangeError("offset out of range");
            }
            if (byteLen < 0 || byteOff + byteLen > na.buffer.length) {
                throw ScriptRuntime.rangeError("length out of range");
            }
            if (byteOff % this.getBytesPerElement() != 0) {
                throw ScriptRuntime.rangeError("offset must be a multiple of the byte size");
            }
            if (byteLen % this.getBytesPerElement() != 0) {
                throw ScriptRuntime.rangeError("offset and buffer must be a multiple of the byte size");
            }
            return this.construct(na, byteOff, byteLen / this.getBytesPerElement());
        }
        if (arg0 instanceof NativeArray) {
            NativeArray array = (NativeArray)arg0;
            NativeArrayBuffer na = this.makeArrayBuffer(cx, scope, array.size());
            NativeTypedArrayView<T> v = this.construct(na, 0, array.size());
            for (int i = 0; i < array.size(); ++i) {
                Object value = array.get(i, (Scriptable)array);
                if (value == Scriptable.NOT_FOUND || value == Undefined.instance) {
                    v.js_set(i, ScriptRuntime.NaNobj);
                    continue;
                }
                if (value instanceof Wrapper) {
                    v.js_set(i, ((Wrapper)value).unwrap());
                    continue;
                }
                v.js_set(i, value);
            }
            return v;
        }
        if (ScriptRuntime.isArrayObject(arg0)) {
            Object[] arrayElements = ScriptRuntime.getArrayElements((Scriptable)arg0);
            NativeArrayBuffer na = this.makeArrayBuffer(cx, scope, arrayElements.length);
            NativeTypedArrayView<T> v = this.construct(na, 0, arrayElements.length);
            for (int i = 0; i < arrayElements.length; ++i) {
                v.js_set(i, arrayElements[i]);
            }
            return v;
        }
        throw ScriptRuntime.constructError("Error", "invalid argument");
    }

    private void setRange(NativeTypedArrayView<T> v, int off) {
        if (off >= this.length) {
            throw ScriptRuntime.rangeError("offset out of range");
        }
        if (v.length > this.length - off) {
            throw ScriptRuntime.rangeError("source array too long");
        }
        if (v.arrayBuffer == this.arrayBuffer) {
            int i;
            Object[] tmp = new Object[v.length];
            for (i = 0; i < v.length; ++i) {
                tmp[i] = v.js_get(i);
            }
            for (i = 0; i < v.length; ++i) {
                this.js_set(i + off, tmp[i]);
            }
        } else {
            for (int i = 0; i < v.length; ++i) {
                this.js_set(i + off, v.js_get(i));
            }
        }
    }

    private void setRange(NativeArray a, int off) {
        if (off > this.length) {
            throw ScriptRuntime.rangeError("offset out of range");
        }
        if (off + a.size() > this.length) {
            throw ScriptRuntime.rangeError("offset + length out of range");
        }
        int pos = off;
        for (Object val : a) {
            this.js_set(pos, val);
            ++pos;
        }
    }

    private String js_toString(Context cx, Scriptable scope, boolean useLocale) {
        StringBuilder builder = new StringBuilder();
        if (this.length > 0) {
            Object elem = this.getElemForToString(cx, scope, 0, useLocale);
            builder.append(ScriptRuntime.toString(elem));
        }
        for (int i = 1; i < this.length; ++i) {
            builder.append(',');
            Object elem = this.getElemForToString(cx, scope, i, useLocale);
            builder.append(ScriptRuntime.toString(elem));
        }
        return builder.toString();
    }

    private Object getElemForToString(Context cx, Scriptable scope, int index, boolean useLocale) {
        Object elem = this.js_get(index);
        if (useLocale) {
            Callable fun = ScriptRuntime.getPropFunctionAndThis(elem, "toLocaleString", cx, scope);
            Scriptable funThis = ScriptRuntime.lastStoredScriptable(cx);
            return fun.call(cx, scope, funThis, ScriptRuntime.emptyArgs);
        }
        return elem;
    }

    private Boolean js_includes(Object[] args) {
        long start;
        Object compareTo;
        Object object = compareTo = args.length > 0 ? args[0] : Undefined.instance;
        if (this.length == 0) {
            return Boolean.FALSE;
        }
        if (args.length < 2) {
            start = 0L;
        } else {
            start = (long)ScriptRuntime.toInteger(args[1]);
            if (start < 0L && (start += (long)this.length) < 0L) {
                start = 0L;
            }
            if (start > (long)(this.length - 1)) {
                return Boolean.FALSE;
            }
        }
        for (int i = (int)start; i < this.length; ++i) {
            Object val = this.js_get(i);
            if (!ScriptRuntime.sameZero(val, compareTo)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Object js_indexOf(Object[] args) {
        long start;
        Object compareTo;
        Object object = compareTo = args.length > 0 ? args[0] : Undefined.instance;
        if (this.length == 0) {
            return -1;
        }
        if (args.length < 2) {
            start = 0L;
        } else {
            start = (long)ScriptRuntime.toInteger(args[1]);
            if (start < 0L && (start += (long)this.length) < 0L) {
                start = 0L;
            }
            if (start > (long)(this.length - 1)) {
                return -1;
            }
        }
        for (int i = (int)start; i < this.length; ++i) {
            Object val = this.js_get(i);
            if (val == NOT_FOUND || !ScriptRuntime.shallowEq(val, compareTo)) continue;
            return (long)i;
        }
        return -1;
    }

    private Object js_lastIndexOf(Object[] args) {
        long start;
        Object compareTo;
        Object object = compareTo = args.length > 0 ? args[0] : Undefined.instance;
        if (this.length == 0) {
            return -1;
        }
        if (args.length < 2) {
            start = (long)this.length - 1L;
        } else {
            start = (long)ScriptRuntime.toInteger(args[1]);
            if (start >= (long)this.length) {
                start = (long)this.length - 1L;
            } else if (start < 0L) {
                start += (long)this.length;
            }
            if (start < 0L) {
                return -1;
            }
        }
        for (int i = (int)start; i >= 0; --i) {
            Object val = this.js_get(i);
            if (val == NOT_FOUND || !ScriptRuntime.shallowEq(val, compareTo)) continue;
            return (long)i;
        }
        return -1;
    }

    private Scriptable js_slice(Context cx, Scriptable scope, Object[] args) {
        long end;
        long begin;
        if (args.length == 0) {
            begin = 0L;
            end = this.length;
        } else {
            begin = ArrayLikeAbstractOperations.toSliceIndex(ScriptRuntime.toInteger(args[0]), this.length);
            end = args.length == 1 || args[1] == Undefined.instance ? (long)this.length : ArrayLikeAbstractOperations.toSliceIndex(ScriptRuntime.toInteger(args[1]), this.length);
        }
        if (end - begin > Integer.MAX_VALUE) {
            String msg = ScriptRuntime.getMessageById("msg.arraylength.bad", new Object[0]);
            throw ScriptRuntime.rangeError(msg);
        }
        return this.typedArraySpeciesCreate(cx, scope, new Object[]{this.arrayBuffer, begin * (long)this.getBytesPerElement(), Math.max(0L, end - begin)}, "slice");
    }

    private String js_join(Object[] args) {
        String str;
        String separator;
        String string = separator = args.length < 1 || args[0] == Undefined.instance ? "," : ScriptRuntime.toString(args[0]);
        if (this.length == 0) {
            return "";
        }
        String[] buf = new String[this.length];
        int total_size = 0;
        for (int i = 0; i != this.length; ++i) {
            Object temp = this.js_get(i);
            if (temp == null || temp == Undefined.instance) continue;
            str = ScriptRuntime.toString(temp);
            total_size += str.length();
            buf[i] = str;
        }
        StringBuilder sb = new StringBuilder(total_size += (this.length - 1) * separator.length());
        for (int i = 0; i != this.length; ++i) {
            if (i != 0) {
                sb.append(separator);
            }
            if ((str = buf[i]) == null) continue;
            sb.append(str);
        }
        return sb.toString();
    }

    private NativeTypedArrayView<T> js_reverse() {
        int i = 0;
        for (int j = this.length - 1; i < j; ++i, --j) {
            Object temp = this.js_get(i);
            this.js_set(i, this.js_get(j));
            this.js_set(j, temp);
        }
        return this;
    }

    private NativeTypedArrayView<T> js_fill(Object[] args) {
        long relativeStart = 0L;
        if (args.length >= 2) {
            relativeStart = (long)ScriptRuntime.toInteger(args[1]);
        }
        long k = relativeStart < 0L ? Math.max((long)this.length + relativeStart, 0L) : Math.min(relativeStart, (long)this.length);
        long relativeEnd = this.length;
        if (args.length >= 3 && !Undefined.isUndefined(args[2])) {
            relativeEnd = (long)ScriptRuntime.toInteger(args[2]);
        }
        long fin = relativeEnd < 0L ? Math.max((long)this.length + relativeEnd, 0L) : Math.min(relativeEnd, (long)this.length);
        Object value = args.length > 0 ? args[0] : Undefined.instance;
        int i = (int)k;
        while ((long)i < fin) {
            this.js_set(i, value);
            ++i;
        }
        return this;
    }

    private Scriptable js_sort(Context cx, Scriptable scope, Object[] args) {
        Object[] working = this.sortTemporaryArray(cx, scope, args);
        for (int i = 0; i < this.length; ++i) {
            this.js_set(i, working[i]);
        }
        return this;
    }

    private Object[] sortTemporaryArray(Context cx, Scriptable scope, Object[] args) {
        Comparator<Object> comparator = args.length > 0 && Undefined.instance != args[0] ? ArrayLikeAbstractOperations.getSortComparator(cx, scope, args) : Comparator.comparingDouble(e -> ((Number)e).doubleValue());
        Object[] working = this.toArray();
        Arrays.sort(working, comparator);
        return working;
    }

    private Object js_copyWithin(Object[] args) {
        Object targetArg = args.length >= 1 ? args[0] : Undefined.instance;
        long relativeTarget = (long)ScriptRuntime.toInteger(targetArg);
        long to = relativeTarget < 0L ? Math.max((long)this.length + relativeTarget, 0L) : Math.min(relativeTarget, (long)this.length);
        Object startArg = args.length >= 2 ? args[1] : Undefined.instance;
        long relativeStart = (long)ScriptRuntime.toInteger(startArg);
        long from = relativeStart < 0L ? Math.max((long)this.length + relativeStart, 0L) : Math.min(relativeStart, (long)this.length);
        long relativeEnd = this.length;
        if (args.length >= 3 && !Undefined.isUndefined(args[2])) {
            relativeEnd = (long)ScriptRuntime.toInteger(args[2]);
        }
        long fin = relativeEnd < 0L ? Math.max((long)this.length + relativeEnd, 0L) : Math.min(relativeEnd, (long)this.length);
        long count = Math.min(fin - from, (long)this.length - to);
        int direction = 1;
        if (from < to && to < from + count) {
            direction = -1;
            from = from + count - 1L;
            to = to + count - 1L;
        }
        while (count > 0L) {
            Object temp = this.js_get((int)from);
            this.js_set((int)to, temp);
            from += (long)direction;
            to += (long)direction;
            --count;
        }
        return this;
    }

    private Object js_subarray(Context cx, Scriptable scope, int s, int e) {
        int start = s < 0 ? this.length + s : s;
        int end = e < 0 ? this.length + e : e;
        start = Math.max(0, start);
        end = Math.min(this.length, end);
        int len = Math.max(0, end - start);
        int byteOff = Math.min(this.getByteOffset() + start * this.getBytesPerElement(), this.arrayBuffer.getLength());
        return cx.newObject(scope, this.getClassName(), new Object[]{this.arrayBuffer, byteOff, len});
    }

    private Object js_at(Scriptable thisObj, Object[] args) {
        long k;
        long relativeIndex = 0L;
        if (args.length >= 1) {
            relativeIndex = (long)ScriptRuntime.toInteger(args[0]);
        }
        long l = k = relativeIndex >= 0L ? relativeIndex : (long)this.length + relativeIndex;
        if (k < 0L || k >= (long)this.length) {
            return Undefined.instance;
        }
        return NativeTypedArrayView.getProperty(thisObj, (int)k);
    }

    private Scriptable typedArraySpeciesCreate(Context cx, Scriptable scope, Object[] args, String methodName) {
        Scriptable topLevelScope = ScriptableObject.getTopLevelScope(scope);
        Function defaultConstructor = ScriptRuntime.getExistingCtor(cx, topLevelScope, this.getClassName());
        Constructable constructable = AbstractEcmaObjectOperations.speciesConstructor(cx, this, defaultConstructor);
        Scriptable newArray = constructable.construct(cx, scope, args);
        if (!(newArray instanceof NativeTypedArrayView)) {
            throw ScriptRuntime.typeErrorById("msg.typed.array.ctor.incompatible", methodName);
        }
        return newArray;
    }

    private Object js_toReversed(Context cx, Scriptable scope) {
        NativeArrayBuffer newBuffer = new NativeArrayBuffer(this.length * this.getBytesPerElement());
        Scriptable result = cx.newObject(scope, this.getClassName(), new Object[]{newBuffer, 0, this.length, this.getBytesPerElement()});
        for (int k = 0; k < this.length; ++k) {
            int from = this.length - k - 1;
            Object fromValue = this.js_get(from);
            result.put(k, result, fromValue);
        }
        return result;
    }

    private Object js_toSorted(Context cx, Scriptable scope, Object[] args) {
        Object[] working = this.sortTemporaryArray(cx, scope, args);
        NativeArrayBuffer newBuffer = new NativeArrayBuffer(this.length * this.getBytesPerElement());
        Scriptable result = cx.newObject(scope, this.getClassName(), new Object[]{newBuffer, 0, this.length, this.getBytesPerElement()});
        for (int k = 0; k < this.length; ++k) {
            result.put(k, result, working[k]);
        }
        return result;
    }

    private Object js_with(Context cx, Scriptable scope, Object[] args) {
        long relativeIndex = args.length > 0 ? (long)((int)ScriptRuntime.toInteger(args[0])) : 0L;
        long actualIndex = relativeIndex >= 0L ? relativeIndex : (long)this.length + relativeIndex;
        Double argsValue = args.length > 1 ? ScriptRuntime.toNumber(args[1]) : 0.0;
        if (actualIndex < 0L || actualIndex >= (long)this.length) {
            throw ScriptRuntime.rangeError("index out of range");
        }
        NativeArrayBuffer newBuffer = new NativeArrayBuffer(this.length * this.getBytesPerElement());
        Scriptable result = cx.newObject(scope, this.getClassName(), new Object[]{newBuffer, 0, this.length, this.getBytesPerElement()});
        for (int k = 0; k < this.length; ++k) {
            Double fromValue = (long)k == actualIndex ? argsValue : this.js_get(k);
            result.put(k, result, (Object)fromValue);
        }
        return result;
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(this.getClassName())) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        switch (id) {
            case 1: {
                if (thisObj != null) {
                    throw ScriptRuntime.typeErrorById("msg.only.from.new", this.getClassName());
                }
                return this.js_constructor(cx, scope, args);
            }
            case 2: {
                return super.js_toString(cx, scope, false);
            }
            case 3: {
                return super.js_toString(cx, scope, true);
            }
            case 4: {
                return super.js_includes(args);
            }
            case 5: {
                return super.js_indexOf(args);
            }
            case 6: {
                return super.js_lastIndexOf(args);
            }
            case 7: {
                return super.js_slice(cx, scope, args);
            }
            case 8: {
                return super.js_join(args);
            }
            case 9: {
                return super.js_reverse();
            }
            case 10: {
                return super.js_fill(args);
            }
            case 11: {
                return super.js_sort(cx, scope, args);
            }
            case 12: {
                return super.js_copyWithin(args);
            }
            case 13: {
                if (args.length > 0) {
                    return this.realThis(thisObj, f).js_get(ScriptRuntime.toInt32(args[0]));
                }
                throw ScriptRuntime.constructError("Error", "invalid arguments");
            }
            case 14: {
                if (args.length > 0) {
                    NativeTypedArrayView<T> self = this.realThis(thisObj, f);
                    if (args[0] instanceof NativeTypedArrayView) {
                        int offset = NativeTypedArrayView.isArg(args, 1) ? ScriptRuntime.toInt32(args[1]) : 0;
                        NativeTypedArrayView nativeView = (NativeTypedArrayView)args[0];
                        super.setRange(nativeView, offset);
                        return Undefined.instance;
                    }
                    if (args[0] instanceof NativeArray) {
                        int offset = NativeTypedArrayView.isArg(args, 1) ? ScriptRuntime.toInt32(args[1]) : 0;
                        super.setRange((NativeArray)args[0], offset);
                        return Undefined.instance;
                    }
                    if (args[0] instanceof Scriptable) {
                        return Undefined.instance;
                    }
                    if (NativeTypedArrayView.isArg(args, 2)) {
                        return self.js_set(ScriptRuntime.toInt32(args[0]), args[1]);
                    }
                }
                throw ScriptRuntime.constructError("Error", "invalid arguments");
            }
            case 15: {
                NativeTypedArrayView<T> self = this.realThis(thisObj, f);
                int start = NativeTypedArrayView.isArg(args, 0) ? ScriptRuntime.toInt32(args[0]) : 0;
                int end = NativeTypedArrayView.isArg(args, 1) ? ScriptRuntime.toInt32(args[1]) : self.length;
                return super.js_subarray(cx, scope, start, end);
            }
            case 16: {
                NativeTypedArrayView<T> self = this.realThis(thisObj, f);
                return super.js_at(thisObj, args);
            }
            case 17: {
                NativeTypedArrayView<T> self = this.realThis(thisObj, f);
                return new NativeArrayIterator(scope, self, NativeArrayIterator.ARRAY_ITERATOR_TYPE.ENTRIES);
            }
            case 18: {
                NativeTypedArrayView<T> self = this.realThis(thisObj, f);
                return new NativeArrayIterator(scope, self, NativeArrayIterator.ARRAY_ITERATOR_TYPE.KEYS);
            }
            case 19: {
                NativeTypedArrayView<T> self = this.realThis(thisObj, f);
                return new NativeArrayIterator(scope, self, NativeArrayIterator.ARRAY_ITERATOR_TYPE.VALUES);
            }
            case 20: {
                return ArrayLikeAbstractOperations.iterativeMethod(cx, f, ArrayLikeAbstractOperations.IterativeOperation.EVERY, scope, thisObj, args);
            }
            case 21: {
                Object array = ArrayLikeAbstractOperations.iterativeMethod(cx, f, ArrayLikeAbstractOperations.IterativeOperation.FILTER, scope, thisObj, args);
                return super.typedArraySpeciesCreate(cx, scope, new Object[]{array}, "filter");
            }
            case 22: {
                return ArrayLikeAbstractOperations.iterativeMethod(cx, f, ArrayLikeAbstractOperations.IterativeOperation.FOR_EACH, scope, thisObj, args);
            }
            case 23: {
                Object array = ArrayLikeAbstractOperations.iterativeMethod(cx, f, ArrayLikeAbstractOperations.IterativeOperation.MAP, scope, thisObj, args);
                return super.typedArraySpeciesCreate(cx, scope, new Object[]{array}, "map");
            }
            case 24: {
                return ArrayLikeAbstractOperations.iterativeMethod(cx, f, ArrayLikeAbstractOperations.IterativeOperation.SOME, scope, thisObj, args);
            }
            case 25: {
                return ArrayLikeAbstractOperations.iterativeMethod(cx, f, ArrayLikeAbstractOperations.IterativeOperation.FIND, scope, thisObj, args);
            }
            case 26: {
                return ArrayLikeAbstractOperations.iterativeMethod(cx, f, ArrayLikeAbstractOperations.IterativeOperation.FIND_INDEX, scope, thisObj, args);
            }
            case 27: {
                return ArrayLikeAbstractOperations.iterativeMethod(cx, f, ArrayLikeAbstractOperations.IterativeOperation.FIND_LAST, scope, thisObj, args);
            }
            case 28: {
                return ArrayLikeAbstractOperations.iterativeMethod(cx, f, ArrayLikeAbstractOperations.IterativeOperation.FIND_LAST_INDEX, scope, thisObj, args);
            }
            case 29: {
                return ArrayLikeAbstractOperations.reduceMethod(cx, ArrayLikeAbstractOperations.ReduceOperation.REDUCE, scope, thisObj, args);
            }
            case 30: {
                return ArrayLikeAbstractOperations.reduceMethod(cx, ArrayLikeAbstractOperations.ReduceOperation.REDUCE_RIGHT, scope, thisObj, args);
            }
            case 31: {
                return super.js_toReversed(cx, scope);
            }
            case 32: {
                return super.js_toSorted(cx, scope, args);
            }
            case 33: {
                return super.js_with(cx, scope, args);
            }
            case 34: {
                return new NativeArrayIterator(scope, thisObj, NativeArrayIterator.ARRAY_ITERATOR_TYPE.VALUES);
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    @Override
    protected void initPrototypeId(int id) {
        String s;
        int arity;
        if (id == 34) {
            this.initPrototypeMethod((Object)this.getClassName(), id, SymbolKey.ITERATOR, "[Symbol.iterator]", 0);
            return;
        }
        String fnName = null;
        switch (id) {
            case 1: {
                arity = 3;
                s = "constructor";
                break;
            }
            case 2: {
                arity = 0;
                s = "toString";
                break;
            }
            case 3: {
                arity = 0;
                s = "toLocaleString";
                break;
            }
            case 4: {
                arity = 1;
                s = "includes";
                break;
            }
            case 5: {
                arity = 1;
                s = "indexOf";
                break;
            }
            case 6: {
                arity = 1;
                s = "lastIndexOf";
                break;
            }
            case 7: {
                arity = 2;
                s = "slice";
                break;
            }
            case 8: {
                arity = 1;
                s = "join";
                break;
            }
            case 9: {
                arity = 0;
                s = "reverse";
                break;
            }
            case 10: {
                arity = 1;
                s = "fill";
                break;
            }
            case 11: {
                arity = 1;
                s = "sort";
                break;
            }
            case 12: {
                arity = 2;
                s = "copyWithin";
                break;
            }
            case 13: {
                arity = 1;
                s = "get";
                break;
            }
            case 14: {
                arity = 2;
                s = "set";
                break;
            }
            case 15: {
                arity = 2;
                s = "subarray";
                break;
            }
            case 16: {
                arity = 1;
                s = "at";
                break;
            }
            case 17: {
                arity = 0;
                s = "entries";
                break;
            }
            case 18: {
                arity = 0;
                s = "keys";
                break;
            }
            case 19: {
                arity = 0;
                s = "values";
                break;
            }
            case 20: {
                arity = 1;
                s = "every";
                break;
            }
            case 21: {
                arity = 1;
                s = "filter";
                break;
            }
            case 22: {
                arity = 1;
                s = "forEach";
                break;
            }
            case 23: {
                arity = 1;
                s = "map";
                break;
            }
            case 24: {
                arity = 1;
                s = "some";
                break;
            }
            case 25: {
                arity = 1;
                s = "find";
                break;
            }
            case 26: {
                arity = 1;
                s = "findIndex";
                break;
            }
            case 27: {
                arity = 1;
                s = "findLast";
                break;
            }
            case 28: {
                arity = 1;
                s = "findLastIndex";
                break;
            }
            case 29: {
                arity = 1;
                s = "reduce";
                break;
            }
            case 30: {
                arity = 1;
                s = "reduceRight";
                break;
            }
            case 32: {
                arity = 1;
                s = "toSorted";
                break;
            }
            case 31: {
                arity = 0;
                s = "toReversed";
                break;
            }
            case 33: {
                arity = 2;
                s = "with";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod((Object)this.getClassName(), id, s, fnName, arity);
    }

    @Override
    protected int findPrototypeId(Symbol k) {
        if (SymbolKey.ITERATOR.equals(k)) {
            return 34;
        }
        return 0;
    }

    @Override
    protected int findPrototypeId(String s) {
        int id;
        switch (s) {
            case "constructor": {
                id = 1;
                break;
            }
            case "toString": {
                id = 2;
                break;
            }
            case "toLocaleString": {
                id = 3;
                break;
            }
            case "includes": {
                id = 4;
                break;
            }
            case "indexOf": {
                id = 5;
                break;
            }
            case "lastIndexOf": {
                id = 6;
                break;
            }
            case "slice": {
                id = 7;
                break;
            }
            case "join": {
                id = 8;
                break;
            }
            case "reverse": {
                id = 9;
                break;
            }
            case "fill": {
                id = 10;
                break;
            }
            case "sort": {
                id = 11;
                break;
            }
            case "copyWithin": {
                id = 12;
                break;
            }
            case "get": {
                id = 13;
                break;
            }
            case "set": {
                id = 14;
                break;
            }
            case "subarray": {
                id = 15;
                break;
            }
            case "at": {
                id = 16;
                break;
            }
            case "entries": {
                id = 17;
                break;
            }
            case "keys": {
                id = 18;
                break;
            }
            case "values": {
                id = 19;
                break;
            }
            case "every": {
                id = 20;
                break;
            }
            case "filter": {
                id = 21;
                break;
            }
            case "forEach": {
                id = 22;
                break;
            }
            case "map": {
                id = 23;
                break;
            }
            case "some": {
                id = 24;
                break;
            }
            case "find": {
                id = 25;
                break;
            }
            case "findIndex": {
                id = 26;
                break;
            }
            case "findLast": {
                id = 27;
                break;
            }
            case "findLastIndex": {
                id = 28;
                break;
            }
            case "reduce": {
                id = 29;
                break;
            }
            case "reduceRight": {
                id = 30;
                break;
            }
            case "toSorted": {
                id = 32;
                break;
            }
            case "toReversed": {
                id = 31;
                break;
            }
            case "with": {
                id = 33;
                break;
            }
            default: {
                id = 0;
            }
        }
        return id;
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject ctor) {
        ctor.defineProperty("BYTES_PER_ELEMENT", (Object)ScriptRuntime.wrapInt(this.getBytesPerElement()), 7);
        super.fillConstructorProperties(ctor);
    }

    @Override
    protected int getMaxInstanceId() {
        return 5;
    }

    @Override
    protected String getInstanceIdName(int id) {
        switch (id) {
            case 4: {
                return "length";
            }
            case 5: {
                return "BYTES_PER_ELEMENT";
            }
        }
        return super.getInstanceIdName(id);
    }

    @Override
    protected Object getInstanceIdValue(int id) {
        switch (id) {
            case 4: {
                return ScriptRuntime.wrapInt(this.length);
            }
            case 5: {
                return ScriptRuntime.wrapInt(this.getBytesPerElement());
            }
        }
        return super.getInstanceIdValue(id);
    }

    @Override
    protected int findInstanceIdInfo(String s) {
        int id;
        switch (s) {
            case "length": {
                id = 4;
                break;
            }
            case "BYTES_PER_ELEMENT": {
                id = 5;
                break;
            }
            default: {
                id = 0;
            }
        }
        if (id == 0) {
            return super.findInstanceIdInfo(s);
        }
        if (id == 5) {
            return NativeTypedArrayView.instanceIdInfo(7, id);
        }
        return NativeTypedArrayView.instanceIdInfo(5, id);
    }

    @Override
    public Object getArrayElement(int index) {
        return this.js_get(index);
    }

    @Override
    public void setArrayElement(int index, Object value) {
        this.js_set(index, value);
    }

    @Override
    public int getArrayLength() {
        return this.length;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        for (Object o : objects) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.length; ++i) {
            if (!o.equals(this.js_get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.length - 1; i >= 0; --i) {
            if (!o.equals(this.js_get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            a[i] = this.js_get(i);
        }
        return a;
    }

    @Override
    public <U> U[] toArray(U[] ts) {
        Object[] a = ts.length >= this.length ? ts : (Object[])Array.newInstance(ts.getClass().getComponentType(), this.length);
        for (int i = 0; i < this.length; ++i) {
            try {
                a[i] = this.js_get(i);
                continue;
            }
            catch (ClassCastException cce) {
                throw new ArrayStoreException();
            }
        }
        return a;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof NativeTypedArrayView)) {
            return false;
        }
        NativeTypedArrayView v = (NativeTypedArrayView)o;
        if (this.length != v.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.js_get(i).equals(v.js_get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hc = 0;
        for (int i = 0; i < this.length; ++i) {
            hc += this.js_get(i).hashCode();
        }
        return hc;
    }

    @Override
    public Iterator<T> iterator() {
        return new NativeTypedArrayIterator(this, 0);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new NativeTypedArrayIterator(this, 0);
    }

    @Override
    public ListIterator<T> listIterator(int start) {
        if (this.checkIndex(start)) {
            throw new IndexOutOfBoundsException();
        }
        return new NativeTypedArrayIterator(this, start);
    }

    @Override
    public List<T> subList(int i, int i2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T aByte) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int i, T aByte) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        throw new UnsupportedOperationException();
    }
}

