/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.spi;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.search.engine.search.spi.ObjectArrayResultsCompositor;
import org.hibernate.search.engine.search.spi.SingleValuedResultsCompositor;
import org.hibernate.search.util.common.annotation.Incubating;
import org.hibernate.search.util.common.function.TriFunction;

@Incubating
public interface ResultsCompositor<E, V> {
    public E createInitial();

    public E set(E var1, int var2, Object var3);

    public Object get(E var1, int var2);

    public V finish(E var1);

    public static <P1, V> ResultsCompositor<Object, V> from(Function<P1, V> transformer) {
        return new SingleValuedResultsCompositor<P1, V>(transformer);
    }

    public static <P1, P2, V> ResultsCompositor<Object[], V> from(final BiFunction<P1, P2, V> transformer) {
        return new ObjectArrayResultsCompositor<V>(2){

            @Override
            public V finish(Object[] components) {
                return transformer.apply(components[0], components[1]);
            }

            @Override
            protected Object transformer() {
                return transformer;
            }
        };
    }

    public static <P1, P2, P3, V> ResultsCompositor<Object[], V> from(final TriFunction<P1, P2, P3, V> transformer) {
        return new ObjectArrayResultsCompositor<V>(3){

            @Override
            public V finish(Object[] components) {
                return transformer.apply(components[0], components[1], components[2]);
            }

            @Override
            protected Object transformer() {
                return transformer;
            }
        };
    }

    public static ResultsCompositor<Object[], List<?>> fromList(int size) {
        return ResultsCompositor.fromArray(size, Arrays::asList);
    }

    public static <V> ResultsCompositor<Object[], V> fromList(int size, Function<? super List<?>, ? extends V> transformer) {
        return ResultsCompositor.fromArray(size, transformer.compose(Arrays::asList));
    }

    public static ResultsCompositor<Object[], Object[]> fromArray(int size) {
        return ResultsCompositor.fromArray(size, Function.identity());
    }

    public static <V> ResultsCompositor<Object[], V> fromArray(int size, final Function<? super Object[], ? extends V> transformer) {
        return new ObjectArrayResultsCompositor<V>(size){

            @Override
            public V finish(Object[] components) {
                return transformer.apply(components);
            }

            @Override
            protected Object transformer() {
                return transformer;
            }
        };
    }
}

