/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.search.engine.logging.impl.QueryLog;
import org.hibernate.search.engine.search.common.spi.SearchIndexScope;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.spi.AbstractPredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.spi.SearchPredicateDslContext;
import org.hibernate.search.engine.search.predicate.spi.BooleanPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilder;

abstract class AbstractBooleanMultiFieldPredicateCommonState<S extends AbstractBooleanMultiFieldPredicateCommonState<?, ?>, F extends FieldSetState>
extends AbstractPredicateFinalStep {
    private final List<F> fieldSetStates = new ArrayList<F>();
    private Float predicateLevelBoost;
    private boolean withConstantScore = false;

    AbstractBooleanMultiFieldPredicateCommonState(SearchPredicateDslContext<?> dslContext) {
        super(dslContext);
    }

    public SearchIndexScope<?> scope() {
        return this.dslContext.scope();
    }

    public void add(F fieldSetState) {
        this.fieldSetStates.add(fieldSetState);
    }

    List<F> getFieldSetStates() {
        return this.fieldSetStates;
    }

    public S boost(float boost) {
        this.predicateLevelBoost = Float.valueOf(boost);
        return this.thisAsS();
    }

    public S constantScore() {
        this.withConstantScore = true;
        return this.thisAsS();
    }

    @Override
    protected SearchPredicate build() {
        ArrayList predicates = new ArrayList();
        for (FieldSetState fieldSetState : this.fieldSetStates) {
            fieldSetState.contributePredicates(predicates::add);
        }
        if (predicates.size() > 1) {
            BooleanPredicateBuilder boolBuilder = this.dslContext.scope().predicateBuilders().bool();
            for (SearchPredicate predicate : predicates) {
                boolBuilder.should(predicate);
            }
            return boolBuilder.build();
        }
        return (SearchPredicate)predicates.get(0);
    }

    protected abstract S thisAsS();

    final void applyBoostAndConstantScore(Float fieldSetBoost, SearchPredicateBuilder predicateBuilder) {
        if (fieldSetBoost != null && this.withConstantScore) {
            throw QueryLog.INSTANCE.perFieldBoostWithConstantScore();
        }
        if (this.predicateLevelBoost != null && fieldSetBoost != null) {
            predicateBuilder.boost(this.predicateLevelBoost.floatValue() * fieldSetBoost.floatValue());
        } else if (this.predicateLevelBoost != null) {
            predicateBuilder.boost(this.predicateLevelBoost.floatValue());
        } else if (fieldSetBoost != null) {
            predicateBuilder.boost(fieldSetBoost.floatValue());
        }
        if (this.withConstantScore) {
            predicateBuilder.constantScore();
        }
    }

    public static interface FieldSetState {
        public void contributePredicates(Consumer<SearchPredicate> var1);
    }
}

