/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.common.spi;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.hibernate.search.engine.logging.impl.QueryLog;
import org.hibernate.search.engine.search.common.NamedValues;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.annotation.Incubating;
import org.hibernate.search.util.common.impl.Contracts;

@Incubating
public class MapNamedValues
implements NamedValues {
    protected final Map<String, Object> values;
    private final NamedValueMissing namedValueMissing;
    private final NamedValueIncorrectType namedValueIncorrectType;

    static NamedValues fromMap(Map<String, Object> map) {
        return new MapNamedValues(map);
    }

    public static NamedValues fromMap(Map<String, Object> map, Function<String, SearchException> namedValueMissing) {
        return new MapNamedValues(map, namedValueMissing::apply);
    }

    private static NamedValues fromMap(Map<String, Object> map, NamedValueMissing namedValueMissing, NamedValueIncorrectType namedValueIncorrectType) {
        return new MapNamedValues(map, namedValueMissing, namedValueIncorrectType);
    }

    private MapNamedValues(Map<String, Object> values) {
        this(values, QueryLog.INSTANCE::namedValuesParameterNotDefined, QueryLog.INSTANCE::namedValuesParameterIncorrectType);
    }

    protected MapNamedValues(Map<String, Object> values, NamedValueMissing namedValueMissing) {
        this(values, namedValueMissing, QueryLog.INSTANCE::namedValuesParameterIncorrectType);
    }

    protected MapNamedValues(Map<String, Object> values, NamedValueMissing namedValueMissing, NamedValueIncorrectType namedValueIncorrectType) {
        this.values = values;
        this.namedValueMissing = namedValueMissing;
        this.namedValueIncorrectType = namedValueIncorrectType;
    }

    @Override
    public <T> T get(String name, Class<T> paramType) {
        Contracts.assertNotNull((Object)name, (String)"name");
        Contracts.assertNotNull(paramType, (String)"paramType");
        if (!this.values.containsKey(name)) {
            throw this.namedValueMissing.exception(name);
        }
        Object value = this.values.get(name);
        if (value == null) {
            return null;
        }
        if (paramType.isAssignableFrom(value.getClass())) {
            return paramType.cast(value);
        }
        throw this.namedValueIncorrectType.exception(name, paramType, value.getClass());
    }

    @Override
    public <T> Optional<T> getOptional(String name, Class<T> paramType) {
        Contracts.assertNotNull((Object)name, (String)"name");
        Contracts.assertNotNull(paramType, (String)"paramType");
        return Optional.ofNullable(this.values.get(name)).map(paramType::cast);
    }

    @FunctionalInterface
    @Incubating
    protected static interface NamedValueMissing {
        public SearchException exception(String var1);
    }

    @FunctionalInterface
    @Incubating
    protected static interface NamedValueIncorrectType {
        public SearchException exception(String var1, Class<?> var2, Class<?> var3);
    }
}

