/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.logging.impl;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.hibernate.search.engine.mapper.model.spi.MappingElement;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@CategorizedLogger(category="org.hibernate.search.mapping")
@MessageLogger(projectCode="HSEARCH")
public interface MappingLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.mapping";
    public static final MappingLog INSTANCE = (MappingLog)LoggerFactory.make(MappingLog.class, (String)"org.hibernate.search.mapping", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=514, value="Invalid index field name '%1$s': field names cannot be null or empty.")
    public SearchException relativeFieldNameCannotBeNullOrEmpty(String var1, @Param EventContext var2);

    @Message(id=515, value="Invalid index field name '%1$s': field names cannot contain a dot ('.'). Remove the dot from your field name, or if you are declaring the field in a bridge and want a tree of fields, declare an object field using the objectField() method.")
    public SearchException relativeFieldNameCannotContainDot(String var1, @Param EventContext var2);

    @Message(id=546, value="Cyclic recursion starting from '%1$s' on %2$s. Index field path starting from that location and ending with a cycle: '%3$s'. A type cannot declare an unrestricted @IndexedEmbedded to itself, even indirectly. To break the cycle, you should consider adding filters to your @IndexedEmbedded: includePaths, includeDepth, excludePaths, ...")
    public SearchException indexedEmbeddedCyclicRecursion(MappingElement var1, @FormatWith(value=EventContextNoPrefixFormatter.class) EventContext var2, String var3);

    @Message(id=570, value="Invalid index field template name '%1$s': field template names cannot be null or empty.")
    public SearchException fieldTemplateNameCannotBeNullOrEmpty(String var1, @Param EventContext var2);

    @Message(id=571, value="Invalid index field template name '%1$s': field template names cannot contain a dot ('.').")
    public SearchException fieldTemplateNameCannotContainDot(String var1, @Param EventContext var2);

    @Message(id=588, value="Multiple entity types mapped to index '%1$s': '%2$s', '%3$s'. Each indexed type must be mapped to its own, dedicated index.")
    public SearchException twoTypesTargetSameIndex(String var1, String var2, String var3);

    @Message(id=593, value="Named predicate name '%1$s' is invalid: field names cannot be null or empty.")
    public SearchException relativeNamedPredicateNameCannotBeNullOrEmpty(String var1, @Param EventContext var2);

    @Message(id=594, value="Named predicate name '%1$s' is invalid: field names cannot contain a dot ('.'). Remove the dot from your named predicate name.")
    public SearchException relativeNamedPredicateNameCannotContainDot(String var1, @Param EventContext var2);

    @Message(id=598, value="Invalid type: %1$s is not composite.")
    public SearchException invalidIndexNodeTypeNotComposite(@FormatWith(value=EventContextNoPrefixFormatter.class) EventContext var1);

    @Message(id=599, value="Invalid type: %1$s is not an object field.")
    public SearchException invalidIndexNodeTypeNotObjectField(@FormatWith(value=EventContextNoPrefixFormatter.class) EventContext var1);

    @Message(id=600, value="Invalid type: %1$s is not a value field.")
    public SearchException invalidIndexNodeTypeNotValueField(@FormatWith(value=EventContextNoPrefixFormatter.class) EventContext var1);

    @Message(id=615, value="Unable to resolve field '%1$s': %2$s")
    public SearchException unableToResolveField(String var1, String var2, @Cause SearchException var3, @Param EventContext var4);

    @Message(id=619, value="'includePaths' and 'excludePaths' cannot be used together in the same filter. Use either `includePaths` or `excludePaths` leaving the other one empty. Included paths are: '%1$s', excluded paths are: '%2$s'.")
    public SearchException cannotIncludeAndExcludePathsWithinSameFilter(Set<String> var1, Set<String> var2);
}

