/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.spi;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.engine.cfg.ConfigurationPropertyCheckingStrategyName;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.EngineSettings;
import org.hibernate.search.engine.cfg.spi.AllAwareConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConsumedPropertyTrackingConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConvertUtils;
import org.hibernate.search.engine.cfg.spi.HibernateSearch5Properties;
import org.hibernate.search.engine.logging.impl.ConfigurationLog;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.CollectionHelper;

public final class ConfigurationPropertyChecker {
    private static final ConfigurationProperty<ConfigurationPropertyCheckingStrategyName> CONFIGURATION_PROPERTY_CHECKING_STRATEGY = ConfigurationProperty.forKey("hibernate.search.configuration_property_checking.strategy").as(ConfigurationPropertyCheckingStrategyName.class, ConfigurationPropertyCheckingStrategyName::of).withDefault(EngineSettings.Defaults.CONFIGURATION_PROPERTY_CHECKING_STRATEGY).build();
    private String configurationPropertyCheckingStrategyPropertyName;
    private final Set<String> availablePropertyKeys = ConcurrentHashMap.newKeySet();
    private final Set<String> consumedPropertyKeys = ConcurrentHashMap.newKeySet();
    private volatile boolean warn;

    public static ConfigurationPropertyChecker create() {
        return new ConfigurationPropertyChecker();
    }

    private static boolean isRelevantPropertyEntry(String key, Object value) {
        return key.startsWith("hibernate.search.") && ConvertUtils.trimIfString(value) != null;
    }

    private ConfigurationPropertyChecker() {
    }

    public ConfigurationPropertySource wrap(AllAwareConfigurationPropertySource source) {
        ConsumedPropertyTrackingConfigurationPropertySource trackingSource = new ConsumedPropertyTrackingConfigurationPropertySource(source, this::addConsumedPropertyKey);
        ConfigurationPropertyCheckingStrategyName checkingStrategy = CONFIGURATION_PROPERTY_CHECKING_STRATEGY.get(trackingSource);
        this.configurationPropertyCheckingStrategyPropertyName = CONFIGURATION_PROPERTY_CHECKING_STRATEGY.resolveOrRaw(source);
        switch (checkingStrategy) {
            case WARN: {
                this.warn = true;
                this.availablePropertyKeys.addAll(source.resolveAll(ConfigurationPropertyChecker::isRelevantPropertyEntry));
                return trackingSource;
            }
            case IGNORE: {
                return source;
            }
        }
        throw new AssertionFailure("Unexpected configuration property checking strategy name: " + String.valueOf((Object)checkingStrategy));
    }

    public void beforeBoot() {
        if (!this.warn) {
            ConfigurationLog.INSTANCE.configurationPropertyTrackingDisabled();
        }
        this.checkHibernateSearch5Properties();
    }

    public void afterBoot(ConfigurationPropertyChecker firstPhaseChecker) {
        this.checkUnconsumedProperties(firstPhaseChecker);
    }

    private void checkHibernateSearch5Properties() {
        LinkedHashSet<String> obsoleteKeys = new LinkedHashSet<String>();
        for (String propertyKey : this.availablePropertyKeys) {
            if (!HibernateSearch5Properties.isSearch5PropertyKey(propertyKey)) continue;
            obsoleteKeys.add(propertyKey);
        }
        if (!obsoleteKeys.isEmpty()) {
            throw ConfigurationLog.INSTANCE.obsoleteConfigurationPropertiesFromSearch5(obsoleteKeys);
        }
    }

    private void checkUnconsumedProperties(ConfigurationPropertyChecker firstPhaseChecker) {
        if (!this.warn) {
            return;
        }
        List checkers = CollectionHelper.asImmutableList((Object[])new ConfigurationPropertyChecker[]{firstPhaseChecker, this});
        LinkedHashSet<String> unconsumedPropertyKeys = new LinkedHashSet<String>();
        for (ConfigurationPropertyChecker checker : checkers) {
            unconsumedPropertyKeys.addAll(checker.availablePropertyKeys);
        }
        for (ConfigurationPropertyChecker checker : checkers) {
            unconsumedPropertyKeys.removeAll(checker.consumedPropertyKeys);
        }
        if (!unconsumedPropertyKeys.isEmpty()) {
            ConfigurationLog.INSTANCE.configurationPropertyTrackingUnusedProperties(unconsumedPropertyKeys, this.configurationPropertyCheckingStrategyPropertyName, ConfigurationPropertyCheckingStrategyName.IGNORE.externalRepresentation());
        }
    }

    private void addConsumedPropertyKey(String key) {
        this.consumedPropertyKeys.add(key);
    }
}

