/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.engine.search.common.spi.SearchIndexScope;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.TermsPredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.TermsPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.impl.AbstractBooleanMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.dsl.spi.SearchPredicateDslContext;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.engine.search.predicate.spi.TermsPredicateBuilder;
import org.hibernate.search.util.common.impl.Contracts;

class TermsPredicateFieldMoreStepImpl
implements TermsPredicateFieldMoreStep<TermsPredicateFieldMoreStepImpl, TermsPredicateOptionsStep<?>>,
AbstractBooleanMultiFieldPredicateCommonState.FieldSetState {
    private final CommonState commonState;
    private final List<TermsPredicateBuilder> predicateBuilders = new ArrayList<TermsPredicateBuilder>();
    private Float fieldSetBoost;

    TermsPredicateFieldMoreStepImpl(CommonState commonState, List<String> fieldPaths) {
        this.commonState = commonState;
        this.commonState.add(this);
        SearchIndexScope<?> scope = commonState.scope();
        for (String fieldPath : fieldPaths) {
            this.predicateBuilders.add(scope.fieldQueryElement(fieldPath, PredicateTypeKeys.TERMS));
        }
    }

    @Override
    public TermsPredicateFieldMoreStepImpl fields(String ... fieldPaths) {
        return new TermsPredicateFieldMoreStepImpl(this.commonState, Arrays.asList(fieldPaths));
    }

    @Override
    public TermsPredicateFieldMoreStepImpl boost(float boost) {
        this.fieldSetBoost = Float.valueOf(boost);
        return this;
    }

    @Override
    public TermsPredicateOptionsStep<?> matchingAny(Collection<?> terms, ValueModel valueModel) {
        return this.commonState.matchingAny(terms, valueModel);
    }

    @Override
    public TermsPredicateOptionsStep<?> matchingAll(Collection<?> terms, ValueModel valueModel) {
        return this.commonState.matchingAll(terms, valueModel);
    }

    @Override
    public void contributePredicates(Consumer<SearchPredicate> collector) {
        for (TermsPredicateBuilder predicateBuilder : this.predicateBuilders) {
            this.commonState.applyBoostAndConstantScore(this.fieldSetBoost, predicateBuilder);
            collector.accept(predicateBuilder.build());
        }
    }

    static class CommonState
    extends AbstractBooleanMultiFieldPredicateCommonState<CommonState, TermsPredicateFieldMoreStepImpl>
    implements TermsPredicateOptionsStep<CommonState> {
        CommonState(SearchPredicateDslContext<?> dslContext) {
            super(dslContext);
        }

        private TermsPredicateOptionsStep<?> matchingAny(Collection<?> terms, ValueModel valueModel) {
            Contracts.assertNotNullNorEmpty(terms, (String)"terms");
            Contracts.assertNotNull((Object)((Object)valueModel), (String)"valueModel");
            for (TermsPredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                for (TermsPredicateBuilder predicateBuilder : fieldSetState.predicateBuilders) {
                    predicateBuilder.matchingAny(terms, valueModel);
                }
            }
            return this;
        }

        private TermsPredicateOptionsStep<?> matchingAll(Collection<?> terms, ValueModel valueModel) {
            Contracts.assertNotNullNorEmpty(terms, (String)"terms");
            Contracts.assertNotNull((Object)((Object)valueModel), (String)"valueModel");
            for (TermsPredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                for (TermsPredicateBuilder predicateBuilder : fieldSetState.predicateBuilders) {
                    predicateBuilder.matchingAll(terms, valueModel);
                }
            }
            return this;
        }

        @Override
        protected CommonState thisAsS() {
            return this;
        }
    }
}

