/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexSchemaObjectFieldTemplateBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexSchemaValueFieldNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexSchemaValueFieldTemplateBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.AbstractLuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaNodeCollector;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaNodeContributor;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexValueFieldType;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldTemplateOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaBuildContext;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectNodeBuilder;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractLuceneIndexSchemaObjectNodeBuilder
implements IndexSchemaObjectNodeBuilder,
IndexSchemaBuildContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<String, LuceneIndexSchemaNodeContributor> fields = new LinkedHashMap<String, LuceneIndexSchemaNodeContributor>();
    private final Map<String, LuceneIndexSchemaNodeContributor> templates = new LinkedHashMap<String, LuceneIndexSchemaNodeContributor>();

    AbstractLuceneIndexSchemaObjectNodeBuilder() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "absolutePath=" + this.getAbsolutePath() + "]";
    }

    public <F> IndexSchemaFieldOptionsStep<?, IndexFieldReference<F>> addField(String relativeFieldName, IndexFieldInclusion inclusion, IndexFieldType<F> indexFieldType) {
        LuceneIndexValueFieldType luceneIndexFieldType = (LuceneIndexValueFieldType)indexFieldType;
        LuceneIndexSchemaValueFieldNodeBuilder childBuilder = new LuceneIndexSchemaValueFieldNodeBuilder(this, relativeFieldName, inclusion, luceneIndexFieldType);
        this.putField(relativeFieldName, childBuilder);
        return childBuilder;
    }

    public IndexSchemaObjectFieldNodeBuilder addObjectField(String relativeFieldName, IndexFieldInclusion inclusion, ObjectStructure structure) {
        LuceneIndexSchemaObjectFieldNodeBuilder objectFieldBuilder = new LuceneIndexSchemaObjectFieldNodeBuilder(this, relativeFieldName, inclusion, structure);
        this.putField(relativeFieldName, objectFieldBuilder);
        return objectFieldBuilder;
    }

    public IndexSchemaFieldTemplateOptionsStep<?> addFieldTemplate(String templateName, IndexFieldInclusion inclusion, IndexFieldType<?> indexFieldType, String prefix) {
        String prefixedTemplateName = FieldPaths.prefix((String)prefix, (String)templateName);
        LuceneIndexValueFieldType elasticsearchIndexFieldType = (LuceneIndexValueFieldType)indexFieldType;
        LuceneIndexSchemaValueFieldTemplateBuilder templateBuilder = new LuceneIndexSchemaValueFieldTemplateBuilder(this, prefixedTemplateName, inclusion, elasticsearchIndexFieldType, prefix);
        this.putTemplate(prefixedTemplateName, templateBuilder);
        return templateBuilder;
    }

    public IndexSchemaFieldTemplateOptionsStep<?> addObjectFieldTemplate(String templateName, ObjectStructure structure, String prefix, IndexFieldInclusion inclusion) {
        String prefixedTemplateName = FieldPaths.prefix((String)prefix, (String)templateName);
        LuceneIndexSchemaObjectFieldTemplateBuilder templateBuilder = new LuceneIndexSchemaObjectFieldTemplateBuilder(this, prefixedTemplateName, inclusion, structure, prefix);
        this.putTemplate(prefixedTemplateName, templateBuilder);
        return templateBuilder;
    }

    public abstract LuceneIndexSchemaRootNodeBuilder getRootNodeBuilder();

    abstract String getAbsolutePath();

    final void contributeChildren(LuceneIndexSchemaObjectNode node, LuceneIndexSchemaNodeCollector collector, Map<String, AbstractLuceneIndexSchemaFieldNode> staticChildrenByNameForParent) {
        for (LuceneIndexSchemaNodeContributor contributor : this.fields.values()) {
            contributor.contribute(collector, node, staticChildrenByNameForParent);
        }
        for (LuceneIndexSchemaNodeContributor template : this.templates.values()) {
            template.contribute(collector, node, staticChildrenByNameForParent);
        }
    }

    private void putField(String name, LuceneIndexSchemaNodeContributor contributor) {
        LuceneIndexSchemaNodeContributor previous = this.fields.putIfAbsent(name, contributor);
        if (previous != null) {
            throw log.indexSchemaNodeNameConflict(name, this.eventContext());
        }
    }

    private void putTemplate(String name, LuceneIndexSchemaNodeContributor contributor) {
        LuceneIndexSchemaNodeContributor previous = this.templates.putIfAbsent(name, contributor);
        if (previous != null) {
            throw log.indexSchemaFieldTemplateNameConflict(name, this.eventContext());
        }
    }
}

