/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.List;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.engine.impl.WorkPlan;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class WorkQueue {
    private static final Log log = LoggerFactory.make();
    private WorkPlan plan;
    private List<LuceneWork> sealedQueue;
    private boolean usedSealedData;
    private boolean sealedAndUnchanged;
    private final SearchFactoryImplementor searchFactoryImplementor;

    public WorkQueue(SearchFactoryImplementor searchFactoryImplementor) {
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.plan = new WorkPlan(searchFactoryImplementor);
    }

    public WorkQueue(SearchFactoryImplementor searchFactoryImplementor, WorkPlan plan) {
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.plan = plan;
    }

    public boolean isSealedAndUnchanged() {
        return this.sealedAndUnchanged;
    }

    public void add(Work work) {
        if (this.usedSealedData) {
            throw new AssertionFailure("Attempting to add a work in a used sealed queue");
        }
        this.sealedAndUnchanged = false;
        this.plan.addWork(work);
    }

    public WorkQueue splitQueue() {
        if (log.isTraceEnabled()) {
            log.tracef("Splitting workqueue with %d works", this.plan.size());
        }
        WorkQueue subQueue = new WorkQueue(this.searchFactoryImplementor, this.plan);
        this.plan = new WorkPlan(this.searchFactoryImplementor);
        this.sealedAndUnchanged = false;
        return subQueue;
    }

    public List<LuceneWork> getSealedQueue() {
        if (this.sealedQueue == null) {
            throw new AssertionFailure("Access a Sealed WorkQueue which has not been sealed");
        }
        this.sealedAndUnchanged = false;
        return this.sealedQueue;
    }

    private void setSealedQueue(List<LuceneWork> sealedQueue) {
        this.sealedAndUnchanged = true;
        this.sealedQueue = sealedQueue;
    }

    public void clear() {
        if (log.isTraceEnabled()) {
            log.trace("Clearing current workqueue");
        }
        this.plan.clear();
        this.sealedAndUnchanged = false;
        if (this.sealedQueue != null) {
            this.sealedQueue.clear();
        }
    }

    public int size() {
        return this.plan.size();
    }

    public void prepareWorkPlan() {
        if (!this.sealedAndUnchanged) {
            this.plan.processContainedInAndPrepareExecution();
            List<LuceneWork> luceneWorkPlan = this.plan.getPlannedLuceneWork();
            this.setSealedQueue(luceneWorkPlan);
        }
    }
}

