/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.Hibernate;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.ejb.EntityManagerImpl;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.internal.EntityManagerFactoryRegistry;
import org.hibernate.ejb.metamodel.MetamodelImpl;
import org.hibernate.ejb.util.PersistenceUtilHelper;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.service.ServiceRegistry;
import org.jboss.logging.Logger;

public class EntityManagerFactoryImpl
implements HibernateEntityManagerFactory {
    private static final long serialVersionUID = 5423543L;
    private static final IdentifierGenerator UUID_GENERATOR = UUIDGenerator.buildSessionFactoryUniqueIdentifierGenerator();
    private static final Logger log = Logger.getLogger(EntityManagerFactoryImpl.class);
    private final transient SessionFactoryImpl sessionFactory;
    private final transient PersistenceUnitTransactionType transactionType;
    private final transient boolean discardOnClose;
    private final transient Class sessionInterceptorClass;
    private final transient CriteriaBuilderImpl criteriaBuilder;
    private final transient Metamodel metamodel;
    private final transient HibernatePersistenceUnitUtil util;
    private final transient Map<String, Object> properties;
    private final String entityManagerFactoryName;
    private final transient PersistenceUtilHelper.MetadataCache cache = new PersistenceUtilHelper.MetadataCache();

    public EntityManagerFactoryImpl(PersistenceUnitTransactionType transactionType, boolean discardOnClose, Class sessionInterceptorClass, Configuration cfg, ServiceRegistry serviceRegistry, String persistenceUnitName) {
        this.sessionFactory = (SessionFactoryImpl)cfg.buildSessionFactory(serviceRegistry);
        this.transactionType = transactionType;
        this.discardOnClose = discardOnClose;
        this.sessionInterceptorClass = sessionInterceptorClass;
        Iterator classes = cfg.getClassMappings();
        JpaMetaModelPopulationSetting jpaMetaModelPopulationSetting = this.determineJpaMetaModelPopulationSetting(cfg);
        this.metamodel = JpaMetaModelPopulationSetting.DISABLED == jpaMetaModelPopulationSetting ? null : MetamodelImpl.buildMetamodel(classes, (SessionFactoryImplementor)this.sessionFactory, JpaMetaModelPopulationSetting.IGNORE_UNSUPPORTED == jpaMetaModelPopulationSetting);
        this.criteriaBuilder = new CriteriaBuilderImpl(this);
        this.util = new HibernatePersistenceUnitUtil(this);
        HashMap<String, Object> props = new HashMap<String, Object>();
        EntityManagerFactoryImpl.addAll(props, this.sessionFactory.getProperties());
        EntityManagerFactoryImpl.addAll(props, cfg.getProperties());
        this.properties = Collections.unmodifiableMap(props);
        String entityManagerFactoryName = (String)this.properties.get("hibernate.ejb.entitymanager_factory_name");
        if (entityManagerFactoryName == null) {
            entityManagerFactoryName = persistenceUnitName;
        }
        if (entityManagerFactoryName == null) {
            entityManagerFactoryName = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        this.entityManagerFactoryName = entityManagerFactoryName;
        EntityManagerFactoryRegistry.INSTANCE.addEntityManagerFactory(entityManagerFactoryName, this);
    }

    protected JpaMetaModelPopulationSetting determineJpaMetaModelPopulationSetting(Configuration cfg) {
        String setting = ConfigurationHelper.getString((String)"hibernate.ejb.metamodel.population", (Map)cfg.getProperties(), null);
        if (setting == null && (setting = ConfigurationHelper.getString((String)"hibernate.ejb.metamodel.generation", (Map)cfg.getProperties(), null)) != null) {
            log.infof("Encountered deprecated setting [%s], use [%s] instead", (Object)"hibernate.ejb.metamodel.generation", (Object)"hibernate.ejb.metamodel.population");
        }
        return JpaMetaModelPopulationSetting.parse(setting);
    }

    private static void addAll(HashMap<String, Object> propertyMap, Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!String.class.isInstance(entry.getKey())) continue;
            propertyMap.put((String)entry.getKey(), entry.getValue());
        }
    }

    public EntityManager createEntityManager() {
        return this.createEntityManager(null);
    }

    public EntityManager createEntityManager(Map map) {
        return new EntityManagerImpl(this, PersistenceContextType.EXTENDED, this.transactionType, this.discardOnClose, this.sessionInterceptorClass, map);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.criteriaBuilder;
    }

    public Metamodel getMetamodel() {
        return this.metamodel;
    }

    public void close() {
        this.sessionFactory.close();
        EntityManagerFactoryRegistry.INSTANCE.removeEntityManagerFactory(this.entityManagerFactoryName, this);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Cache getCache() {
        if (!this.isOpen()) {
            throw new IllegalStateException("EntityManagerFactory is closed");
        }
        return new JPACache((SessionFactory)this.sessionFactory);
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        if (!this.isOpen()) {
            throw new IllegalStateException("EntityManagerFactory is closed");
        }
        return this.util;
    }

    public boolean isOpen() {
        return !this.sessionFactory.isClosed();
    }

    public SessionFactoryImpl getSessionFactory() {
        return this.sessionFactory;
    }

    public String getEntityManagerFactoryName() {
        return this.entityManagerFactoryName;
    }

    private static EntityManagerFactory getNamedEntityManagerFactory(String entityManagerFactoryName) throws InvalidObjectException {
        EntityManagerFactory result = EntityManagerFactoryRegistry.INSTANCE.getNamedEntityManagerFactory(entityManagerFactoryName);
        if (result == null) {
            throw new InvalidObjectException("could not resolve entity manager factory during entity manager deserialization [name=" + entityManagerFactoryName + "]");
        }
        return result;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.entityManagerFactoryName == null) {
            throw new InvalidObjectException("could not serialize entity manager factory with null entityManagerFactoryName");
        }
        oos.defaultWriteObject();
    }

    private Object readResolve() throws InvalidObjectException {
        return EntityManagerFactoryImpl.getNamedEntityManagerFactory(this.entityManagerFactoryName);
    }

    private static class HibernatePersistenceUnitUtil
    implements PersistenceUnitUtil,
    Serializable {
        private final HibernateEntityManagerFactory emf;
        private transient PersistenceUtilHelper.MetadataCache cache;

        private HibernatePersistenceUnitUtil(EntityManagerFactoryImpl emf) {
            this.emf = emf;
            this.cache = emf.cache;
        }

        public boolean isLoaded(Object entity, String attributeName) {
            LoadState state = PersistenceUtilHelper.isLoadedWithoutReference(entity, attributeName, this.cache);
            if (state == LoadState.LOADED) {
                return true;
            }
            if (state == LoadState.NOT_LOADED) {
                return false;
            }
            return PersistenceUtilHelper.isLoadedWithReference(entity, attributeName, this.cache) != LoadState.NOT_LOADED;
        }

        public boolean isLoaded(Object entity) {
            return PersistenceUtilHelper.isLoaded(entity) != LoadState.NOT_LOADED;
        }

        public Object getIdentifier(Object entity) {
            Class entityClass = Hibernate.getClass((Object)entity);
            ClassMetadata classMetadata = this.emf.getSessionFactory().getClassMetadata(entityClass);
            if (classMetadata == null) {
                throw new IllegalArgumentException(entityClass + " is not an entity");
            }
            return classMetadata.getIdentifier(entity);
        }
    }

    private static class JPACache
    implements Cache {
        private SessionFactory sessionFactory;

        private JPACache(SessionFactory sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        public boolean contains(Class entityClass, Object identifier) {
            return this.sessionFactory.getCache().containsEntity(entityClass, (Serializable)identifier);
        }

        public void evict(Class entityClass, Object identifier) {
            this.sessionFactory.getCache().evictEntity(entityClass, (Serializable)identifier);
        }

        public void evict(Class entityClass) {
            this.sessionFactory.getCache().evictEntityRegion(entityClass);
        }

        public void evictAll() {
            this.sessionFactory.getCache().evictEntityRegions();
        }
    }

    private static enum JpaMetaModelPopulationSetting {
        ENABLED,
        DISABLED,
        IGNORE_UNSUPPORTED;


        private static JpaMetaModelPopulationSetting parse(String setting) {
            if ("enabled".equalsIgnoreCase(setting)) {
                return ENABLED;
            }
            if ("disabled".equalsIgnoreCase(setting)) {
                return DISABLED;
            }
            return IGNORE_UNSUPPORTED;
        }
    }
}

