/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.predicate;

import java.io.Serializable;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.Renderable;
import org.hibernate.ejb.criteria.ValueHandlerFactory;
import org.hibernate.ejb.criteria.expression.BinaryOperatorExpression;
import org.hibernate.ejb.criteria.expression.LiteralExpression;
import org.hibernate.ejb.criteria.predicate.AbstractSimplePredicate;

public class ComparisonPredicate
extends AbstractSimplePredicate
implements BinaryOperatorExpression<Boolean>,
Serializable {
    private final ComparisonOperator comparisonOperator;
    private final Expression<?> leftHandSide;
    private final Expression<?> rightHandSide;

    public ComparisonPredicate(CriteriaBuilderImpl criteriaBuilder, ComparisonOperator comparisonOperator, Expression<?> leftHandSide, Expression<?> rightHandSide) {
        super(criteriaBuilder);
        this.comparisonOperator = comparisonOperator;
        this.leftHandSide = leftHandSide;
        this.rightHandSide = rightHandSide;
    }

    public ComparisonPredicate(CriteriaBuilderImpl criteriaBuilder, ComparisonOperator comparisonOperator, Expression<?> leftHandSide, Object rightHandSide) {
        super(criteriaBuilder);
        this.comparisonOperator = comparisonOperator;
        this.leftHandSide = leftHandSide;
        this.rightHandSide = ValueHandlerFactory.isNumeric(leftHandSide.getJavaType()) ? new LiteralExpression(criteriaBuilder, ValueHandlerFactory.convert(rightHandSide, leftHandSide.getJavaType())) : new LiteralExpression<Object>(criteriaBuilder, rightHandSide);
    }

    public <N extends Number> ComparisonPredicate(CriteriaBuilderImpl criteriaBuilder, ComparisonOperator comparisonOperator, Expression<N> leftHandSide, Number rightHandSide) {
        super(criteriaBuilder);
        this.comparisonOperator = comparisonOperator;
        this.leftHandSide = leftHandSide;
        this.rightHandSide = new LiteralExpression(criteriaBuilder, ValueHandlerFactory.convert(rightHandSide, leftHandSide.getJavaType()));
    }

    public ComparisonOperator getComparisonOperator() {
        return this.isNegated() ? this.comparisonOperator.negated() : this.comparisonOperator;
    }

    @Override
    public Expression getLeftHandOperand() {
        return this.leftHandSide;
    }

    @Override
    public Expression getRightHandOperand() {
        return this.rightHandSide;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter((Selection)this.getLeftHandOperand(), registry);
        ParameterContainer.Helper.possibleParameter((Selection)this.getRightHandOperand(), registry);
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return ((Renderable)this.getLeftHandOperand()).render(renderingContext) + this.getComparisonOperator().rendered() + ((Renderable)this.getRightHandOperand()).render(renderingContext);
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return this.render(renderingContext);
    }

    public static enum ComparisonOperator {
        EQUAL{

            @Override
            public ComparisonOperator negated() {
                return NOT_EQUAL;
            }

            @Override
            public String rendered() {
                return "=";
            }
        }
        ,
        NOT_EQUAL{

            @Override
            public ComparisonOperator negated() {
                return EQUAL;
            }

            @Override
            public String rendered() {
                return "<>";
            }
        }
        ,
        LESS_THAN{

            @Override
            public ComparisonOperator negated() {
                return GREATER_THAN_OR_EQUAL;
            }

            @Override
            public String rendered() {
                return "<";
            }
        }
        ,
        LESS_THAN_OR_EQUAL{

            @Override
            public ComparisonOperator negated() {
                return GREATER_THAN;
            }

            @Override
            public String rendered() {
                return "<=";
            }
        }
        ,
        GREATER_THAN{

            @Override
            public ComparisonOperator negated() {
                return LESS_THAN_OR_EQUAL;
            }

            @Override
            public String rendered() {
                return ">";
            }
        }
        ,
        GREATER_THAN_OR_EQUAL{

            @Override
            public ComparisonOperator negated() {
                return LESS_THAN;
            }

            @Override
            public String rendered() {
                return ">=";
            }
        };


        public abstract ComparisonOperator negated();

        public abstract String rendered();
    }
}

