/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fest.assertions.internal.JavaBeanDescriptor;
import org.fest.util.Introspection;
import org.fest.util.IntrospectionError;
import org.fest.util.Iterables;
import org.fest.util.VisibleForTesting;

public class PropertySupport {
    private static final String SEPARATOR = ".";
    private static final PropertySupport INSTANCE = new PropertySupport();
    @VisibleForTesting
    JavaBeanDescriptor javaBeanDescriptor = new JavaBeanDescriptor();

    public static PropertySupport instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    PropertySupport() {
    }

    public <T> Iterable<T> propertyValues(String propertyName, Class<T> clazz, Iterable<?> target) {
        List cleanedUp = Iterables.nonNullElementsIn(target);
        if (Iterables.isNullOrEmpty((Iterable)cleanedUp)) {
            return Collections.emptyList();
        }
        if (this.isNestedProperty(propertyName)) {
            String firstPropertyName = this.popPropertyNameFrom(propertyName);
            Iterable<Object> propertyValues = this.propertyValues(firstPropertyName, Object.class, cleanedUp);
            return this.propertyValues(this.nextPropertyNameFrom(propertyName), clazz, propertyValues);
        }
        return this.simplePropertyValues(propertyName, clazz, cleanedUp);
    }

    public static <T> T propertyValueOf(String propertyName, Object target, Class<T> clazz) {
        return PropertySupport.instance().propertyValue(propertyName, clazz, target);
    }

    private <T> List<T> simplePropertyValues(String propertyName, Class<T> clazz, Iterable<?> target) {
        ArrayList<T> propertyValues = new ArrayList<T>();
        for (Object e : target) {
            propertyValues.add(this.propertyValue(propertyName, clazz, e));
        }
        return Collections.unmodifiableList(propertyValues);
    }

    private String popPropertyNameFrom(String propertyNameChain) {
        if (!this.isNestedProperty(propertyNameChain)) {
            return propertyNameChain;
        }
        return propertyNameChain.substring(0, propertyNameChain.indexOf(SEPARATOR));
    }

    private String nextPropertyNameFrom(String propertyNameChain) {
        if (!this.isNestedProperty(propertyNameChain)) {
            return "";
        }
        return propertyNameChain.substring(propertyNameChain.indexOf(SEPARATOR) + 1);
    }

    private boolean isNestedProperty(String propertyName) {
        return propertyName.contains(SEPARATOR) && !propertyName.startsWith(SEPARATOR) && !propertyName.endsWith(SEPARATOR);
    }

    public <T> T propertyValue(String propertyName, Class<T> clazz, Object target) {
        PropertyDescriptor descriptor = Introspection.getProperty((String)propertyName, (Object)target);
        try {
            return clazz.cast(this.javaBeanDescriptor.invokeReadMethod(descriptor, target));
        }
        catch (ClassCastException e) {
            String msg = String.format("Unable to obtain the value of the property <'%s'> from <%s> - wrong property type specified <%s>", propertyName, target, clazz);
            throw new IntrospectionError(msg, (Throwable)e);
        }
        catch (Throwable unexpected) {
            String msg = String.format("Unable to obtain the value of the property <'%s'> from <%s>", propertyName, target);
            throw new IntrospectionError(msg, unexpected);
        }
    }

    public <T> T propertyValueOf(String propertyName, Class<T> clazz, Object target) {
        if (target == null) {
            return null;
        }
        if (this.isNestedProperty(propertyName)) {
            String firstPropertyName = this.popPropertyNameFrom(propertyName);
            Object propertyValue = this.propertyValue(firstPropertyName, Object.class, target);
            return this.propertyValueOf(this.nextPropertyNameFrom(propertyName), clazz, propertyValue);
        }
        return this.propertyValue(propertyName, clazz, target);
    }
}

