/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import java.util.Comparator;
import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.data.Index;
import org.fest.assertions.internal.Arrays;
import org.fest.assertions.internal.ComparisonStrategy;
import org.fest.assertions.internal.Failures;
import org.fest.assertions.internal.StandardComparisonStrategy;
import org.fest.util.VisibleForTesting;

public class FloatArrays {
    private static final FloatArrays INSTANCE = new FloatArrays();
    private Arrays arrays = Arrays.instance();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static FloatArrays instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    FloatArrays() {
        this(StandardComparisonStrategy.instance());
    }

    public FloatArrays(ComparisonStrategy comparisonStrategy) {
        this.arrays = new Arrays(comparisonStrategy);
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        return this.arrays.getComparator();
    }

    public void assertNullOrEmpty(AssertionInfo info, float[] actual) {
        this.arrays.assertNullOrEmpty(info, this.failures, actual);
    }

    public void assertEmpty(AssertionInfo info, float[] actual) {
        this.arrays.assertEmpty(info, this.failures, actual);
    }

    public void assertNotEmpty(AssertionInfo info, float[] actual) {
        this.arrays.assertNotEmpty(info, this.failures, actual);
    }

    public void assertHasSize(AssertionInfo info, float[] actual, int expectedSize) {
        this.arrays.assertHasSize(info, this.failures, actual, expectedSize);
    }

    public void assertHasSameSizeAs(AssertionInfo info, float[] actual, Iterable<?> other) {
        this.arrays.assertHasSameSizeAs(info, this.failures, (Object)actual, other);
    }

    public void assertHasSameSizeAs(AssertionInfo info, float[] actual, Object[] other) {
        this.arrays.assertHasSameSizeAs(info, this.failures, (Object)actual, other);
    }

    public void assertContains(AssertionInfo info, float[] actual, float[] values) {
        this.arrays.assertContains(info, this.failures, actual, values);
    }

    public void assertContains(AssertionInfo info, float[] actual, float value, Index index) {
        this.arrays.assertContains(info, this.failures, actual, Float.valueOf(value), index);
    }

    public void assertDoesNotContain(AssertionInfo info, float[] actual, float value, Index index) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, Float.valueOf(value), index);
    }

    public void assertContainsOnly(AssertionInfo info, float[] actual, float[] values) {
        this.arrays.assertContainsOnly(info, this.failures, actual, values);
    }

    public void assertContainsSequence(AssertionInfo info, float[] actual, float[] sequence) {
        this.arrays.assertContainsSequence(info, this.failures, actual, sequence);
    }

    public void assertDoesNotContain(AssertionInfo info, float[] actual, float[] values) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, values);
    }

    public void assertDoesNotHaveDuplicates(AssertionInfo info, float[] actual) {
        this.arrays.assertDoesNotHaveDuplicates(info, this.failures, actual);
    }

    public void assertStartsWith(AssertionInfo info, float[] actual, float[] sequence) {
        this.arrays.assertStartsWith(info, this.failures, actual, sequence);
    }

    public void assertEndsWith(AssertionInfo info, float[] actual, float[] sequence) {
        this.arrays.assertEndsWith(info, this.failures, actual, sequence);
    }

    public void assertIsSorted(AssertionInfo info, float[] actual) {
        this.arrays.assertIsSorted(info, this.failures, actual);
    }

    public void assertIsSortedAccordingToComparator(AssertionInfo info, float[] actual, Comparator<? super Float> comparator) {
        Arrays.assertIsSortedAccordingToComparator(info, this.failures, actual, comparator);
    }
}

