/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import org.fest.assertions.data.Index;
import org.fest.assertions.data.Offset;

final class CommonValidations {
    static void checkIndexValueIsValid(Index index, int maximum) {
        if (index == null) {
            throw new NullPointerException("Index should not be null");
        }
        if (index.value <= maximum) {
            return;
        }
        String format = "Index should be between <%d> and <%d> (inclusive,) but was <%d>";
        throw new IndexOutOfBoundsException(String.format(format, 0, maximum, index.value));
    }

    static void checkOffsetIsNotNull(Offset<?> offset) {
        if (offset == null) {
            throw new NullPointerException("The given offset should not be null");
        }
    }

    static void checkNumberIsNotNull(Number number) {
        if (number == null) {
            throw new NullPointerException("The given number should not be null");
        }
    }

    private CommonValidations() {
    }
}

