/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.filter;

import java.util.ArrayList;
import java.util.Iterator;
import org.fest.assertions.core.Condition;
import org.fest.assertions.internal.PropertySupport;
import org.fest.util.Lists;
import org.fest.util.Objects;
import org.fest.util.VisibleForTesting;

public class Filters<E> {
    @VisibleForTesting
    final Iterable<E> initialIterable;
    Iterable<E> filteredIterable;
    private PropertySupport propertySupport = PropertySupport.instance();
    private String propertyNameToFilterOn;

    public static <E> Filters<E> filter(Iterable<E> iterable) {
        if (iterable == null) {
            throw new NullPointerException("The iterable to filter should not be null");
        }
        return new Filters<E>(iterable);
    }

    public static <E> Filters<E> filter(E[] array) {
        if (array == null) {
            throw new NullPointerException("The array to filter should not be null");
        }
        return new Filters<E>(array);
    }

    @VisibleForTesting
    Filters(Iterable<E> iterable) {
        this.initialIterable = iterable;
        this.filteredIterable = Lists.newArrayList(iterable);
    }

    @VisibleForTesting
    Filters(E[] array) {
        ArrayList<E> iterable = new ArrayList<E>(array.length);
        for (int i = 0; i < array.length; ++i) {
            iterable.add(array[i]);
        }
        this.initialIterable = iterable;
        this.filteredIterable = Lists.newArrayList(iterable);
    }

    public Filters<E> being(Condition<? super E> condition) {
        if (condition == null) {
            throw new NullPointerException("The filter condition should not be null");
        }
        return this.applyFilterCondition(condition);
    }

    public Filters<E> having(Condition<? super E> condition) {
        if (condition == null) {
            throw new NullPointerException("The filter condition should not be null");
        }
        return this.applyFilterCondition(condition);
    }

    private Filters<E> applyFilterCondition(Condition<? super E> condition) {
        ArrayList<E> newFilteredIterable = new ArrayList<E>();
        for (E element : this.filteredIterable) {
            if (!condition.matches(element)) continue;
            newFilteredIterable.add(element);
        }
        this.filteredIterable = newFilteredIterable;
        return this;
    }

    public Filters<E> with(String propertyName, Object propertyValue) {
        if (propertyName == null) {
            throw new NullPointerException("The property name to filter on should not be null");
        }
        this.propertyNameToFilterOn = propertyName;
        return this.equalsTo(propertyValue);
    }

    public Filters<E> with(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("The property name to filter on should not be null");
        }
        this.propertyNameToFilterOn = propertyName;
        return this;
    }

    public Filters<E> and(String propertyName) {
        return this.with(propertyName);
    }

    public Filters<E> equalsTo(Object propertyValue) {
        this.checkPropertyNameToFilterOnIsNotNull();
        ArrayList<E> newFilteredIterable = new ArrayList<E>();
        Iterator<E> i$ = this.filteredIterable.iterator();
        while (i$.hasNext()) {
            E element;
            Class propertyValueClass = propertyValue == null ? Object.class : propertyValue.getClass();
            Object propertyValueOfCurrentElement = this.propertySupport.propertyValueOf(this.propertyNameToFilterOn, propertyValueClass, element = i$.next());
            if (!Objects.areEqual((Object)propertyValueOfCurrentElement, (Object)propertyValue)) continue;
            newFilteredIterable.add(element);
        }
        this.filteredIterable = newFilteredIterable;
        return this;
    }

    public Filters<E> notEqualsTo(Object propertyValue) {
        this.checkPropertyNameToFilterOnIsNotNull();
        ArrayList<E> newFilteredIterable = new ArrayList<E>();
        for (E element : this.filteredIterable) {
            Object propertyValueOfCurrentElement = this.propertySupport.propertyValueOf(this.propertyNameToFilterOn, propertyValue.getClass(), element);
            if (Objects.areEqual(propertyValueOfCurrentElement, (Object)propertyValue)) continue;
            newFilteredIterable.add(element);
        }
        this.filteredIterable = newFilteredIterable;
        return this;
    }

    private void checkPropertyNameToFilterOnIsNotNull() {
        if (this.propertyNameToFilterOn == null) {
            throw new NullPointerException("The property name to filter on has not been set - no filtering is possible");
        }
    }

    public Filters<E> in(Object ... propertyValues) {
        this.checkPropertyNameToFilterOnIsNotNull();
        ArrayList<E> newFilteredIterable = new ArrayList<E>();
        for (E element : this.filteredIterable) {
            Object propertyValueOfCurrentElement = this.propertySupport.propertyValueOf(this.propertyNameToFilterOn, propertyValues.getClass().getComponentType(), element);
            if (!Filters.isItemInArray(propertyValueOfCurrentElement, propertyValues)) continue;
            newFilteredIterable.add(element);
        }
        this.filteredIterable = newFilteredIterable;
        return this;
    }

    public Filters<E> notIn(Object ... propertyValues) {
        this.checkPropertyNameToFilterOnIsNotNull();
        ArrayList<E> newFilteredIterable = new ArrayList<E>();
        for (E element : this.filteredIterable) {
            Object propertyValueOfCurrentElement = this.propertySupport.propertyValueOf(this.propertyNameToFilterOn, propertyValues.getClass().getComponentType(), element);
            if (Filters.isItemInArray(propertyValueOfCurrentElement, propertyValues)) continue;
            newFilteredIterable.add(element);
        }
        this.filteredIterable = newFilteredIterable;
        return this;
    }

    private static boolean isItemInArray(Object item, Object[] arrayOfValues) {
        for (Object value : arrayOfValues) {
            if (!Objects.areEqual((Object)value, (Object)item)) continue;
            return true;
        }
        return false;
    }

    public Iterable<E> get() {
        return this.filteredIterable;
    }
}

