/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.compiler.compiler.PackageBuilderErrors;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.ClasspathKieProject;
import org.drools.compiler.kie.builder.impl.InternalKieContainer;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.KieRepositoryImpl;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kie.util.CDIHelper;
import org.drools.compiler.kie.util.ChangeSetBuilder;
import org.drools.compiler.kie.util.KieJarChangeSet;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.definitions.impl.KnowledgePackageImp;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.rule.Rule;
import org.drools.core.util.ClassUtils;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.FileLoggerModel;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.io.Resource;
import org.kie.api.logger.KieLoggers;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.ChangeType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.ResourceChangeSet;
import org.kie.internal.definition.KnowledgePackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieContainerImpl
implements InternalKieContainer {
    private static final Logger log = LoggerFactory.getLogger(KieContainerImpl.class);
    private KieProject kProject;
    private final Map<String, KieBase> kBases = new HashMap<String, KieBase>();
    private final Map<String, KieSession> kSessions = new HashMap<String, KieSession>();
    private final Map<String, StatelessKieSession> statelessKSessions = new HashMap<String, StatelessKieSession>();
    private final KieRepository kr;
    private ReleaseId containerReleaseId;

    public KieContainerImpl(KieProject kProject, KieRepository kr) {
        this.kr = kr;
        this.kProject = kProject;
        kProject.init();
    }

    public KieContainerImpl(KieProject kProject, KieRepository kr, ReleaseId containerReleaseId) {
        this(kProject, kr);
        this.containerReleaseId = containerReleaseId;
    }

    public ReleaseId getReleaseId() {
        return this.kProject.getGAV();
    }

    @Override
    public ReleaseId getContainerReleaseId() {
        return this.containerReleaseId != null ? this.containerReleaseId : this.getReleaseId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Results updateToVersion(ReleaseId newReleaseId) {
        Map.Entry<String, KieSession> ksession;
        if (this.kProject instanceof ClasspathKieProject) {
            throw new UnsupportedOperationException("It is not possible to update a classpath container to a new version.");
        }
        ResultsImpl results = new ResultsImpl();
        ReleaseId currentReleaseId = this.kProject.getGAV();
        InternalKieModule currentKM = currentReleaseId.equals(newReleaseId) && !currentReleaseId.equals(this.kr.getDefaultReleaseId()) ? (InternalKieModule)((KieRepositoryImpl)this.kr).getOldKieModule(currentReleaseId) : (InternalKieModule)this.kr.getKieModule(currentReleaseId);
        InternalKieModule newKM = (InternalKieModule)this.kr.getKieModule(newReleaseId);
        ChangeSetBuilder csb = new ChangeSetBuilder();
        KieJarChangeSet cs = csb.build(currentKM, newKM);
        ((KieModuleKieProject)this.kProject).updateToModule(newKM);
        ArrayList<String> kbasesToRemove = new ArrayList<String>();
        for (Map.Entry<String, KieBase> kBaseEntry : this.kBases.entrySet()) {
            String resourceName;
            String kbaseName = kBaseEntry.getKey();
            KieBaseModel kieBaseModel = this.kProject.getKieBaseModel(kbaseName);
            if (kieBaseModel == null) {
                kbasesToRemove.add(kbaseName);
                continue;
            }
            KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBase)((KnowledgeBase)kBaseEntry.getValue()));
            PackageBuilder pkgbuilder = kbuilder instanceof PackageBuilder ? (PackageBuilder)kbuilder : ((KnowledgeBuilderImpl)kbuilder).getPackageBuilder();
            CompositeKnowledgeBuilder ckbuilder = kbuilder.batch();
            ArrayList<String> modifiedClasses = new ArrayList<String>();
            int fileCount = 0;
            for (ResourceChangeSet rcs : cs.getChanges().values()) {
                if (rcs.getChangeType() != ChangeType.REMOVED) {
                    resourceName = rcs.getResourceName();
                    if (!resourceName.endsWith(".properties") && KieBuilderImpl.filterFileInKBase(newKM, kieBaseModel, resourceName)) {
                        Resource resource = currentKM.getResource(resourceName);
                        List changes = rcs.getChanges();
                        if (!changes.isEmpty()) {
                            fileCount += AbstractKieModule.updateResource(ckbuilder, newKM, resourceName, rcs) ? 1 : 0;
                        } else {
                            if (rcs.getChangeType() == ChangeType.UPDATED) {
                                pkgbuilder.removeObjectsGeneratedFromResource(resource);
                            }
                            fileCount += newKM.addResourceToCompiler(ckbuilder, resourceName) ? 1 : 0;
                        }
                    } else if (resourceName.endsWith(".class")) {
                        modifiedClasses.add(resourceName);
                        ++fileCount;
                    }
                }
                KieBase kBase = kBaseEntry.getValue();
                for (ResourceChangeSet.RuleLoadOrder loadOrder : rcs.getLoadOrder()) {
                    Rule rule = (Rule)((KnowledgePackageImp)kBase.getKiePackage(loadOrder.getPkgName())).getRule(loadOrder.getRuleName());
                    if (rule == null) continue;
                    rule.setLoadOrder(loadOrder.getLoadOrder());
                }
            }
            pkgbuilder.startPackageUpdate();
            try {
                ClassLoader rootClassLoader;
                for (ResourceChangeSet rcs : cs.getChanges().values()) {
                    if (rcs.getChangeType() != ChangeType.REMOVED || (resourceName = rcs.getResourceName()).endsWith(".properties") || !KieBuilderImpl.filterFileInKBase(newKM, kieBaseModel, resourceName)) continue;
                    pkgbuilder.removeObjectsGeneratedFromResource(currentKM.getResource(resourceName));
                }
                if (fileCount <= 0) continue;
                HashSet<String> modifiedPackages = new HashSet<String>();
                if (!modifiedClasses.isEmpty() && (rootClassLoader = pkgbuilder.getRootClassLoader()) instanceof ProjectClassLoader) {
                    ProjectClassLoader projectClassLoader = (ProjectClassLoader)rootClassLoader;
                    projectClassLoader.reinitTypes();
                    for (String resourceName2 : modifiedClasses) {
                        String className = ClassUtils.convertResourceToClassName((String)resourceName2);
                        byte[] bytes = newKM.getBytes(resourceName2);
                        Class clazz = projectClassLoader.defineClass(className, resourceName2, bytes);
                        modifiedPackages.add(clazz.getPackage().getName());
                    }
                    pkgbuilder.setAllRuntimesDirty(modifiedPackages);
                }
                ckbuilder.build();
                PackageBuilderErrors errors = pkgbuilder.getErrors();
                if (!errors.isEmpty()) {
                    for (DroolsError error : errors.getErrors()) {
                        results.addMessage(error);
                    }
                    log.error("Unable to update KieBase: " + kieBaseModel.getName() + " to release " + newReleaseId + "\n" + errors.toString());
                }
                if (modifiedClasses.isEmpty()) continue;
                pkgbuilder.rewireClassObjectTypes(modifiedPackages);
            }
            finally {
                pkgbuilder.completePackageUpdate();
            }
        }
        for (String kbaseToRemove : kbasesToRemove) {
            this.kBases.remove(kbaseToRemove);
        }
        Iterator<Map.Entry<String, KieSession>> it = this.kSessions.entrySet().iterator();
        while (it.hasNext()) {
            ksession = it.next();
            if (this.kProject.getKieSessionModel(ksession.getKey()) != null) continue;
            it.remove();
        }
        it = this.statelessKSessions.entrySet().iterator();
        while (it.hasNext()) {
            ksession = it.next();
            if (this.kProject.getKieSessionModel(ksession.getKey()) != null) continue;
            it.remove();
        }
        return results;
    }

    public KieBase getKieBase() {
        KieBaseModel defaultKieBaseModel = this.kProject.getDefaultKieBaseModel();
        if (defaultKieBaseModel == null) {
            throw new RuntimeException("Cannot find a default KieBase");
        }
        return this.getKieBase(defaultKieBaseModel.getName());
    }

    public Results verify() {
        return this.kProject.verify();
    }

    public KieBase getKieBase(String kBaseName) {
        KieBase kBase = this.kBases.get(kBaseName);
        if (kBase == null) {
            ResultsImpl msgs = new ResultsImpl();
            kBase = this.createKieBase(kBaseName, this.kProject, msgs, null);
            if (kBase == null) {
                throw new RuntimeException("Error while creating KieBase" + msgs.filterMessages(Message.Level.ERROR));
            }
            this.kBases.put(kBaseName, kBase);
        }
        return kBase;
    }

    public KieBase newKieBase(KieBaseConfiguration conf) {
        KieBaseModel defaultKieBaseModel = this.kProject.getDefaultKieBaseModel();
        if (defaultKieBaseModel == null) {
            throw new RuntimeException("Cannot find a defualt KieBase");
        }
        return this.newKieBase(defaultKieBaseModel.getName(), conf);
    }

    public KieBase newKieBase(String kBaseName, KieBaseConfiguration conf) {
        ResultsImpl msgs = new ResultsImpl();
        KieBase kBase = this.createKieBase(kBaseName, this.kProject, msgs, conf);
        if (kBase == null) {
            throw new RuntimeException("Error while creating KieBase" + msgs.filterMessages(Message.Level.ERROR));
        }
        return kBase;
    }

    private KieBase createKieBase(String kBaseName, KieProject kieProject, ResultsImpl messages, KieBaseConfiguration conf) {
        KnowledgeBuilder kbuilder;
        KieBaseModelImpl kBaseModel = (KieBaseModelImpl)this.kProject.getKieBaseModel(kBaseName);
        if (kBaseModel == null) {
            throw new RuntimeException("The requested KieBase \"" + kBaseName + "\" does not exist");
        }
        ClassLoader cl = kieProject.getClassLoader();
        InternalKieModule kModule = kieProject.getKieModuleForKBase(kBaseModel.getName());
        Collection<KnowledgePackage> pkgs = kModule.getKnowledgePackagesForKieBase(kBaseModel.getName());
        if (pkgs == null && (kbuilder = AbstractKieModule.buildKnowledgePackages(kBaseModel, kieProject, messages)).hasErrors()) {
            return null;
        }
        pkgs = kModule.getKnowledgePackagesForKieBase(kBaseModel.getName());
        if (kBaseModel.getEventProcessingMode() == EventProcessingOption.CLOUD && (conf == null || conf.getOption(EventProcessingOption.class) == EventProcessingOption.CLOUD)) {
            for (KnowledgePackage kpkg : pkgs) {
                if (!((KnowledgePackageImp)kpkg).pkg.needsStreamMode()) continue;
                throw new RuntimeException("The requested KieBase \"" + kBaseName + "\" has been set to run in CLOUD mode but requires features only available in STREAM mode");
            }
        }
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)(conf != null ? conf : this.getKnowledgeBaseConfiguration(kBaseModel, cl)));
        kBase.addKnowledgePackages(pkgs);
        return kBase;
    }

    private KieBaseConfiguration getKnowledgeBaseConfiguration(KieBaseModelImpl kBaseModel, ClassLoader cl) {
        KieBaseConfiguration kbConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration(null, (ClassLoader[])new ClassLoader[]{cl});
        kbConf.setOption((KieBaseOption)kBaseModel.getEqualsBehavior());
        kbConf.setOption((KieBaseOption)kBaseModel.getEventProcessingMode());
        kbConf.setOption((KieBaseOption)kBaseModel.getDeclarativeAgenda());
        return kbConf;
    }

    public KieSession newKieSession() {
        return this.newKieSession((Environment)null, null);
    }

    @Override
    public KieSession getKieSession() {
        KieSessionModel defaultKieSessionModel = this.findKieSessionModel(false);
        return this.getKieSession(defaultKieSessionModel.getName());
    }

    public KieSession newKieSession(KieSessionConfiguration conf) {
        return this.newKieSession((Environment)null, conf);
    }

    public KieSession newKieSession(Environment environment) {
        return this.newKieSession(environment, null);
    }

    public KieSession newKieSession(Environment environment, KieSessionConfiguration conf) {
        KieSessionModel defaultKieSessionModel = this.findKieSessionModel(false);
        return this.newKieSession(defaultKieSessionModel.getName(), environment, conf);
    }

    private KieSessionModel findKieSessionModel(boolean stateless) {
        KieSessionModel defaultKieSessionModel;
        KieSessionModel kieSessionModel = defaultKieSessionModel = stateless ? this.kProject.getDefaultStatelessKieSession() : this.kProject.getDefaultKieSession();
        if (defaultKieSessionModel == null) {
            throw new RuntimeException(stateless ? "Cannot find a default StatelessKieSession" : "Cannot find a default KieSession");
        }
        return defaultKieSessionModel;
    }

    public StatelessKieSession newStatelessKieSession() {
        return this.newStatelessKieSession((KieSessionConfiguration)null);
    }

    public StatelessKieSession newStatelessKieSession(KieSessionConfiguration conf) {
        KieSessionModel defaultKieSessionModel = this.findKieSessionModel(true);
        return this.newStatelessKieSession(defaultKieSessionModel.getName(), conf);
    }

    @Override
    public StatelessKieSession getStatelessKieSession() {
        KieSessionModel defaultKieSessionModel = this.findKieSessionModel(true);
        return this.getStatelessKieSession(defaultKieSessionModel.getName());
    }

    public KieSession newKieSession(String kSessionName) {
        return this.newKieSession(kSessionName, null, null);
    }

    @Override
    public KieSession getKieSession(String kSessionName) {
        KieSession kieSession = this.kSessions.get(kSessionName);
        return kieSession != null ? kieSession : this.newKieSession(kSessionName);
    }

    public KieSession newKieSession(String kSessionName, Environment environment) {
        return this.newKieSession(kSessionName, environment, null);
    }

    public KieSession newKieSession(String kSessionName, KieSessionConfiguration conf) {
        return this.newKieSession(kSessionName, null, conf);
    }

    public KieSession newKieSession(String kSessionName, Environment environment, KieSessionConfiguration conf) {
        KieSessionModelImpl kSessionModel = (KieSessionModelImpl)this.getKieSessionModel(kSessionName);
        if (kSessionModel == null) {
            log.error("Unknown KieSession name: " + kSessionName);
            return null;
        }
        if (kSessionModel.getType() == KieSessionModel.KieSessionType.STATELESS) {
            throw new RuntimeException("Trying to create a stateful KieSession from a stateless KieSessionModel: " + kSessionName);
        }
        KieBase kBase = this.getKieBase(kSessionModel.getKieBaseModel().getName());
        if (kBase == null) {
            log.error("Unknown KieBase name: " + kSessionModel.getKieBaseModel().getName());
            return null;
        }
        KieSession kSession = kBase.newKieSession(conf != null ? conf : this.getKnowledgeSessionConfiguration(kSessionModel), environment);
        CDIHelper.wireListnersAndWIHs(kSessionModel, kSession);
        this.registerLoggers(kSessionModel, (KieRuntimeEventManager)kSession);
        KieSession oldSession = this.kSessions.remove(kSessionName);
        if (oldSession != null) {
            oldSession.dispose();
        }
        this.kSessions.put(kSessionName, kSession);
        return kSession;
    }

    private void registerLoggers(KieSessionModelImpl kSessionModel, KieRuntimeEventManager kSession) {
        FileLoggerModel fileLogger;
        KieLoggers kieLoggers = KieServices.Factory.get().getLoggers();
        if (kSessionModel.getConsoleLogger() != null) {
            kieLoggers.newConsoleLogger(kSession);
        }
        if ((fileLogger = kSessionModel.getFileLogger()) != null) {
            if (fileLogger.isThreaded()) {
                kieLoggers.newThreadedFileLogger(kSession, fileLogger.getFile(), fileLogger.getInterval());
            } else {
                kieLoggers.newFileLogger(kSession, fileLogger.getFile());
            }
        }
    }

    public StatelessKieSession newStatelessKieSession(String kSessionName) {
        return this.newStatelessKieSession(kSessionName, null);
    }

    public StatelessKieSession newStatelessKieSession(String kSessionName, KieSessionConfiguration conf) {
        KieSessionModelImpl kSessionModel = (KieSessionModelImpl)this.kProject.getKieSessionModel(kSessionName);
        if (kSessionName == null) {
            log.error("Unknown KieSession name: " + kSessionName);
            return null;
        }
        if (kSessionModel.getType() == KieSessionModel.KieSessionType.STATEFUL) {
            throw new RuntimeException("Trying to create a stateless KieSession from a stateful KieSessionModel: " + kSessionName);
        }
        KieBase kBase = this.getKieBase(kSessionModel.getKieBaseModel().getName());
        if (kBase == null) {
            log.error("Unknown KieBase name: " + kSessionModel.getKieBaseModel().getName());
            return null;
        }
        StatelessKieSession statelessKieSession = kBase.newStatelessKieSession(conf != null ? conf : this.getKnowledgeSessionConfiguration(kSessionModel));
        this.registerLoggers(kSessionModel, (KieRuntimeEventManager)statelessKieSession);
        this.statelessKSessions.put(kSessionName, statelessKieSession);
        return statelessKieSession;
    }

    @Override
    public StatelessKieSession getStatelessKieSession(String kSessionName) {
        StatelessKieSession kieSession = this.statelessKSessions.get(kSessionName);
        return kieSession != null ? kieSession : this.newStatelessKieSession(kSessionName);
    }

    private KieSessionConfiguration getKnowledgeSessionConfiguration(KieSessionModelImpl kSessionModel) {
        KieSessionConfiguration ksConf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksConf.setOption((KieSessionOption)kSessionModel.getClockType());
        ksConf.setOption((KieSessionOption)kSessionModel.getBeliefSystem());
        return ksConf;
    }

    @Override
    public void dispose() {
        for (KieSession kieSession : this.kSessions.values()) {
            kieSession.dispose();
        }
        this.kSessions.clear();
        this.statelessKSessions.clear();
    }

    public KieProject getKieProject() {
        return this.kProject;
    }

    public KieModule getKieModuleForKBase(String kBaseName) {
        return this.kProject.getKieModuleForKBase(kBaseName);
    }

    @Override
    public KieBaseModel getKieBaseModel(String kBaseName) {
        return this.kProject.getKieBaseModel(kBaseName);
    }

    @Override
    public KieSessionModel getKieSessionModel(String kSessionName) {
        return this.kProject.getKieSessionModel(kSessionName);
    }

    public ClassLoader getClassLoader() {
        return this.kProject.getClassLoader();
    }
}

