/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.core.listener;

import java.io.Serializable;

public class DeviceMetric
implements Serializable {
    private double load;
    private double totalMemory;
    private String deviceName;
    private double temp;
    private double memAvailable;
    private long bandwidthDeviceToHost;
    private long bandwidthHostToDevice;
    private long bandwidthDeviceToDevice;

    private DeviceMetric() {
    }

    public static DeviceMetricBuilder builder() {
        return new DeviceMetricBuilder();
    }

    public double getLoad() {
        return this.load;
    }

    public double getTotalMemory() {
        return this.totalMemory;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public double getTemp() {
        return this.temp;
    }

    public double getMemAvailable() {
        return this.memAvailable;
    }

    public long getBandwidthDeviceToHost() {
        return this.bandwidthDeviceToHost;
    }

    public long getBandwidthHostToDevice() {
        return this.bandwidthHostToDevice;
    }

    public long getBandwidthDeviceToDevice() {
        return this.bandwidthDeviceToDevice;
    }

    public void setLoad(double load) {
        this.load = load;
    }

    public void setTotalMemory(double totalMemory) {
        this.totalMemory = totalMemory;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public void setTemp(double temp) {
        this.temp = temp;
    }

    public void setMemAvailable(double memAvailable) {
        this.memAvailable = memAvailable;
    }

    public void setBandwidthDeviceToHost(long bandwidthDeviceToHost) {
        this.bandwidthDeviceToHost = bandwidthDeviceToHost;
    }

    public void setBandwidthHostToDevice(long bandwidthHostToDevice) {
        this.bandwidthHostToDevice = bandwidthHostToDevice;
    }

    public void setBandwidthDeviceToDevice(long bandwidthDeviceToDevice) {
        this.bandwidthDeviceToDevice = bandwidthDeviceToDevice;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceMetric)) {
            return false;
        }
        DeviceMetric other = (DeviceMetric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLoad(), other.getLoad()) != 0) {
            return false;
        }
        if (Double.compare(this.getTotalMemory(), other.getTotalMemory()) != 0) {
            return false;
        }
        String this$deviceName = this.getDeviceName();
        String other$deviceName = other.getDeviceName();
        if (this$deviceName == null ? other$deviceName != null : !this$deviceName.equals(other$deviceName)) {
            return false;
        }
        if (Double.compare(this.getTemp(), other.getTemp()) != 0) {
            return false;
        }
        if (Double.compare(this.getMemAvailable(), other.getMemAvailable()) != 0) {
            return false;
        }
        if (this.getBandwidthDeviceToHost() != other.getBandwidthDeviceToHost()) {
            return false;
        }
        if (this.getBandwidthHostToDevice() != other.getBandwidthHostToDevice()) {
            return false;
        }
        return this.getBandwidthDeviceToDevice() == other.getBandwidthDeviceToDevice();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceMetric;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $load = Double.doubleToLongBits(this.getLoad());
        result = result * 59 + (int)($load >>> 32 ^ $load);
        long $totalMemory = Double.doubleToLongBits(this.getTotalMemory());
        result = result * 59 + (int)($totalMemory >>> 32 ^ $totalMemory);
        String $deviceName = this.getDeviceName();
        result = result * 59 + ($deviceName == null ? 43 : $deviceName.hashCode());
        long $temp = Double.doubleToLongBits(this.getTemp());
        result = result * 59 + (int)($temp >>> 32 ^ $temp);
        long $memAvailable = Double.doubleToLongBits(this.getMemAvailable());
        result = result * 59 + (int)($memAvailable >>> 32 ^ $memAvailable);
        long $bandwidthDeviceToHost = this.getBandwidthDeviceToHost();
        result = result * 59 + (int)($bandwidthDeviceToHost >>> 32 ^ $bandwidthDeviceToHost);
        long $bandwidthHostToDevice = this.getBandwidthHostToDevice();
        result = result * 59 + (int)($bandwidthHostToDevice >>> 32 ^ $bandwidthHostToDevice);
        long $bandwidthDeviceToDevice = this.getBandwidthDeviceToDevice();
        result = result * 59 + (int)($bandwidthDeviceToDevice >>> 32 ^ $bandwidthDeviceToDevice);
        return result;
    }

    public String toString() {
        return "DeviceMetric(load=" + this.getLoad() + ", totalMemory=" + this.getTotalMemory() + ", deviceName=" + this.getDeviceName() + ", temp=" + this.getTemp() + ", memAvailable=" + this.getMemAvailable() + ", bandwidthDeviceToHost=" + this.getBandwidthDeviceToHost() + ", bandwidthHostToDevice=" + this.getBandwidthHostToDevice() + ", bandwidthDeviceToDevice=" + this.getBandwidthDeviceToDevice() + ")";
    }

    public DeviceMetric(double load, double totalMemory, String deviceName, double temp, double memAvailable, long bandwidthDeviceToHost, long bandwidthHostToDevice, long bandwidthDeviceToDevice) {
        this.load = load;
        this.totalMemory = totalMemory;
        this.deviceName = deviceName;
        this.temp = temp;
        this.memAvailable = memAvailable;
        this.bandwidthDeviceToHost = bandwidthDeviceToHost;
        this.bandwidthHostToDevice = bandwidthHostToDevice;
        this.bandwidthDeviceToDevice = bandwidthDeviceToDevice;
    }

    public static class DeviceMetricBuilder {
        private double load;
        private double totalMemory;
        private String deviceName;
        private double temp;
        private double memAvailable;
        private long bandwidthDeviceToHost;
        private long bandwidthHostToDevice;
        private long bandwidthDeviceToDevice;

        DeviceMetricBuilder() {
        }

        public DeviceMetricBuilder load(double load) {
            this.load = load;
            return this;
        }

        public DeviceMetricBuilder totalMemory(double totalMemory) {
            this.totalMemory = totalMemory;
            return this;
        }

        public DeviceMetricBuilder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public DeviceMetricBuilder temp(double temp) {
            this.temp = temp;
            return this;
        }

        public DeviceMetricBuilder memAvailable(double memAvailable) {
            this.memAvailable = memAvailable;
            return this;
        }

        public DeviceMetricBuilder bandwidthDeviceToHost(long bandwidthDeviceToHost) {
            this.bandwidthDeviceToHost = bandwidthDeviceToHost;
            return this;
        }

        public DeviceMetricBuilder bandwidthHostToDevice(long bandwidthHostToDevice) {
            this.bandwidthHostToDevice = bandwidthHostToDevice;
            return this;
        }

        public DeviceMetricBuilder bandwidthDeviceToDevice(long bandwidthDeviceToDevice) {
            this.bandwidthDeviceToDevice = bandwidthDeviceToDevice;
            return this;
        }

        public DeviceMetric build() {
            return new DeviceMetric(this.load, this.totalMemory, this.deviceName, this.temp, this.memAvailable, this.bandwidthDeviceToHost, this.bandwidthHostToDevice, this.bandwidthDeviceToDevice);
        }

        public String toString() {
            return "DeviceMetric.DeviceMetricBuilder(load=" + this.load + ", totalMemory=" + this.totalMemory + ", deviceName=" + this.deviceName + ", temp=" + this.temp + ", memAvailable=" + this.memAvailable + ", bandwidthDeviceToHost=" + this.bandwidthDeviceToHost + ", bandwidthHostToDevice=" + this.bandwidthHostToDevice + ", bandwidthDeviceToDevice=" + this.bandwidthDeviceToDevice + ")";
        }
    }
}

