/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.LicenseText;
import org.json.JSONArray;
import org.json.JSONObject;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.license.LicenseSet;
import org.spdx.rdfparser.license.ListedLicenses;
import org.spdx.rdfparser.license.OrLaterOperator;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.spdxspreadsheet.InvalidLicenseStringException;

public final class LicenseResolver {
    private static final Map<String, License> resolvedByUrl = new ConcurrentHashMap<String, License>();
    private static Map<String, List<String>> mappings = new HashMap<String, List<String>>();

    private LicenseResolver() {
    }

    public static LicenseChoice resolve(String licenseString, boolean includeLicenseText) {
        try {
            return LicenseResolver.resolveSpdxLicenseString(licenseString, includeLicenseText);
        }
        catch (InvalidLicenseStringException e1) {
            LicenseChoice licenseChoice = LicenseResolver.resolveViaAlternativeMapping(licenseString, includeLicenseText);
            if (licenseChoice != null) {
                return licenseChoice;
            }
            try {
                new URL(licenseString);
                License parsedLicense = LicenseResolver.parseLicenseByUrl(licenseString, includeLicenseText);
                if (parsedLicense != null) {
                    LicenseChoice choice = new LicenseChoice();
                    choice.addLicense(parsedLicense);
                    return choice;
                }
            }
            catch (MalformedURLException | InvalidLicenseStringException throwable) {
                // empty catch block
            }
            return null;
        }
    }

    public static LicenseChoice resolve(String licenseString) {
        return LicenseResolver.resolve(licenseString, true);
    }

    public static LicenseChoice resolveSpdxLicenseString(String licenseString, boolean includeLicenseText) throws InvalidLicenseStringException {
        AnyLicenseInfo licenseInfo = LicenseInfoFactory.parseSPDXLicenseString((String)licenseString);
        if (licenseInfo instanceof SpdxListedLicense) {
            SpdxListedLicense spdxListedLicense = (SpdxListedLicense)licenseInfo;
            LicenseChoice choice = new LicenseChoice();
            choice.addLicense(LicenseResolver.createLicenseObject(spdxListedLicense, includeLicenseText));
            return choice;
        }
        if (licenseInfo instanceof OrLaterOperator) {
            OrLaterOperator orLaterOperator = (OrLaterOperator)licenseInfo;
            SpdxListedLicense spdxListedLicense = (SpdxListedLicense)orLaterOperator.getLicense();
            LicenseChoice choice = new LicenseChoice();
            choice.addLicense(LicenseResolver.createLicenseObject(spdxListedLicense, includeLicenseText));
            return choice;
        }
        if (licenseInfo instanceof LicenseSet) {
            LicenseChoice choice = new LicenseChoice();
            choice.setExpression(licenseString);
            return choice;
        }
        return null;
    }

    public static LicenseChoice resolveSpdxLicenseString(String licenseString) throws InvalidLicenseStringException {
        return LicenseResolver.resolveSpdxLicenseString(licenseString, true);
    }

    public static LicenseChoice resolveSpdxLicenseId(String licenseId, boolean includeLicenseText) throws InvalidSPDXAnalysisException {
        SpdxListedLicense spdxLicense = LicenseInfoFactory.getListedLicenseById((String)licenseId);
        LicenseChoice choice = new LicenseChoice();
        choice.addLicense(LicenseResolver.createLicenseObject(spdxLicense, includeLicenseText));
        return choice;
    }

    public static LicenseChoice resolveSpdxLicenseId(String licenseId) throws InvalidSPDXAnalysisException {
        return LicenseResolver.resolveSpdxLicenseId(licenseId, true);
    }

    public static License parseLicenseByUrl(String licenseUrl, boolean includeLicenseText) throws InvalidLicenseStringException {
        String protocolExcludedUrl = licenseUrl.replace("http://", "").replace("https://", "");
        ListedLicenses ll = ListedLicenses.getListedLicenses();
        License license = resolvedByUrl.get(licenseUrl);
        if (license != null) {
            return license;
        }
        for (String licenseId : ll.getSpdxListedLicenseIds()) {
            AnyLicenseInfo licenseInfo = LicenseInfoFactory.parseSPDXLicenseString((String)licenseId);
            if (!(licenseInfo instanceof SpdxListedLicense)) continue;
            SpdxListedLicense spdxListedLicense = (SpdxListedLicense)licenseInfo;
            for (String seeAlso : spdxListedLicense.getSeeAlso()) {
                String protocolExcludedSeeAlsoUrl = seeAlso.replace("http://", "").replace("https://", "");
                if (!protocolExcludedUrl.toLowerCase().contains(protocolExcludedSeeAlsoUrl.toLowerCase()) && !protocolExcludedSeeAlsoUrl.toLowerCase().contains(protocolExcludedUrl.toLowerCase())) continue;
                license = LicenseResolver.createLicenseObject(spdxListedLicense, includeLicenseText);
                resolvedByUrl.put(licenseUrl, license);
                return license;
            }
        }
        return null;
    }

    public static License parseLicenseByUrl(String licenseUrl) throws InvalidLicenseStringException {
        return LicenseResolver.parseLicenseByUrl(licenseUrl, true);
    }

    private static License createLicenseObject(SpdxListedLicense spdxListedLicense, boolean includeLicenseText) {
        License license = new License();
        license.setId(spdxListedLicense.getLicenseId());
        license.setName(spdxListedLicense.getName());
        if (spdxListedLicense.getSeeAlso() != null && spdxListedLicense.getSeeAlso().length > 0) {
            license.setUrl(spdxListedLicense.getSeeAlso()[0]);
        }
        if (includeLicenseText && spdxListedLicense.getLicenseText() != null) {
            LicenseText text = new LicenseText();
            text.setContentType("plain/text");
            text.setEncoding("base64");
            text.setText(Base64.getEncoder().encodeToString(spdxListedLicense.getLicenseText().getBytes()));
            license.setLicenseText(text);
        }
        return license;
    }

    private static LicenseChoice resolveViaAlternativeMapping(String licenseString, boolean includeLicenseText) {
        if (licenseString == null) {
            return null;
        }
        try {
            for (Map.Entry<String, List<String>> mapping : mappings.entrySet()) {
                List<String> names = mapping.getValue();
                if (names == null) continue;
                for (String name : names) {
                    if (!licenseString.equalsIgnoreCase(name)) continue;
                    return LicenseResolver.resolveSpdxLicenseString(mapping.getKey(), includeLicenseText);
                }
            }
        }
        catch (InvalidLicenseStringException invalidLicenseStringException) {
            // empty catch block
        }
        return null;
    }

    static {
        InputStream is = LicenseResolver.class.getResourceAsStream("/license-mapping.json");
        try {
            String jsonTxt = IOUtils.toString((InputStream)is, (String)"UTF-8");
            JSONArray json = new JSONArray(jsonTxt);
            for (int i = 0; i < json.length(); ++i) {
                JSONObject mapping = json.getJSONObject(i);
                if (!mappings.containsKey(mapping.getString("exp"))) {
                    mappings.put(mapping.getString("exp"), new ArrayList());
                }
                List<String> names = mappings.get(mapping.getString("exp"));
                for (int n = 0; n < mapping.getJSONArray("names").length(); ++n) {
                    names.add(mapping.getJSONArray("names").getString(n));
                }
                mappings.replace(mapping.getString("exp"), names);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

