/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public abstract class CycloneDxSchema {
    private static final Logger LOGGER = Logger.getLogger(CycloneDxSchema.class.getName());
    public static final String NS_BOM_10 = "http://cyclonedx.org/schema/bom/1.0";
    public static final String NS_BOM_11 = "http://cyclonedx.org/schema/bom/1.1";
    public static final String NS_BOM_LATEST = "http://cyclonedx.org/schema/bom/1.1";
    public static final String NS_DEPENDENCY_GRAPH_10 = "http://cyclonedx.org/schema/ext/dependency-graph/1.0";
    public static final String NS_VULNERABILITY_10 = "http://cyclonedx.org/schema/ext/vulnerability/1.0";
    public static final String NS_BOM_DESCRIPTOR_10 = "http://cyclonedx.org/schema/ext/bom-descriptor/1.0";

    public Schema getXmlSchema(Version schemaVersion) throws SAXException {
        if (Version.VERSION_10 == schemaVersion) {
            return this.getXmlSchema10();
        }
        return this.getXmlSchema11();
    }

    private Schema getXmlSchema10() throws SAXException {
        return this.getXmlSchema(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd"), this.getClass().getClassLoader().getResourceAsStream("bom-1.0.xsd"));
    }

    private Schema getXmlSchema11() throws SAXException {
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        streams.add(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd"));
        streams.add(this.getClass().getClassLoader().getResourceAsStream("bom-1.1.xsd"));
        streams.addAll(this.loadSchemaFromExtensions("ext"));
        return this.getXmlSchema(streams.toArray(new InputStream[0]));
    }

    protected List<InputStream> loadSchemaFromExtensions(String extLocation) {
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        try {
            URL url = this.getClass().getClassLoader().getResource(extLocation);
            if (url != null) {
                URI uri = url.toURI();
                if (uri.getScheme().equals("jar")) {
                    LOGGER.log(Level.FINE, "Provided location loaded as a jar", uri.toASCIIString());
                    FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                    Stream<Path> walk = Files.list(fileSystem.getPath(extLocation, new String[0]));
                    Iterator it = walk.iterator();
                    while (it.hasNext()) {
                        Path p = (Path)it.next();
                        LOGGER.log(Level.FINE, "Reading resource ", p.getFileName().toString());
                        streams.add(this.getClass().getClassLoader().getResourceAsStream(extLocation + "/" + p.getFileName().toString()));
                    }
                    fileSystem.close();
                } else {
                    LOGGER.log(Level.FINE, "Provided location loaded as a regular file ", uri.toASCIIString());
                    Stream<Path> walk = Files.list(Paths.get(uri));
                    Iterator it = walk.iterator();
                    while (it.hasNext()) {
                        Path p = (Path)it.next();
                        LOGGER.log(Level.FINE, "Reading resource ", p.getFileName().toString());
                        streams.add(this.getClass().getClassLoader().getResourceAsStream(extLocation + "/" + p.getFileName().toString()));
                    }
                }
            } else {
                LOGGER.log(Level.WARNING, "Unable to load the requested resource from url");
            }
        }
        catch (URISyntaxException use) {
            LOGGER.log(Level.WARNING, "An error occurred attempting to load schema extensions", use);
        }
        catch (IOException io) {
            LOGGER.log(Level.WARNING, "An error occurred attempting to load schema extensions", io);
        }
        return streams;
    }

    public Schema getXmlSchema(InputStream ... inputStreams) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source[] schemaFiles = new Source[inputStreams.length];
        for (int i = 0; i < inputStreams.length; ++i) {
            schemaFiles[i] = new StreamSource(inputStreams[i]);
        }
        return schemaFactory.newSchema(schemaFiles);
    }

    public static enum Version {
        VERSION_10("http://cyclonedx.org/schema/bom/1.0", "1.0"),
        VERSION_11("http://cyclonedx.org/schema/bom/1.1", "1.1");

        private String namespace;
        private String versionString;

        public String getNamespace() {
            return this.namespace;
        }

        public String getVersionString() {
            return this.versionString;
        }

        private Version(String namespace, String versionString) {
            this.namespace = namespace;
            this.versionString = versionString;
        }
    }
}

