/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx;

import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public abstract class CycloneDxSchema {
    public static final String NS_BOM_10 = "http://cyclonedx.org/schema/bom/1.0";
    public static final String NS_BOM_11 = "http://cyclonedx.org/schema/bom/1.1";
    public static final String NS_BOM_LATEST = "http://cyclonedx.org/schema/bom/1.1";

    public Schema getXmlSchema(Version schemaVersion) throws SAXException {
        if (Version.VERSION_10 == schemaVersion) {
            return this.getXmlSchema10();
        }
        return this.getXmlSchema11();
    }

    private Schema getXmlSchema10() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source[] schemaFiles = new Source[]{new StreamSource(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd")), new StreamSource(this.getClass().getClassLoader().getResourceAsStream("bom-1.0.xsd"))};
        return schemaFactory.newSchema(schemaFiles);
    }

    private Schema getXmlSchema11() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source[] schemaFiles = new Source[]{new StreamSource(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd")), new StreamSource(this.getClass().getClassLoader().getResourceAsStream("bom-1.1.xsd"))};
        return schemaFactory.newSchema(schemaFiles);
    }

    public static enum Version {
        VERSION_10("http://cyclonedx.org/schema/bom/1.0"),
        VERSION_11("http://cyclonedx.org/schema/bom/1.1");

        private String namespace;

        public String getNamespace() {
            return this.namespace;
        }

        private Version(String namespace) {
            this.namespace = namespace;
        }
    }
}

