/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.maven;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.sonar.maven.ExceptionHandling;
import org.sonar.runner.api.EmbeddedRunner;

public final class SonarMojo
extends AbstractMojo {
    private MavenSession session;
    private MavenProject project;
    private LifecycleExecutor lifecycleExecutor;
    private ArtifactFactory artifactFactory;
    private ArtifactRepository localRepository;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private DependencyTreeBuilder dependencyTreeBuilder;
    private MavenProjectBuilder projectBuilder;
    RuntimeInformation runtimeInformation;

    public void execute() throws MojoExecutionException {
        ArtifactVersion mavenVersion = this.getMavenVersion();
        if (mavenVersion.getMajorVersion() == 2 && mavenVersion.getMinorVersion() < 2) {
            ExceptionHandling.handle("Please use at least Maven 2.2.x to perform SonarQube analysis (current version is " + mavenVersion.toString() + ")", this.getLog());
        }
        try {
            EmbeddedRunner runner = (EmbeddedRunner)((EmbeddedRunner)((EmbeddedRunner)((EmbeddedRunner)EmbeddedRunner.create().setApp("Maven", mavenVersion.toString())).addProperties(this.session.getExecutionProperties())).addProperties(this.project.getModel().getProperties())).addProperties(this.session.getUserProperties());
            String encoding = SonarMojo.getSourceEncoding(this.project);
            if (encoding != null) {
                runner.setProperty("sonar.sourceEncoding", encoding);
            }
            ((EmbeddedRunner)((EmbeddedRunner)((EmbeddedRunner)((EmbeddedRunner)((EmbeddedRunner)((EmbeddedRunner)runner.setProperty("sonar.projectKey", SonarMojo.getSonarKey(this.project))).setProperty("sonar.working.directory", SonarMojo.getSonarWorkDir(this.project).getAbsolutePath())).setProperty("sonar.projectBaseDir", this.project.getBasedir().getAbsolutePath())).setProperty("sonar.projectVersion", SonarMojo.toString(this.project.getVersion()))).setProperty("sonar.projectName", SonarMojo.toString(this.project.getName()))).setProperty("sonar.projectDescription", SonarMojo.toString(this.project.getDescription()))).setProperty("sonar.sources", ".");
            runner.mask("org.slf4j.LoggerFactory").unmask("org.slf4j.Logger").unmask("org.slf4j.ILoggerFactory").mask("org.slf4j.").mask("ch.qos.logback.").mask("org.sonar.").unmask("");
            runner.addExtensions(new Object[]{this.session, this.getLog(), this.lifecycleExecutor, this.artifactFactory, this.localRepository, this.artifactMetadataSource, this.artifactCollector, this.dependencyTreeBuilder, this.projectBuilder});
            if (this.getLog().isDebugEnabled()) {
                runner.setProperty("sonar.verbose", "true");
            }
            runner.execute();
        }
        catch (Exception e) {
            throw ExceptionHandling.handle(e, this.getLog());
        }
    }

    private ArtifactVersion getMavenVersion() {
        return this.runtimeInformation.getApplicationVersion();
    }

    public static String toString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static String getSourceEncoding(MavenProject pom) {
        return pom.getProperties().getProperty("project.build.sourceEncoding");
    }

    public static String getSonarKey(MavenProject pom) {
        return pom.getGroupId() + ":" + pom.getArtifactId();
    }

    public static File getSonarWorkDir(MavenProject pom) {
        return new File(SonarMojo.getBuildDir(pom), "sonar");
    }

    private static File getBuildDir(MavenProject pom) {
        return SonarMojo.resolvePath(pom.getBuild().getDirectory(), pom.getBasedir());
    }

    static File resolvePath(String path, File basedir) {
        if (path != null) {
            File file = new File(path);
            if (!file.isAbsolute()) {
                try {
                    file = new File(basedir, path).getCanonicalFile();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to resolve path '" + path + "'", e);
                }
            }
            return file;
        }
        return null;
    }
}

