/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.impl;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.sonar.runner.impl.JarExtractor;
import org.sonar.runner.impl.Jars30;
import org.sonar.runner.impl.Jars35;
import org.sonar.runner.impl.ServerConnection;
import org.sonar.runner.impl.ServerVersion;

class JarDownloader {
    private final ServerConnection serverConnection;
    private final ServerVersion serverVersion;
    private final Properties props;

    JarDownloader(Properties props, ServerConnection conn, ServerVersion version) {
        this.props = props;
        this.serverConnection = conn;
        this.serverVersion = version;
    }

    List<File> download() {
        List<File> jarFiles;
        if (this.serverVersion.is35Compatible()) {
            jarFiles = this.download35();
        } else if (this.serverVersion.is30Compatible()) {
            jarFiles = this.download30();
        } else {
            throw new IllegalStateException("Sonar " + this.serverVersion.version() + " is not supported. Please upgrade Sonar to version 3.0 or more.");
        }
        return jarFiles;
    }

    List<File> download30() {
        String workDir = this.props.getProperty("sonar.working.directory");
        return new Jars30(this.serverConnection).download(new File(workDir), new JarExtractor());
    }

    List<File> download35() {
        return new Jars35(this.serverConnection, new JarExtractor()).download();
    }
}

