/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf.entity;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.httpclient.HttpException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.sonar.report.pdf.entity.Violation;
import org.sonar.report.pdf.entity.exception.ReportException;
import org.sonar.report.pdf.util.Logger;
import org.sonar.report.pdf.util.SonarAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rule {
    private String key;
    private String name;
    private String description;
    private List<Violation> topViolatedResources;
    private float violationsNumber;
    private String violationsNumberFormatted;
    private String message;
    private static final String RULE_NAME = "rule_name";
    private static final String RULE_KEY = "rule_key";
    private static final String RULE_VIOLATIONS_NUMBER = "val";
    private static final String RULE_VIOLATIONS_NUMBER_FORMATTED = "frmt_val";
    private static final String ISSUES = "/issues/issues/issue";
    private static final String COMPONENT = "component";
    private static final String MESSAGE = "message";
    private static final String LINE = "line";

    public static Rule initFromNode(Node ruleNode) {
        Rule rule = new Rule();
        rule.setKey(ruleNode.selectSingleNode(RULE_KEY).getText());
        rule.setName(ruleNode.selectSingleNode(RULE_NAME).getText());
        rule.setViolationsNumber(Float.valueOf(ruleNode.selectSingleNode(RULE_VIOLATIONS_NUMBER).getText()).floatValue());
        rule.setViolationsNumberFormatted(ruleNode.selectSingleNode(RULE_VIOLATIONS_NUMBER_FORMATTED).getText());
        return rule;
    }

    public void loadViolatedResources(SonarAccess sonarAccess, String projectKey) throws ReportException, HttpException, IOException, DocumentException {
        String ruleKey = this.getKey();
        if (ruleKey == null) {
            throw new ReportException("Rule not initialized. Forget call to initFromNode() previously?");
        }
        ruleKey = URLEncoder.encode(ruleKey, "UTF8");
        Logger.debug("Accessing Sonar: getting violated resurces by one given rule (" + this.getKey() + ")");
        Document violatedResourcesDocument = sonarAccess.getUrlAsDocument("/api/issues/search?resource=" + projectKey + "&scopes=FIL&depth=-1&limit=20&rules=" + ruleKey + "&format=xml");
        List violatedResources = violatedResourcesDocument.selectNodes(ISSUES);
        this.topViolatedResources = new LinkedList<Violation>();
        for (Node resource : violatedResources) {
            if (this.message == null) {
                this.message = resource.selectSingleNode(MESSAGE).getText();
            }
            String resourceKey = resource.selectSingleNode(COMPONENT).getText();
            String line = "N/A";
            Node resourceLine = resource.selectSingleNode(LINE);
            if (resourceLine != null) {
                line = resourceLine.getText();
            }
            this.topViolatedResources.add(new Violation(line, resourceKey, ""));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Violation> getTopViolations() {
        return this.topViolatedResources;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTopViolations(List<Violation> violations) {
        this.topViolatedResources = violations;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public float getViolationsNumber() {
        return this.violationsNumber;
    }

    public void setViolationsNumber(float violationsNumber) {
        this.violationsNumber = violationsNumber;
    }

    public String getViolationsNumberFormatted() {
        return this.violationsNumberFormatted;
    }

    public void setViolationsNumberFormatted(String violationsNumberFormatted) {
        this.violationsNumberFormatted = violationsNumberFormatted;
    }
}

