/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.repository.exception;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.ComponentStack;
import org.codehaus.plexus.component.ComponentStackElement;
import org.codehaus.plexus.component.repository.ComponentDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentLookupException
extends Exception {
    private String LS = System.getProperty("line.separator");
    private String role;
    private String roleHint;
    private ClassRealm realm;
    private List<ComponentStackElement> componentStack;

    public ComponentLookupException(String message, String role, String roleHint) {
        this(message, role, roleHint, null, null);
    }

    public ComponentLookupException(String message, Class<?> type, String roleHint) {
        this(message, type.getName(), roleHint, null, null);
    }

    public ComponentLookupException(String message, String role, String roleHint, Throwable cause) {
        this(message, role, roleHint, null, cause);
    }

    public ComponentLookupException(String message, Class<?> type, String roleHint, Throwable cause) {
        this(message, type.getName(), roleHint, null, cause);
    }

    public ComponentLookupException(String message, String role, String roleHint, ClassRealm realm) {
        this(message, role, roleHint, realm, null);
    }

    public ComponentLookupException(String message, Class<?> type, String roleHint, ClassRealm realm) {
        this(message, type.getName(), roleHint, realm, null);
    }

    public ComponentLookupException(String message, String role, String roleHint, ClassRealm realm, Throwable cause) {
        super(message, cause);
        this.role = role;
        this.roleHint = roleHint;
        this.realm = realm;
        this.componentStack = ComponentStack.getComponentStack();
    }

    public ComponentLookupException(String message, ComponentDescriptor<?> descriptor) {
        this(message, descriptor.getRole(), descriptor.getRoleHint(), descriptor.getRealm(), null);
    }

    public ComponentLookupException(String message, ComponentDescriptor<?> descriptor, Throwable cause) {
        this(message, descriptor.getRole(), descriptor.getRoleHint(), descriptor.getRealm(), cause);
    }

    public List<ComponentStackElement> getComponentStack() {
        if (this.componentStack != null) {
            return this.componentStack;
        }
        return Collections.emptyList();
    }

    public void setComponentStack(List<ComponentStackElement> componentStack) {
        this.componentStack = Collections.unmodifiableList(new ArrayList<ComponentStackElement>(componentStack));
    }

    @Override
    public String getMessage() {
        StringBuffer sb = new StringBuffer().append(super.getMessage()).append(this.LS).append("      role: ").append(this.role).append(this.LS).append("  roleHint: ").append(this.roleHint).append(this.LS).append("classRealm: ");
        if (this.realm != null) {
            sb.append(this.realm.getId());
            this.realm.display();
        } else {
            sb.append("none specified");
        }
        sb.append(this.LS);
        sb.append(this.LS);
        sb.append("Component stack:").append(this.LS);
        for (ComponentStackElement element : this.componentStack) {
            sb.append("\tin ").append(element).append(this.LS);
        }
        sb.append(this.LS);
        sb.append("Code stack:");
        return sb.toString();
    }
}

