/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRequirement {
    private String fieldName;
    private String role;
    private String roleHint = "default";
    private String fieldMappingType;

    public ComponentRequirement() {
    }

    public ComponentRequirement(String fieldName, String role) {
        this(fieldName, role, null);
    }

    public ComponentRequirement(String fieldName, String role, String roleHint) {
        this.fieldName = fieldName;
        this.role = role;
        if (roleHint != null) {
            this.roleHint = roleHint;
        }
    }

    public ComponentRequirement(String fieldName, Class<?> type) {
        this(fieldName, type.getName(), null);
    }

    public ComponentRequirement(String fieldName, Class<?> type, String roleHint) {
        this(fieldName, type.getName(), roleHint);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRoleHint() {
        return this.roleHint;
    }

    public void setRoleHint(String roleHint) {
        this.roleHint = roleHint == null || roleHint.trim().equals("") ? "default" : roleHint;
    }

    public String getFieldMappingType() {
        return this.fieldMappingType;
    }

    public void setFieldMappingType(String fieldType) {
        this.fieldMappingType = fieldType;
    }

    public String toString() {
        return "ComponentRequirement{role='" + this.getRole() + "'" + ", " + "roleHint='" + this.getRoleHint() + "', " + "fieldName='" + this.getFieldName() + "'" + "}";
    }

    public String getHumanReadableKey() {
        StringBuffer key = new StringBuffer();
        key.append("role: '").append(this.getRole()).append("'");
        if (this.getRoleHint() != null) {
            key.append(", role-hint: '").append(this.getRoleHint()).append("'. ");
        }
        if (this.getFieldName() != null) {
            key.append(", field name: '").append(this.getFieldName()).append("' ");
        }
        return key.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof ComponentRequirement) {
            String myId = this.role + ":" + this.roleHint;
            ComponentRequirement req = (ComponentRequirement)other;
            String otherId = req.role + ":" + req.roleHint;
            return myId.equals(otherId);
        }
        return false;
    }

    public int hashCode() {
        return (this.role + ":" + this.roleHint).hashCode();
    }
}

