/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.ComponentRegistry;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.CastUtils;
import org.codehaus.plexus.component.discovery.ComponentDiscoverer;
import org.codehaus.plexus.component.discovery.ComponentDiscovererManager;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryEvent;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryListener;
import org.codehaus.plexus.component.factory.ComponentFactoryManager;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentDescriptorListener;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.PlexusConfigurationMerger;
import org.codehaus.plexus.configuration.source.ConfigurationSource;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.container.initialization.ContainerInitializationContext;
import org.codehaus.plexus.container.initialization.ContainerInitializationPhase;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.context.DefaultContext;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.ReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPlexusContainer
extends AbstractLogEnabled
implements MutablePlexusContainer {
    protected static final String DEFAULT_CONTAINER_NAME = "default";
    protected static final String DEFAULT_REALM_NAME = "plexus.core";
    protected Context containerContext;
    protected PlexusConfiguration configuration;
    protected Reader configurationReader;
    protected ClassWorld classWorld;
    protected ClassRealm containerRealm;
    private ComponentRegistry componentRegistry;
    protected ComponentDiscovererManager componentDiscovererManager;
    protected ComponentFactoryManager componentFactoryManager;
    protected LoggerManager loggerManager;
    protected ConfigurationSource configurationSource;
    private ThreadLocal<ClassRealm> lookupRealm = new ThreadLocal();

    @Override
    public void addComponent(Object component, String role) throws ComponentRepositoryException {
        ClassRealm classRealm = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof ClassRealm) {
            classRealm = (ClassRealm)classLoader;
        }
        if (classRealm == null) {
            classRealm = this.getContainerRealm();
        }
        this.addComponent(component, this.getRoleClass(role), DEFAULT_CONTAINER_NAME, classRealm);
    }

    public <T> void addComponent(T component, Class<?> type, String roleHint, ClassRealm classRealm) throws ComponentRepositoryException {
        this.componentRegistry.addComponent(component, type, roleHint, classRealm);
    }

    @Override
    public ClassRealm setLookupRealm(ClassRealm realm) {
        ClassRealm oldRealm = this.lookupRealm.get();
        this.lookupRealm.set(realm);
        return oldRealm;
    }

    @Override
    public ClassRealm getLookupRealm() {
        return this.lookupRealm.get();
    }

    public DefaultPlexusContainer() throws PlexusContainerException {
        this.construct(new DefaultContainerConfiguration());
    }

    public DefaultPlexusContainer(ContainerConfiguration c) throws PlexusContainerException {
        this.construct(c);
    }

    @Override
    public ClassRealm createChildRealm(String id) {
        try {
            return this.containerRealm.createChildRealm(id);
        }
        catch (DuplicateRealmException e) {
            try {
                return this.classWorld.getRealm(id);
            }
            catch (NoSuchRealmException e1) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void construct(ContainerConfiguration c) throws PlexusContainerException {
        block19: {
            this.configurationSource = c.getConfigurationSource();
            this.classWorld = c.getClassWorld();
            if (this.classWorld == null) {
                this.classWorld = new ClassWorld(DEFAULT_REALM_NAME, Thread.currentThread().getContextClassLoader());
            }
            this.containerRealm = c.getRealm();
            if (this.containerRealm == null) {
                try {
                    this.containerRealm = this.classWorld.getRealm(DEFAULT_REALM_NAME);
                }
                catch (NoSuchRealmException e) {
                    this.containerRealm = (ClassRealm)this.classWorld.getRealms().iterator().next();
                    if (this.containerRealm != null) break block19;
                    System.err.println("No container realm! Expect errors.");
                    new Throwable().printStackTrace();
                }
            }
        }
        this.setLookupRealm(this.containerRealm);
        this.containerContext = c.getContext() != null ? new DefaultContext(c.getContext()) : new DefaultContext();
        InputStream in = null;
        if (c.getContainerConfiguration() != null) {
            in = this.toStream(c.getContainerConfiguration());
        }
        try {
            if (c.getContainerConfigurationURL() != null) {
                in = c.getContainerConfigurationURL().openStream();
            }
        }
        catch (IOException e) {
            throw new PlexusContainerException("Error reading configuration URL", e);
        }
        try {
            this.configurationReader = in == null ? null : ReaderFactory.newXmlReader((InputStream)in);
        }
        catch (IOException e) {
            throw new PlexusContainerException("Error reading configuration file", e);
        }
        try {
            this.initialize(c);
            this.start();
        }
        finally {
            IOUtil.close((Reader)this.configurationReader);
        }
        for (Class clazz : c.getComponentDiscoverers()) {
            try {
                ComponentDiscoverer cd = (ComponentDiscoverer)this.lookup(clazz);
                this.componentDiscovererManager.addComponentDiscoverer(cd);
            }
            catch (ComponentLookupException e) {}
        }
        for (Class clazz : c.getComponentDiscoveryListeners()) {
            try {
                ComponentDiscoveryListener cdl = (ComponentDiscoveryListener)this.lookup(clazz);
                this.componentDiscovererManager.registerComponentDiscoveryListener(cdl);
            }
            catch (ComponentLookupException e) {}
        }
    }

    private Class<?> getInterfaceClass(String role, String hint) {
        if (hint == null) {
            hint = DEFAULT_CONTAINER_NAME;
        }
        try {
            ClassRealm realm = this.getLookupRealm();
            if (realm != null) {
                return realm.loadClass(role);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader != null) {
                return loader.loadClass(role);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            ClassLoader loader;
            ComponentDescriptor<Object> cd = this.componentRegistry.getComponentDescriptor(Object.class, hint);
            if (cd != null && (loader = cd.getImplementationClass().getClassLoader()) != null) {
                return loader.loadClass(role);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Object.class;
    }

    private Class<?> getRoleClass(String role) {
        return this.getInterfaceClass(role, null);
    }

    private Class<?> getRoleClass(String role, String hint) {
        return this.getInterfaceClass(role, hint);
    }

    @Override
    public Object lookup(String role) throws ComponentLookupException {
        return this.componentRegistry.lookup(this.getRoleClass(role), DEFAULT_CONTAINER_NAME);
    }

    @Override
    public Object lookup(String role, String roleHint) throws ComponentLookupException {
        return this.componentRegistry.lookup(this.getRoleClass(role, roleHint), roleHint);
    }

    @Override
    public <T> T lookup(Class<T> type) throws ComponentLookupException {
        return this.componentRegistry.lookup(type, DEFAULT_CONTAINER_NAME);
    }

    @Override
    public <T> T lookup(Class<T> type, String roleHint) throws ComponentLookupException {
        return this.componentRegistry.lookup(type, roleHint);
    }

    @Override
    @Deprecated
    public <T> T lookup(Class<T> type, String role, String roleHint) throws ComponentLookupException {
        return this.componentRegistry.lookup(type, roleHint);
    }

    @Override
    public <T> T lookup(ComponentDescriptor<T> descriptor) throws ComponentLookupException {
        return this.componentRegistry.lookup(descriptor);
    }

    @Override
    public List<Object> lookupList(String role) throws ComponentLookupException {
        return CastUtils.cast(this.componentRegistry.lookupList(this.getRoleClass(role), null));
    }

    @Override
    public List<Object> lookupList(String role, List<String> roleHints) throws ComponentLookupException {
        return CastUtils.cast(this.componentRegistry.lookupList(this.getRoleClass(role), roleHints));
    }

    @Override
    public <T> List<T> lookupList(Class<T> type) throws ComponentLookupException {
        return this.componentRegistry.lookupList(type, null);
    }

    @Override
    public <T> List<T> lookupList(Class<T> type, List<String> roleHints) throws ComponentLookupException {
        return this.componentRegistry.lookupList(type, roleHints);
    }

    @Override
    public Map<String, Object> lookupMap(String role) throws ComponentLookupException {
        return CastUtils.cast(this.componentRegistry.lookupMap(this.getRoleClass(role), null));
    }

    @Override
    public Map<String, Object> lookupMap(String role, List<String> roleHints) throws ComponentLookupException {
        return CastUtils.cast(this.componentRegistry.lookupMap(this.getRoleClass(role), roleHints));
    }

    @Override
    public <T> Map<String, T> lookupMap(Class<T> type) throws ComponentLookupException {
        return this.componentRegistry.lookupMap(type, null);
    }

    @Override
    public <T> Map<String, T> lookupMap(Class<T> type, List<String> roleHints) throws ComponentLookupException {
        return this.componentRegistry.lookupMap(type, roleHints);
    }

    @Override
    public boolean hasComponent(String role) {
        return this.componentRegistry.getComponentDescriptor(this.getRoleClass(role), DEFAULT_CONTAINER_NAME) != null;
    }

    @Override
    public boolean hasComponent(String role, String roleHint) {
        return this.componentRegistry.getComponentDescriptor(this.getRoleClass(role), roleHint) != null;
    }

    @Override
    public boolean hasComponent(Class<?> type) {
        return this.componentRegistry.getComponentDescriptor(type, DEFAULT_CONTAINER_NAME) != null;
    }

    @Override
    public boolean hasComponent(Class<?> type, String roleHint) {
        return this.componentRegistry.getComponentDescriptor(type, roleHint) != null;
    }

    @Override
    public ComponentDescriptor<?> getComponentDescriptor(String role) {
        return this.componentRegistry.getComponentDescriptor(this.getRoleClass(role), DEFAULT_CONTAINER_NAME);
    }

    @Override
    public ComponentDescriptor<?> getComponentDescriptor(String role, String roleHint) {
        return this.componentRegistry.getComponentDescriptor(this.getRoleClass(role), roleHint);
    }

    @Override
    public <T> ComponentDescriptor<T> getComponentDescriptor(Class<T> type) {
        return this.componentRegistry.getComponentDescriptor(type, DEFAULT_CONTAINER_NAME);
    }

    @Override
    public <T> ComponentDescriptor<T> getComponentDescriptor(Class<T> type, String roleHint) {
        return this.componentRegistry.getComponentDescriptor(type, roleHint);
    }

    @Override
    public Map<String, ComponentDescriptor<?>> getComponentDescriptorMap(String role) {
        return CastUtils.cast(this.componentRegistry.getComponentDescriptorMap(this.getRoleClass(role)));
    }

    @Override
    @Deprecated
    public <T> Map<String, ComponentDescriptor<T>> getComponentDescriptorMap(Class<T> type, String role) {
        return this.componentRegistry.getComponentDescriptorMap(type);
    }

    @Override
    public List<ComponentDescriptor<?>> getComponentDescriptorList(String role) {
        return CastUtils.cast(this.componentRegistry.getComponentDescriptorList(this.getRoleClass(role)));
    }

    @Override
    public <T> List<ComponentDescriptor<T>> getComponentDescriptorList(Class<T> type) {
        return this.componentRegistry.getComponentDescriptorList(type);
    }

    @Override
    public void addComponentDescriptor(ComponentDescriptor<?> componentDescriptor) throws ComponentRepositoryException {
        if (componentDescriptor.getRealm() == null) {
            componentDescriptor.setRealm(this.containerRealm);
        }
        this.componentRegistry.addComponentDescriptor(componentDescriptor);
    }

    @Override
    public void release(Object component) throws ComponentLifecycleException {
        this.componentRegistry.release(component);
    }

    @Override
    public void releaseAll(Map<String, ?> components) throws ComponentLifecycleException {
        for (Object component : components.values()) {
            this.release(component);
        }
    }

    @Override
    public void releaseAll(List<?> components) throws ComponentLifecycleException {
        for (Object component : components) {
            this.release(component);
        }
    }

    protected void initialize(ContainerConfiguration containerConfiguration) throws PlexusContainerException {
        try {
            this.initializeConfiguration(containerConfiguration);
            this.initializePhases(containerConfiguration);
            this.containerContext.put("plexus", this);
            this.discoverComponents(this.getContainerRealm());
            PlexusConfiguration[] loadOnStartComponents = this.getConfiguration().getChild("load-on-start").getChildren("component");
            this.getLogger().debug("Found " + loadOnStartComponents.length + " components to load on start");
            ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
            try {
                for (PlexusConfiguration loadOnStartComponent : loadOnStartComponents) {
                    String role = loadOnStartComponent.getChild("role").getValue(null);
                    String roleHint = loadOnStartComponent.getChild("role-hint").getValue(null);
                    if (role == null) {
                        throw new PlexusContainerException("Missing 'role' element from load-on-start.");
                    }
                    if (roleHint == null) {
                        roleHint = DEFAULT_CONTAINER_NAME;
                    }
                    if (roleHint.equals("*")) {
                        this.getLogger().info("Loading on start all components with [role]: [" + role + "]");
                        this.lookupList(role);
                        continue;
                    }
                    this.getLogger().info("Loading on start [role,roleHint]: [" + role + "," + roleHint + "]");
                    this.lookup(role, roleHint);
                }
            }
            catch (ComponentLookupException e) {
                throw new PlexusContainerException("Error looking up load-on-start component.", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevCl);
            }
        }
        catch (ContextException e) {
            throw new PlexusContainerException("Error processing configuration", e);
        }
        catch (PlexusConfigurationException e) {
            throw new PlexusContainerException("Error configuring components", e);
        }
        catch (IOException e) {
            throw new PlexusContainerException("Error reading configuration file", e);
        }
        catch (ComponentRepositoryException e) {
            throw new PlexusContainerException("Error discoverying components.", e);
        }
    }

    protected void initializePhases(ContainerConfiguration containerConfiguration) throws PlexusContainerException {
        ContainerInitializationPhase[] initPhases = containerConfiguration.getInitializationPhases();
        ContainerInitializationContext initializationContext = new ContainerInitializationContext(this, this.classWorld, this.containerRealm, this.configuration, containerConfiguration);
        for (ContainerInitializationPhase phase : initPhases) {
            try {
                phase.execute(initializationContext);
            }
            catch (Exception e) {
                throw new PlexusContainerException("Error initializaing container in " + phase.getClass().getName() + ".", e);
            }
        }
    }

    protected void start() throws PlexusContainerException {
        this.configuration = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        try {
            this.componentRegistry.dispose();
            boolean needToDisposeRealm = false;
            try {
                this.containerRealm.setParentRealm(null);
                if (needToDisposeRealm) {
                    this.classWorld.disposeRealm(this.containerRealm.getId());
                }
            }
            catch (NoSuchRealmException e) {
                this.getLogger().debug("Failed to dispose realm.");
            }
        }
        finally {
            this.lookupRealm.set(null);
        }
    }

    @Override
    public void addContextValue(Object key, Object value) {
        this.containerContext.put(key, value);
    }

    @Override
    public ClassWorld getClassWorld() {
        return this.classWorld;
    }

    public void setClassWorld(ClassWorld classWorld) {
        this.classWorld = classWorld;
    }

    @Override
    public ClassRealm getContainerRealm() {
        return this.containerRealm;
    }

    public void setContainerRealm(ClassRealm containerRealm) {
        this.containerRealm = containerRealm;
    }

    @Override
    public Context getContext() {
        return this.containerContext;
    }

    @Override
    public void addComponentDescriptorListener(ComponentDescriptorListener<?> listener) {
        this.componentRegistry.addComponentDescriptorListener(listener);
    }

    @Override
    public void removeComponentDescriptorListener(ComponentDescriptorListener<?> listener) {
        this.componentRegistry.removeComponentDescriptorListener(listener);
    }

    protected void initializeConfiguration(ContainerConfiguration c) throws PlexusConfigurationException, ContextException, IOException {
        this.configuration = new XmlPlexusConfiguration("plexus");
        if (this.configurationReader != null) {
            PlexusConfiguration userConfiguration = PlexusTools.buildConfiguration("<User Specified Configuration Reader>", this.getInterpolationConfigurationReader(this.configurationReader));
            this.configuration = PlexusConfigurationMerger.merge(userConfiguration, this.configuration);
        }
    }

    protected Reader getInterpolationConfigurationReader(Reader reader) {
        return new InterpolationFilterReader(reader, (Map)new ContextMapAdapter(this.containerContext));
    }

    @Override
    public Logger getLogger() {
        return super.getLogger();
    }

    @Override
    public void registerComponentDiscoveryListener(ComponentDiscoveryListener listener) {
        this.componentDiscovererManager.registerComponentDiscoveryListener(listener);
    }

    @Override
    public void removeComponentDiscoveryListener(ComponentDiscoveryListener listener) {
        this.componentDiscovererManager.removeComponentDiscoveryListener(listener);
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    @Override
    public void setComponentRegistry(ComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    @Override
    public ComponentDiscovererManager getComponentDiscovererManager() {
        return this.componentDiscovererManager;
    }

    @Override
    public void setComponentDiscovererManager(ComponentDiscovererManager componentDiscovererManager) {
        this.componentDiscovererManager = componentDiscovererManager;
    }

    @Override
    public ComponentFactoryManager getComponentFactoryManager() {
        return this.componentFactoryManager;
    }

    @Override
    public void setComponentFactoryManager(ComponentFactoryManager componentFactoryManager) {
        this.componentFactoryManager = componentFactoryManager;
    }

    @Override
    public PlexusConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(PlexusConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public ClassRealm getComponentRealm(String realmId) {
        ClassRealm realm = null;
        try {
            realm = this.classWorld.getRealm(realmId);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            // empty catch block
        }
        if (realm == null) {
            realm = this.containerRealm;
        }
        return realm;
    }

    @Override
    public void removeComponentRealm(ClassRealm realm) throws PlexusContainerException {
        if (this.getContainerRealm().getId().equals(realm.getId())) {
            throw new IllegalArgumentException("Cannot remove container realm: " + realm.getId() + "\n(trying to remove container realm as if it were a component realm).");
        }
        this.componentRegistry.removeComponentRealm(realm);
        ClassRealm lookupRealm = this.getLookupRealm();
        if (lookupRealm != null && lookupRealm.getId().equals(realm.getId())) {
            this.setLookupRealm(this.getContainerRealm());
        }
    }

    private InputStream toStream(String resource) throws PlexusContainerException {
        InputStream is;
        if (resource == null) {
            return null;
        }
        String relativeResource = resource;
        if (resource.startsWith("/")) {
            relativeResource = resource.substring(1);
        }
        if ((is = this.getClass().getClassLoader().getResourceAsStream(relativeResource)) == null) {
            try {
                return new FileInputStream(resource);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return is;
    }

    @Override
    public ClassRealm getLookupRealm(Object component) {
        if (component.getClass().getClassLoader() instanceof ClassRealm) {
            return (ClassRealm)component.getClass().getClassLoader();
        }
        return this.getLookupRealm();
    }

    @Override
    public void setConfigurationSource(ConfigurationSource configurationSource) {
        this.configurationSource = configurationSource;
    }

    @Override
    public ConfigurationSource getConfigurationSource() {
        return this.configurationSource;
    }

    @Override
    public LoggerManager getLoggerManager() {
        return this.loggerManager;
    }

    @Override
    public void setLoggerManager(LoggerManager loggerManager) {
        this.loggerManager = loggerManager;
    }

    @Override
    public List<ComponentDescriptor<?>> discoverComponents(ClassRealm realm) throws PlexusConfigurationException, ComponentRepositoryException {
        ArrayList<ComponentSetDescriptor> componentSetDescriptors = new ArrayList<ComponentSetDescriptor>();
        ArrayList discoveredComponentDescriptors = new ArrayList();
        for (ComponentDiscoverer componentDiscoverer : this.getComponentDiscovererManager().getComponentDiscoverers()) {
            for (ComponentSetDescriptor componentSetDescriptor : componentDiscoverer.findComponents(this.getContext(), realm)) {
                componentSetDescriptors.add(componentSetDescriptor);
                for (ComponentDescriptor<?> componentDescriptor : componentSetDescriptor.getComponents()) {
                    this.addComponentDescriptor(componentDescriptor);
                    discoveredComponentDescriptors.add(componentDescriptor);
                }
                ComponentDiscoveryEvent event = new ComponentDiscoveryEvent(componentSetDescriptor);
                this.componentDiscovererManager.fireComponentDiscoveryEvent(event);
            }
        }
        return discoveredComponentDescriptors;
    }
}

