/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import com.google.common.base.ReferenceType;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.ReferenceMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.codehaus.plexus.ComponentRegistry;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.CastUtils;
import org.codehaus.plexus.component.ComponentIndex;
import org.codehaus.plexus.component.ComponentStack;
import org.codehaus.plexus.component.manager.ComponentManager;
import org.codehaus.plexus.component.manager.ComponentManagerFactory;
import org.codehaus.plexus.component.manager.StaticComponentManager;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentDescriptorListener;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.lifecycle.LifecycleHandler;
import org.codehaus.plexus.lifecycle.LifecycleHandlerManager;
import org.codehaus.plexus.lifecycle.UndefinedLifecycleHandlerException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.NullLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultComponentRegistry
implements ComponentRegistry {
    private static final String DEFAULT_INSTANTIATION_STRATEGY = "singleton";
    private final MutablePlexusContainer container;
    private final LifecycleHandlerManager lifecycleHandlerManager;
    private final Logger logger;
    private final AtomicBoolean disposed = new AtomicBoolean(false);
    private final ConcurrentMap<String, ComponentManagerFactory> componentManagerFactories = Maps.newConcurrentHashMap();
    private final ComponentIndex<ComponentManager<?>> index = new ComponentIndex();
    private final Map<ComponentDescriptor<?>, ComponentManager<?>> componentManagersByComponentDescriptor = new ReferenceMap(ReferenceType.WEAK, ReferenceType.WEAK);
    private final Map<Object, ComponentManager<?>> componentManagersByComponent = new ReferenceMap(ReferenceType.WEAK, ReferenceType.WEAK);
    private final ListMultimap<Pair<Class<?>, String>, ComponentDescriptorListener<?>> listeners = Multimaps.newArrayListMultimap();

    public DefaultComponentRegistry(MutablePlexusContainer container, LifecycleHandlerManager lifecycleHandlerManager) {
        this.container = container;
        this.lifecycleHandlerManager = lifecycleHandlerManager;
        Logger containerLogger = container.getLogger();
        this.logger = containerLogger != null ? containerLogger : new NullLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ArrayList managers;
        if (this.disposed.getAndSet(true)) {
            return;
        }
        ComponentIndex<ComponentManager<?>> componentIndex = this.index;
        synchronized (componentIndex) {
            managers = new ArrayList(this.index.clear());
            this.componentManagersByComponentDescriptor.clear();
            this.componentManagersByComponent.clear();
        }
        Collections.sort(managers, new Comparator<ComponentManager<?>>(){

            @Override
            public int compare(ComponentManager<?> left, ComponentManager<?> right) {
                if (left.getStartId() < right.getStartId()) {
                    return 1;
                }
                if (left.getStartId() == right.getStartId()) {
                    return 0;
                }
                return -1;
            }
        });
        for (ComponentManager componentManager : managers) {
            try {
                componentManager.dispose();
            }
            catch (Exception e) {
                this.logger.error("Error while disposing component manager. Continuing with the rest", e);
            }
            this.fireComponentDescriptorRemoved(componentManager.getComponentDescriptor());
        }
    }

    @Override
    public void registerComponentManagerFactory(ComponentManagerFactory componentManagerFactory) {
        if (this.disposed.get()) {
            throw new IllegalStateException("ComponentRegistry has been disposed");
        }
        this.componentManagerFactories.put(componentManagerFactory.getId(), componentManagerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addComponentDescriptor(ComponentDescriptor<T> componentDescriptor) throws ComponentRepositoryException {
        LifecycleHandler lifecycleHandler;
        ComponentManagerFactory componentManagerFactory;
        if (this.disposed.get()) {
            throw new ComponentRepositoryException("ComponentRegistry has been disposed", componentDescriptor);
        }
        this.verifyComponentDescriptor(componentDescriptor);
        String instantiationStrategy = componentDescriptor.getInstantiationStrategy();
        if (instantiationStrategy == null) {
            instantiationStrategy = DEFAULT_INSTANTIATION_STRATEGY;
        }
        if ((componentManagerFactory = (ComponentManagerFactory)this.componentManagerFactories.get(instantiationStrategy)) == null) {
            throw new ComponentRepositoryException("Unsupported instantiation strategy: " + instantiationStrategy, componentDescriptor);
        }
        try {
            lifecycleHandler = this.lifecycleHandlerManager.getLifecycleHandler(componentDescriptor.getLifecycleHandler());
        }
        catch (UndefinedLifecycleHandlerException e) {
            throw new ComponentRepositoryException("Undefined lifecycle handler: " + componentDescriptor.getLifecycleHandler(), componentDescriptor);
        }
        ComponentManager<T> componentManager = componentManagerFactory.createComponentManager(this.container, lifecycleHandler, componentDescriptor);
        ComponentIndex<ComponentManager<?>> componentIndex = this.index;
        synchronized (componentIndex) {
            this.index.add((ClassLoader)componentDescriptor.getRealm(), componentDescriptor.getRoleClass(), componentDescriptor.getRoleHint(), componentManager);
            this.componentManagersByComponentDescriptor.put(componentDescriptor, componentManager);
        }
        this.fireComponentDescriptorAdded(componentDescriptor);
    }

    @Override
    public <T> ComponentDescriptor<T> getComponentDescriptor(Class<T> type, String roleHint) {
        ComponentManager<?> componentManager = this.index.get(type, roleHint);
        if (componentManager == null) {
            return null;
        }
        return componentManager.getComponentDescriptor();
    }

    @Override
    public <T> Map<String, ComponentDescriptor<T>> getComponentDescriptorMap(Class<T> type) {
        Map componentManagers = CastUtils.cast(this.index.getAllAsMap(type));
        LinkedHashMap descriptors = new LinkedHashMap(componentManagers.size());
        for (Map.Entry entry : componentManagers.entrySet()) {
            descriptors.put(entry.getKey(), ((ComponentManager)entry.getValue()).getComponentDescriptor());
        }
        return Collections.unmodifiableMap(descriptors);
    }

    @Override
    public <T> List<ComponentDescriptor<T>> getComponentDescriptorList(Class<T> type) {
        List<ComponentManager> componentManagers = CastUtils.cast(this.index.getAll(type));
        ArrayList descriptors = new ArrayList(componentManagers.size());
        for (ComponentManager componentManager : componentManagers) {
            descriptors.add(componentManager.getComponentDescriptor());
        }
        return Collections.unmodifiableList(descriptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addComponent(T instance, Class<?> type, String roleHint, ClassRealm realm) throws ComponentRepositoryException {
        if (this.disposed.get()) {
            throw new ComponentRepositoryException("ComponentRegistry has been disposed", type, roleHint, realm);
        }
        StaticComponentManager<T> componentManager = new StaticComponentManager<T>(this.container, instance, type, roleHint, realm);
        ComponentDescriptor<T> descriptor = componentManager.getComponentDescriptor();
        this.verifyComponentDescriptor(descriptor);
        ComponentIndex<ComponentManager<?>> componentIndex = this.index;
        synchronized (componentIndex) {
            this.index.add((ClassLoader)descriptor.getRealm(), descriptor.getRoleClass(), descriptor.getRoleHint(), componentManager);
            this.componentManagersByComponentDescriptor.put(descriptor, componentManager);
        }
        this.fireComponentDescriptorAdded(descriptor);
    }

    @Override
    public <T> T lookup(Class<T> type, String roleHint) throws ComponentLookupException {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (roleHint == null) {
            roleHint = "default";
        }
        return this.getComponent(type, roleHint);
    }

    @Override
    public <T> T lookup(ComponentDescriptor<T> componentDescriptor) throws ComponentLookupException {
        ComponentManager<?> componentManager = this.componentManagersByComponentDescriptor.get(componentDescriptor);
        if (componentManager == null) {
            throw new ComponentLookupException("Component descriptor is not registered with PlexusContainer", componentDescriptor);
        }
        return (T)this.getComponent(componentManager);
    }

    @Override
    public <T> Map<String, T> lookupMap(Class<T> type, List<String> roleHints) throws ComponentLookupException {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        LinkedHashMap<String, T> components = new LinkedHashMap<String, T>();
        if (roleHints == null) {
            Map componentManagers = CastUtils.cast(this.index.getAllAsMap(type));
            for (Map.Entry entry : componentManagers.entrySet()) {
                String roleHint = (String)entry.getKey();
                ComponentManager componentManager = (ComponentManager)entry.getValue();
                T component = this.getComponent(componentManager);
                components.put(roleHint, component);
            }
        } else {
            for (String roleHint : roleHints) {
                T component = this.getComponent(type, roleHint);
                components.put(roleHint, component);
            }
        }
        return components;
    }

    @Override
    public <T> List<T> lookupList(Class<T> type, List<String> roleHints) throws ComponentLookupException {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        ArrayList<T> components = new ArrayList<T>();
        if (roleHints == null) {
            List<ComponentManager> componentManagers = CastUtils.cast(this.index.getAll(type));
            for (ComponentManager componentManager : componentManagers) {
                T component = this.getComponent(componentManager);
                components.add(component);
            }
        } else {
            for (String roleHint : roleHints) {
                T component = this.getComponent(type, roleHint);
                components.add(component);
            }
        }
        return components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addComponentDescriptorListener(ComponentDescriptorListener<T> listener) {
        Class<?> type = listener.getType();
        List<String> roleHints = listener.getRoleHints();
        DefaultComponentRegistry defaultComponentRegistry = this;
        synchronized (defaultComponentRegistry) {
            if (roleHints == null) {
                this.listeners.put(new Pair(type, null), listener);
            } else {
                for (String roleHint : roleHints) {
                    this.listeners.put(new Pair(type, roleHint), listener);
                }
            }
        }
        if (roleHints == null) {
            List<ComponentManager<?>> componentManagers = CastUtils.cast(this.index.getAll(type));
            for (ComponentManager<?> componentManager : componentManagers) {
                listener.componentDescriptorAdded(componentManager.getComponentDescriptor());
            }
        } else {
            for (String roleHint : roleHints) {
                ComponentManager<?> componentManager;
                componentManager = this.index.get(type, roleHint);
                if (componentManager == null) continue;
                listener.componentDescriptorAdded(componentManager.getComponentDescriptor());
            }
        }
    }

    @Override
    public synchronized <T> void removeComponentDescriptorListener(ComponentDescriptorListener<T> listener) {
        Class<T> type = listener.getType();
        List<String> roleHints = listener.getRoleHints();
        if (roleHints == null || roleHints.isEmpty()) {
            this.listeners.remove(new Pair<Class<T>, Object>(type, null), listener);
        } else {
            for (String roleHint : roleHints) {
                this.listeners.remove(new Pair<Class<T>, String>(type, roleHint), listener);
            }
        }
    }

    private synchronized <T> List<ComponentDescriptorListener<T>> getListeners(ComponentDescriptor<T> descriptor) {
        List allHintListeners = CastUtils.cast(this.listeners.get(new Pair<Class<T>, Object>(descriptor.getRoleClass(), null)));
        List specificHintListeners = CastUtils.cast(this.listeners.get(new Pair<Class<T>, String>(descriptor.getRoleClass(), descriptor.getRoleHint())));
        return Lists.newArrayList((Iterable)Iterables.concat(allHintListeners, specificHintListeners));
    }

    private <T> void fireComponentDescriptorAdded(ComponentDescriptor<T> componentDescriptor) {
        for (ComponentDescriptorListener<T> listener : this.getListeners(componentDescriptor)) {
            try {
                listener.componentDescriptorAdded(componentDescriptor);
            }
            catch (Throwable e) {
                this.logger.debug("ComponentDescriptorListener threw exception while processing " + componentDescriptor, e);
            }
        }
    }

    private <T> void fireComponentDescriptorRemoved(ComponentDescriptor<T> componentDescriptor) {
        for (ComponentDescriptorListener<T> listener : this.getListeners(componentDescriptor)) {
            try {
                listener.componentDescriptorRemoved(componentDescriptor);
            }
            catch (Throwable e) {
                this.logger.error("ComponentDescriptorListener threw exception while processing " + componentDescriptor, e);
            }
        }
    }

    @Override
    public void release(Object component) throws ComponentLifecycleException {
        if (component == null) {
            return;
        }
        ComponentManager<?> componentManager = this.componentManagersByComponent.get(component);
        if (componentManager == null) {
            return;
        }
        componentManager.release(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeComponentRealm(ClassRealm classRealm) throws PlexusContainerException {
        try {
            LinkedHashSet dispose;
            ComponentIndex<ComponentManager<?>> componentIndex = this.index;
            synchronized (componentIndex) {
                dispose = new LinkedHashSet(this.index.removeAll((ClassLoader)classRealm));
                for (ComponentManager componentManager : dispose) {
                    ComponentDescriptor descriptor = componentManager.getComponentDescriptor();
                    this.componentManagersByComponentDescriptor.remove(descriptor);
                    this.fireComponentDescriptorRemoved(descriptor);
                }
            }
            for (ComponentManager componentManager : dispose) {
                componentManager.dispose();
            }
        }
        catch (ComponentLifecycleException e) {
            throw new PlexusContainerException("Failed to dissociate component realm: " + classRealm.getId(), e);
        }
    }

    private <T> T getComponent(Class<T> type, String roleHint) throws ComponentLookupException {
        ComponentManager<?> componentManager = this.index.get(type, roleHint);
        if (componentManager == null) {
            throw new ComponentLookupException("Component descriptor cannot be found", type, roleHint);
        }
        return (T)this.getComponent(componentManager);
    }

    private <T> T getComponent(ComponentManager<T> componentManager) throws ComponentLookupException {
        ComponentDescriptor<T> descriptor = componentManager.getComponentDescriptor();
        ComponentStack.pushComponentStack(descriptor);
        try {
            T component = componentManager.getComponent();
            this.componentManagersByComponent.put(component, componentManager);
            T t = component;
            return t;
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            if (cause instanceof ComponentLookupException) {
                throw (ComponentLookupException)cause;
            }
            throw new ComponentLookupException(e.getMessage(), descriptor, cause);
        }
        finally {
            ComponentStack.popComponentStack();
        }
    }

    private <T> void verifyComponentDescriptor(ComponentDescriptor<T> descriptor) throws ComponentRepositoryException {
        Class<T> roleClass;
        ClassRealm classLoader = descriptor.getRealm();
        if (classLoader == null) {
            throw new ComponentRepositoryException("ComponentDescriptor realm is null", descriptor);
        }
        Class<T> implementationClass = descriptor.getImplementationClass();
        if (implementationClass.equals(Object.class)) {
            throw new ComponentRepositoryException("ComponentDescriptor implementation class could not be loaded", descriptor);
        }
        String role = descriptor.getRole();
        if (role == null) {
            throw new ComponentRepositoryException("ComponentDescriptor role is null", descriptor);
        }
        try {
            roleClass = classLoader.loadClass(role);
        }
        catch (ClassNotFoundException e) {
            throw new ComponentRepositoryException("ComponentDescriptor role class can not be loaded", descriptor);
        }
        if (!roleClass.isAssignableFrom(implementationClass)) {
            throw new ComponentRepositoryException("ComponentDescriptor implementation class does not implement the role class: implementationClass=" + implementationClass.getName() + " roleClass=" + roleClass.getName(), descriptor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pair<L, R> {
        private final L left;
        private final R right;

        public Pair(L left, R right) {
            this.left = left;
            this.right = right;
        }

        public L getLeft() {
            return this.left;
        }

        public R getRight() {
            return this.right;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair pair = (Pair)o;
            return (this.left == null ? pair.left == null : this.left.equals(pair.left)) && (this.right == null ? pair.right == null : this.right.equals(pair.right));
        }

        public int hashCode() {
            int result = this.left != null ? this.left.hashCode() : 0;
            result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("[").append(this.left).append(", ").append(this.right).append("]");
            return buf.toString();
        }
    }
}

