/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipFile;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.mojo.webstart.Pack200Tool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPack200Tool
implements Pack200Tool {
    public static final String PACK_GZ_EXTENSION = ".pack.gz";
    public static final String PACK_EXTENSION = ".pack";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pack(File source, File destination, Map<String, String> props, boolean gzip) throws IOException {
        ZipFile jar = null;
        OutputStream out = null;
        try {
            out = new FileOutputStream(destination);
            if (gzip) {
                out = new GZIPOutputStream(out){
                    {
                        this.def.setLevel(9);
                    }
                };
            }
            out = new BufferedOutputStream(out);
            jar = new JarFile(source, false);
            Pack200.Packer packer = Pack200.newPacker();
            packer.properties().putAll(props);
            packer.pack((JarFile)jar, out);
        }
        catch (Throwable throwable) {
            FileUtils.close(out);
            if (jar != null) {
                jar.close();
            }
            throw throwable;
        }
        FileUtils.close((OutputStream)out);
        if (jar != null) {
            jar.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repack(File source, File destination, Map<String, String> props) throws IOException {
        File tempFile = new File(source.toString() + ".tmp");
        try {
            this.pack(source, tempFile, props, false);
            this.unpack(tempFile, destination, props);
        }
        finally {
            this.deleteFile(tempFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpack(File source, File destination, Map<String, String> props) throws IOException {
        InputStream in = null;
        JarOutputStream out = null;
        try {
            in = new FileInputStream(source);
            if (DefaultPack200Tool.isGzipped(source)) {
                in = new GZIPInputStream(in);
            }
            in = new BufferedInputStream(in);
            out = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(destination)));
            Pack200.Unpacker unpacker = Pack200.newUnpacker();
            unpacker.properties().putAll(props);
            unpacker.unpack(in, out);
        }
        catch (Throwable throwable) {
            FileUtils.close(in);
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close((InputStream)in);
        FileUtils.close((OutputStream)out);
    }

    public void packJars(File directory, FileFilter jarFileFilter, boolean gzip, List<String> passFiles) throws IOException {
        File[] jarFiles;
        for (File jarFile1 : jarFiles = directory.listFiles(jarFileFilter)) {
            String extension = gzip ? PACK_GZ_EXTENSION : PACK_EXTENSION;
            File jarFile = jarFile1;
            File pack200Jar = new File(jarFile.getParentFile(), jarFile.getName() + extension);
            this.deleteFile(pack200Jar);
            HashMap<String, String> propMap = new HashMap<String, String>();
            propMap.put("pack.segment.limit", String.valueOf(-1));
            if (passFiles != null && !passFiles.isEmpty()) {
                for (int j = 0; j < passFiles.size(); ++j) {
                    propMap.put("pack.pass.file." + j, passFiles.get(j));
                }
            }
            this.pack(jarFile, pack200Jar, propMap, gzip);
            this.setLastModified(pack200Jar, jarFile.lastModified());
        }
    }

    public void unpackJars(File directory, FileFilter pack200FileFilter) throws IOException {
        File[] packFiles;
        for (File packFile : packFiles = directory.listFiles(pack200FileFilter)) {
            String packedJarPath = packFile.getAbsolutePath();
            int extensionLength = packedJarPath.endsWith(PACK_GZ_EXTENSION) ? 8 : 5;
            String jarFileName = packedJarPath.substring(0, packedJarPath.length() - extensionLength);
            File jarFile = new File(jarFileName);
            this.deleteFile(jarFile);
            this.unpack(packFile, jarFile, Collections.<String, String>emptyMap());
            this.setLastModified(jarFile, packFile.lastModified());
        }
    }

    private void deleteFile(File file) throws IOException {
        boolean delete;
        if (file.exists() && !(delete = file.delete())) {
            throw new IOException("Could not delete file " + file);
        }
    }

    private void setLastModified(File file, long modifi) throws IOException {
        boolean b = file.setLastModified(modifi);
        if (!b) {
            throw new IOException("Could not change last modifified on file: " + file);
        }
    }

    private static boolean isGzipped(File file) throws IOException {
        DataInputStream is = new DataInputStream(new FileInputStream(file));
        int i = is.readInt();
        is.close();
        return (i & 0xFFFFFF00) == 529205248;
    }
}

