/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.deployment.ant.pack200;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.jdesktop.deployment.ant.pack200.PackUtils;

public class Unpack200Task
extends Copy {
    public void setSrc(File src) {
        this.setFile(src);
    }

    public void setDest(File dest) {
        if (dest.isDirectory()) {
            this.setTodir(dest);
        } else {
            this.setTofile(dest);
        }
    }

    public void execute() {
        if (this.mapperElement == null) {
            this.createMapper();
            GlobPatternMapper mapper = new GlobPatternMapper();
            mapper.setFrom("*.jar");
            mapper.setTo("*.jar");
            this.mapperElement.add((FileNameMapper)mapper);
            mapper = new GlobPatternMapper();
            mapper.setFrom("*.jar.pack");
            mapper.setTo("*.jar");
            this.mapperElement.add((FileNameMapper)mapper);
            mapper = new GlobPatternMapper();
            mapper.setFrom("*.jar.pack.gz");
            mapper.setTo("*.jar");
            this.mapperElement.add((FileNameMapper)mapper);
        }
        super.execute();
    }

    protected void doFileOperations() {
        if (this.fileCopyMap.size() > 0) {
            this.log("Unpacking " + this.fileCopyMap.size() + " file" + (this.fileCopyMap.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            Enumeration e = this.fileCopyMap.keys();
            while (e.hasMoreElements()) {
                String fromFile = (String)e.nextElement();
                String[] toFiles = (String[])this.fileCopyMap.get(fromFile);
                for (int i = 0; i < toFiles.length; ++i) {
                    String toFile = toFiles[i];
                    if (fromFile.equals(toFile)) {
                        this.log("Skipping self-unpack of " + fromFile, this.verbosity);
                        continue;
                    }
                    try {
                        this.log("Unpacking " + fromFile + " to " + toFile, this.verbosity);
                        PackUtils.unpack(new File(fromFile), new File(toFile), Collections.emptyMap());
                        continue;
                    }
                    catch (IOException ioe) {
                        String msg = "Failed to unpack " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
                        File targetFile = new File(toFile);
                        if (targetFile.exists() && !targetFile.delete()) {
                            msg = msg + " and I couldn't delete the corrupt " + toFile;
                        }
                        throw new BuildException(msg, (Throwable)ioe, this.getLocation());
                    }
                }
            }
        }
    }
}

