/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.dependency.filenaming;

import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.codehaus.mojo.webstart.dependency.filenaming.AbstractDependencyFilenameStrategy;
import org.codehaus.mojo.webstart.dependency.filenaming.DependencyFilenameStrategy;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=DependencyFilenameStrategy.class, hint="full")
public class FullDependencyFilenameStrategy
extends AbstractDependencyFilenameStrategy
implements DependencyFilenameStrategy {
    public static final String ROLE_HINT = "full";

    @Override
    public String getDependencyFileBasename(Artifact artifact, Boolean outputJarVersion, Boolean useUniqueVersions) {
        String filename = artifact.getGroupId() + "-" + artifact.getArtifactId();
        if (outputJarVersion != null) {
            filename = outputJarVersion != false ? filename + "__V" : filename + "-";
            filename = useUniqueVersions != null && useUniqueVersions != false ? filename + artifact.getBaseVersion() : filename + artifact.getVersion();
        }
        if (StringUtils.isNotEmpty((String)artifact.getClassifier())) {
            filename = filename + "-" + artifact.getClassifier();
        }
        return filename;
    }
}

