/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.util;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.webstart.util.IOUtil;
import org.codehaus.mojo.webstart.util.JarUtil;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJarUtil
implements JarUtil {
    protected IOUtil ioUtil;
    protected UnArchiver jarUnarchiver;
    protected JarArchiver jarArchiver;

    @Override
    public void setManifestEntries(Map<String, String> entries) throws MojoExecutionException {
        Manifest newManifest = new Manifest();
        try {
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                newManifest.addConfiguredAttribute(new Manifest.Attribute(entry.getKey(), entry.getValue()));
            }
            JarArchiver.FilesetManifestConfig config = new JarArchiver.FilesetManifestConfig();
            config.setValue("mergewithoutmain");
            this.jarArchiver.setFilesetmanifest(config);
            this.jarArchiver.addConfiguredManifest(newManifest);
        }
        catch (ManifestException e) {
            throw new MojoExecutionException("Could not create manifest", (Exception)((Object)e));
        }
    }

    @Override
    public void updateManifestEntries(File jar) throws MojoExecutionException {
        File extractDirectory = new File(jar.getParent(), jar.getName() + "_updateManifestEntries");
        this.ioUtil.makeDirectoryIfNecessary(extractDirectory);
        this.jarUnarchiver.setSourceFile(jar);
        this.jarUnarchiver.setDestDirectory(extractDirectory);
        this.jarUnarchiver.extract();
        File updatedUnprocessedJarFile = new File(jar.getParent(), jar.getName() + "_updateManifestEntriesJar");
        this.jarArchiver.addDirectory(extractDirectory);
        this.jarArchiver.setDestFile(updatedUnprocessedJarFile);
        try {
            this.jarArchiver.createArchive();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create jar " + updatedUnprocessedJarFile, (Exception)e);
        }
        this.ioUtil.deleteFile(jar);
        this.ioUtil.renameTo(updatedUnprocessedJarFile, jar);
        this.ioUtil.removeDirectory(extractDirectory);
    }
}

