/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.maven.artifact.Artifact;
import org.codehaus.mojo.webstart.JarResource;
import org.codehaus.mojo.webstart.JnlpConfig;
import org.codehaus.mojo.webstart.util.ArtifactUtil;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class DefaultArtifactUtil
extends AbstractLogEnabled
implements ArtifactUtil {
    public boolean artifactContainsMainClass(Artifact artifact, JnlpConfig jnlp) throws MalformedURLException {
        boolean result = false;
        if (jnlp != null) {
            result = this.artifactContainsClass(artifact, jnlp.getMainClass());
        }
        return result;
    }

    public boolean artifactContainsMainClass(Artifact artifact, JarResource jnlp) throws MalformedURLException {
        boolean result = false;
        if (jnlp != null) {
            result = this.artifactContainsClass(artifact, jnlp.getMainClass());
        }
        return result;
    }

    protected boolean artifactContainsClass(Artifact artifact, String mainClass) throws MalformedURLException {
        boolean containsClass = true;
        URLClassLoader cl = new URLClassLoader(new URL[]{artifact.getFile().toURI().toURL()});
        Class<?> c = null;
        try {
            c = Class.forName(mainClass, false, cl);
        }
        catch (ClassNotFoundException e) {
            this.getLogger().debug("artifact " + artifact + " doesn't contain the main class: " + mainClass);
            containsClass = false;
        }
        catch (Throwable t) {
            this.getLogger().info("artifact " + artifact + " seems to contain the main class: " + mainClass + " but the jar doesn't seem to contain all dependencies " + t.getMessage());
        }
        if (c != null) {
            this.getLogger().debug("Checking if the loaded class contains a main method.");
            try {
                c.getMethod("main", String[].class);
            }
            catch (NoSuchMethodException e) {
                this.getLogger().warn("The specified main class (" + mainClass + ") doesn't seem to contain a main method... " + "Please check your configuration." + e.getMessage());
            }
            catch (NoClassDefFoundError e) {
                this.getLogger().warn("Something failed while checking if the main class contains the main() method. This is probably due to the limited classpath we have provided to the class loader. The specified main class (" + mainClass + ") found in the jar is *assumed* to contain a main method... " + e.getMessage());
            }
            catch (Throwable t) {
                this.getLogger().error("Unknown error: Couldn't check if the main class has a main method. The specified main class (" + mainClass + ") found in the jar is *assumed* to contain a main method...", t);
            }
        }
        return containsClass;
    }
}

