/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart;

import org.apache.maven.artifact.Artifact;

public class JarResource {
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String mainClass;
    private boolean outputJarVersion = true;
    private Artifact artifact;
    private String hrefValue;
    private boolean includeInJnlp = true;
    private String type;

    public JarResource() {
    }

    public JarResource(Artifact artifact) {
        this.setArtifact(artifact);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JarResource)) {
            return false;
        }
        JarResource other = (JarResource)obj;
        if (this.fieldsAreNotEqual(this.getGroupId(), other.getGroupId())) {
            return false;
        }
        if (this.fieldsAreNotEqual(this.getArtifactId(), other.getArtifactId())) {
            return false;
        }
        if (this.fieldsAreNotEqual(this.getVersion(), other.getVersion())) {
            return false;
        }
        if (this.fieldsAreNotEqual(this.getType(), other.getType())) {
            return false;
        }
        return !this.fieldsAreNotEqual(this.getClassifier(), other.getClassifier());
    }

    private boolean fieldsAreNotEqual(Object field1, Object field2) {
        if (field1 == null) {
            return field2 != null;
        }
        return !field1.equals(field2);
    }

    public int hashCode() {
        int offset = 17;
        int multiplier = 37;
        int result = 17;
        result += 37 * this.fieldHashCode(this.getGroupId());
        result += 37 * this.fieldHashCode(this.getArtifactId());
        result += 37 * this.fieldHashCode(this.getVersion());
        result += 37 * this.fieldHashCode(this.getType());
        return result += 37 * this.fieldHashCode(this.getClassifier());
    }

    private int fieldHashCode(Object field) {
        return field == null ? 0 : field.hashCode();
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    protected void setOutputJarVersion(boolean outputJarVersion) {
        this.outputJarVersion = outputJarVersion;
    }

    public boolean isOutputJarVersion() {
        return this.outputJarVersion;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException("artifact must not be null");
        }
        this.artifact = artifact;
        this.artifactId = artifact.getArtifactId();
        this.type = artifact.getType();
        this.classifier = artifact.getClassifier();
        this.groupId = artifact.getGroupId();
        this.version = artifact.getVersion();
    }

    protected void setHrefValue(String hrefValue) {
        this.hrefValue = hrefValue;
    }

    public String getHrefValue() {
        if (this.hrefValue == null && this.artifact != null) {
            return this.artifact.getFile().getName();
        }
        return this.hrefValue;
    }

    public boolean isIncludeInJnlp() {
        return this.includeInJnlp;
    }

    public String toString() {
        return "JarResource[ groupId='" + this.groupId + "', artifactId='" + this.artifactId + "', version='" + this.version + "', classifier='" + this.classifier + "', mainClass='" + this.mainClass + "', outputJarVersion='" + this.outputJarVersion + "', hrefValue='" + this.hrefValue + "' ]";
    }
}

