/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webminifier.rhino;

import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.webminifier.ExceptionState;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class RhinoExceptionReporter
extends ExceptionState
implements ErrorReporter {
    private final Log logger;

    public RhinoExceptionReporter(Log logger) {
        this.logger = logger;
    }

    private String constructMessage(String type, String message, String sourceName, int line, String lineSource, int lineOffset) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(type);
        if (message != null) {
            stringBuilder.append(": " + message);
        }
        if (sourceName != null && lineSource != null) {
            stringBuilder.append(" - " + sourceName);
            stringBuilder.append(":" + Integer.valueOf(line));
            stringBuilder.append(":" + Integer.valueOf(lineOffset));
            stringBuilder.append(":" + lineSource);
        }
        return stringBuilder.toString();
    }

    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.signalErrors();
        this.logger.error((CharSequence)this.constructMessage("Error", message, sourceName, line, lineSource, lineOffset));
    }

    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.signalErrors();
        this.logger.error((CharSequence)this.constructMessage("Runtime error", message, sourceName, line, lineSource, lineOffset));
        return new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
    }

    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.signalWarnings();
        this.logger.warn((CharSequence)this.constructMessage("Warning", message, sourceName, line, lineSource, lineOffset));
    }
}

