/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webminifier;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.codehaus.plexus.util.StringUtils;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentResourceReplacer {
    private final Document document;
    private final File documentParentFile;
    private final DOMParser parser = new DOMParser();

    public DocumentResourceReplacer(File htmlFile) throws SAXException, IOException {
        this.parser.parse(htmlFile.toString());
        this.documentParentFile = htmlFile.getParentFile();
        this.document = this.parser.getDocument();
    }

    public List<File> findJSResources() {
        ArrayList<File> jsResources = new ArrayList<File>();
        NodeList scriptNodes = this.document.getElementsByTagName("script");
        for (int i = 0; i < scriptNodes.getLength(); ++i) {
            String jsSrc;
            File scriptFile;
            Attr srcAttrNode;
            Node scriptNode = scriptNodes.item(i);
            NamedNodeMap scriptAttrNodes = scriptNode.getAttributes();
            if (scriptAttrNodes == null || (srcAttrNode = (Attr)scriptAttrNodes.getNamedItem("src")) == null || !(scriptFile = new File(this.documentParentFile, jsSrc = srcAttrNode.getValue())).isFile()) continue;
            jsResources.add(scriptFile);
        }
        return jsResources;
    }

    private String getHTMLSource() throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(this.document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        DocumentType doctype = this.document.getDoctype();
        if (doctype != null) {
            boolean docTypeSet = false;
            if (doctype.getPublicId() != null) {
                transformer.setOutputProperty("doctype-public", doctype.getPublicId());
                docTypeSet = true;
            }
            if (doctype.getSystemId() != null) {
                transformer.setOutputProperty("doctype-system", doctype.getSystemId());
                docTypeSet = false;
            }
            if (!docTypeSet) {
                writer.write("<!DOCTYPE html>");
            }
        }
        transformer.transform(source, result);
        return writer.toString();
    }

    public void replaceJSResources(File baseFolder, File documentDir, List<File> jsResources) {
        NodeList scriptNodes = this.document.getElementsByTagName("script");
        while (scriptNodes.getLength() > 0) {
            Node scriptNode = scriptNodes.item(0);
            scriptNode.getParentNode().removeChild(scriptNode);
        }
        URI baseFolderUri = baseFolder.toURI();
        URI documentBaseRelUri = baseFolderUri.relativize(documentDir.toURI());
        StringBuilder sb = new StringBuilder();
        int nestedFolderCount = StringUtils.countMatches((String)documentBaseRelUri.toString(), (String)"/");
        for (int i = 0; i < nestedFolderCount; ++i) {
            sb.append("../");
        }
        String docRelUri = sb.toString();
        NodeList headElements = this.document.getElementsByTagName("head");
        if (headElements.getLength() == 1) {
            Node headElement = headElements.item(0);
            for (File jsResource : jsResources) {
                URI jsResourceBaseRelUri = baseFolderUri.relativize(jsResource.toURI());
                Element jsElement = this.document.createElement("script");
                jsElement.setAttribute("type", "text/javascript");
                jsElement.setAttribute("src", docRelUri + jsResourceBaseRelUri.toString());
                headElement.appendChild(jsElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHTML(File htmlFile, String encoding) throws TransformerException, IOException {
        FileOutputStream fos = new FileOutputStream(htmlFile);
        try {
            OutputStreamWriter updatedHTMLWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fos), encoding);
            try {
                updatedHTMLWriter.write(this.getHTMLSource());
            }
            finally {
                updatedHTMLWriter.close();
            }
        }
        finally {
            ((OutputStream)fos).close();
        }
    }
}

