/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.codehaus.mojo.versions.model.IgnoreVersion;
import org.codehaus.mojo.versions.utils.ArtifactVersionService;
import org.eclipse.aether.version.Version;

public class IgnoreVersionHelper {
    public static final List<String> VALID_TYPES = Arrays.stream(IgnoreVersionType.values()).map(IgnoreVersionType::getType).collect(Collectors.toList());

    private IgnoreVersionHelper() {
    }

    public static boolean isValidType(IgnoreVersion ignoreVersion) {
        return IgnoreVersionType.forType(ignoreVersion.getType()).isPresent();
    }

    public static boolean isVersionIgnored(String v, IgnoreVersion ignoreVersion) {
        return IgnoreVersionType.forType(ignoreVersion.getType()).map(t -> t.getPredicate().apply(v, ignoreVersion)).orElseThrow(() -> new IllegalArgumentException("Invalid version type: " + ignoreVersion.getType()));
    }

    public static boolean isVersionIgnored(Version v, IgnoreVersion ignoreVersion) {
        return IgnoreVersionHelper.isVersionIgnored(v.toString(), ignoreVersion);
    }

    private static boolean isVersionIgnoredExact(String v, IgnoreVersion ignoreVersion) {
        return ignoreVersion.getVersion().equals(v);
    }

    private static boolean isVersionIgnoredRegex(String v, IgnoreVersion ignoreVersion) {
        return Pattern.compile(ignoreVersion.getVersion()).matcher(v).matches();
    }

    private static boolean isVersionIgnoredRange(String v, IgnoreVersion ignoreVersion) {
        try {
            ArtifactVersion aVersion = ArtifactVersionService.getArtifactVersion(v);
            VersionRange versionRange = VersionRange.createFromVersionSpec((String)ignoreVersion.getVersion());
            if (versionRange.hasRestrictions()) {
                return versionRange.containsVersion(aVersion);
            }
            return versionRange.getRecommendedVersion().equals((Object)aVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IgnoreVersionException(e);
        }
    }

    public static enum IgnoreVersionType {
        TYPE_EXACT("exact", (x$0, x$1) -> IgnoreVersionHelper.access$000(x$0, x$1)),
        TYPE_REGEX("regex", (x$0, x$1) -> IgnoreVersionHelper.access$100(x$0, x$1)),
        TYPE_RANGE("range", (x$0, x$1) -> IgnoreVersionHelper.access$200(x$0, x$1));

        private final String type;
        private final BiFunction<String, IgnoreVersion, Boolean> predicate;

        private IgnoreVersionType(String type, BiFunction<String, IgnoreVersion, Boolean> predicate) {
            this.type = type;
            this.predicate = predicate;
        }

        public String getType() {
            return this.type;
        }

        public BiFunction<String, IgnoreVersion, Boolean> getPredicate() {
            return this.predicate;
        }

        public static Optional<IgnoreVersionType> forType(String type) {
            for (IgnoreVersionType v : IgnoreVersionType.values()) {
                if (!v.getType().equals(type)) continue;
                return Optional.of(v);
            }
            return Optional.empty();
        }
    }

    static class IgnoreVersionException
    extends RuntimeException {
        IgnoreVersionException(Throwable cause) {
            super(cause);
        }
    }
}

