/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.ordering;

import java.math.BigInteger;
import java.util.StringTokenizer;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.codehaus.mojo.versions.ordering.AbstractVersionComparator;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.ordering.VersionComparators;

public class NumericVersionComparator
extends AbstractVersionComparator {
    private static final BigInteger BIG_INTEGER_ZERO = new BigInteger("0");
    private static final BigInteger BIG_INTEGER_ONE = new BigInteger("1");

    public int compare(ArtifactVersion o1, ArtifactVersion o2) {
        String v1 = o1.toString();
        String v2 = o2.toString();
        StringTokenizer tok1 = new StringTokenizer(v1, ".");
        StringTokenizer tok2 = new StringTokenizer(v2, ".");
        while (tok1.hasMoreTokens() && tok2.hasMoreTokens()) {
            int result;
            String q2;
            String q1;
            block16: {
                int index;
                String p1 = tok1.nextToken();
                String p2 = tok2.nextToken();
                q1 = null;
                q2 = null;
                if (p1.indexOf(45) >= 0) {
                    index = p1.indexOf(45);
                    q1 = p1.substring(index);
                    p1 = p1.substring(0, index);
                }
                if (p2.indexOf(45) >= 0) {
                    index = p2.indexOf(45);
                    q2 = p2.substring(index);
                    p2 = p2.substring(0, index);
                }
                try {
                    BigInteger n1 = new BigInteger(p1);
                    BigInteger n2 = new BigInteger(p2);
                    int result2 = n1.compareTo(n2);
                    if (result2 != 0) {
                        return result2;
                    }
                }
                catch (NumberFormatException e) {
                    int result3 = p1.compareTo(p2);
                    if (result3 == 0) break block16;
                    return result3;
                }
            }
            if (q1 != null && q2 != null && (result = q1.compareTo(q2)) != 0) {
                return result;
            }
            if (q1 != null) {
                return -1;
            }
            if (q2 == null) continue;
            return 1;
        }
        if (tok1.hasMoreTokens()) {
            BigInteger n2 = BIG_INTEGER_ZERO;
            while (tok1.hasMoreTokens()) {
                try {
                    BigInteger n1 = new BigInteger(tok1.nextToken());
                    int result = n1.compareTo(n2);
                    if (result == 0) continue;
                    return result;
                }
                catch (NumberFormatException e) {
                    return 1;
                }
            }
            return -1;
        }
        if (tok2.hasMoreTokens()) {
            BigInteger n1 = BIG_INTEGER_ZERO;
            while (tok2.hasMoreTokens()) {
                try {
                    BigInteger n2 = new BigInteger(tok2.nextToken());
                    int result = n1.compareTo(n2);
                    if (result == 0) continue;
                    return result;
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
            return 1;
        }
        return 0;
    }

    protected int innerGetSegmentCount(ArtifactVersion v) {
        String version = v.toString();
        StringTokenizer tok = new StringTokenizer(version, ".");
        return tok.countTokens();
    }

    protected ArtifactVersion innerIncrementSegment(ArtifactVersion v, int segment) {
        int segmentCount = this.innerGetSegmentCount(v);
        if (segment < 0 || segment > segmentCount) {
            throw new InvalidSegmentException(segment, segmentCount, v.toString());
        }
        String version = v.toString();
        StringBuilder buf = new StringBuilder();
        StringTokenizer tok = new StringTokenizer(version, ".");
        boolean first = true;
        while (segment >= 0 && tok.hasMoreTokens()) {
            if (first) {
                first = false;
            } else {
                buf.append('.');
            }
            String p = tok.nextToken();
            String q = null;
            if (p.indexOf(45) >= 0) {
                int index = p.indexOf(45);
                q = p.substring(index + 1);
                p = p.substring(0, index);
            }
            if (segment == 0) {
                try {
                    BigInteger n = new BigInteger(p);
                    p = n.add(BIG_INTEGER_ONE).toString();
                    q = null;
                }
                catch (NumberFormatException e) {
                    BigInteger n;
                    if ("alpha".equalsIgnoreCase(p)) {
                        if (q == null) {
                            p = "beta";
                        } else {
                            try {
                                n = new BigInteger(q);
                                q = n.add(BIG_INTEGER_ONE).toString();
                            }
                            catch (NumberFormatException e1) {
                                p = "beta";
                                q = null;
                            }
                        }
                    }
                    if ("beta".equalsIgnoreCase(p)) {
                        if (q == null) {
                            p = "milestone";
                        } else {
                            try {
                                n = new BigInteger(q);
                                q = n.add(BIG_INTEGER_ONE).toString();
                            }
                            catch (NumberFormatException e1) {
                                p = "milestone";
                                q = null;
                            }
                        }
                    }
                    if ("milestone".equalsIgnoreCase(p)) {
                        if (q == null) {
                            p = "rc";
                        } else {
                            try {
                                n = new BigInteger(q);
                                q = n.add(BIG_INTEGER_ONE).toString();
                            }
                            catch (NumberFormatException e1) {
                                p = "rc";
                                q = null;
                            }
                        }
                    }
                    if ("cr".equalsIgnoreCase(p) || "rc".equalsIgnoreCase(p)) {
                        if (q == null) {
                            p = "ga";
                        } else {
                            try {
                                n = new BigInteger(q);
                                q = n.add(BIG_INTEGER_ONE).toString();
                            }
                            catch (NumberFormatException e1) {
                                p = "ga";
                                q = null;
                            }
                        }
                    }
                    if ("ga".equalsIgnoreCase(p) || "final".equalsIgnoreCase(p)) {
                        if (q == null) {
                            p = "sp";
                            q = "1";
                        } else {
                            try {
                                n = new BigInteger(q);
                                q = n.add(BIG_INTEGER_ONE).toString();
                            }
                            catch (NumberFormatException e1) {
                                p = "sp";
                                q = "1";
                            }
                        }
                    }
                    p = VersionComparators.alphaNumIncrement(p);
                }
            }
            buf.append(p);
            if (q != null) {
                buf.append('-');
                buf.append(q);
            }
            --segment;
        }
        while (tok.hasMoreTokens()) {
            if (first) {
                first = false;
            } else {
                buf.append('.');
            }
            tok.nextToken();
            buf.append("0");
        }
        return new DefaultArtifactVersion(buf.toString());
    }
}

