/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.path.PathTranslator;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.codehaus.mojo.versions.PluginUpdatesDetails;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.PropertyVersionsBuilder;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.model.Rule;
import org.codehaus.mojo.versions.model.RuleSet;
import org.codehaus.mojo.versions.ordering.VersionComparator;
import org.codehaus.mojo.versions.ordering.VersionComparators;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.mojo.versions.utils.PluginComparator;
import org.codehaus.mojo.versions.utils.RegexUtils;
import org.codehaus.mojo.versions.utils.VersionsExpressionEvaluator;
import org.codehaus.mojo.versions.utils.WagonUtils;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.StringUtils;

public class DefaultVersionsHelper
implements VersionsHelper {
    private final RuleSet ruleSet;
    private final ArtifactMetadataSource artifactMetadataSource;
    private final ArtifactRepository localRepository;
    private final List remoteArtifactRepositories;
    private final List remotePluginRepositories;
    private final ArtifactFactory artifactFactory;
    private final Log log;
    private final PathTranslator pathTranslator;
    private final MavenSession mavenSession;

    public DefaultVersionsHelper(ArtifactFactory artifactFactory, ArtifactMetadataSource artifactMetadataSource, List remoteArtifactRepositories, List remotePluginRepositories, ArtifactRepository localRepository, WagonManager wagonManager, Settings settings, String serverId, String rulesUri, Log log, MavenSession mavenSession, PathTranslator pathTranslator) throws MojoExecutionException {
        this.artifactFactory = artifactFactory;
        this.mavenSession = mavenSession;
        this.pathTranslator = pathTranslator;
        this.ruleSet = DefaultVersionsHelper.loadRuleSet(serverId, settings, wagonManager, rulesUri, log);
        this.artifactMetadataSource = artifactMetadataSource;
        this.localRepository = localRepository;
        this.remoteArtifactRepositories = remoteArtifactRepositories;
        this.remotePluginRepositories = remotePluginRepositories;
        this.log = log;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public Log getLog() {
        return this.log;
    }

    public ArtifactVersions lookupArtifactVersions(Artifact artifact, boolean usePluginRepositories) throws ArtifactMetadataRetrievalException {
        List remoteRepositories = usePluginRepositories ? this.remotePluginRepositories : this.remoteArtifactRepositories;
        return new ArtifactVersions(artifact, this.artifactMetadataSource.retrieveAvailableVersions(artifact, this.localRepository, remoteRepositories), this.getVersionComparator(artifact));
    }

    public VersionComparator getVersionComparator(Artifact artifact) {
        return this.getVersionComparator(artifact.getGroupId(), artifact.getArtifactId());
    }

    public VersionComparator getVersionComparator(String groupId, String artifactId) {
        List rules = this.ruleSet.getRules();
        String comparisonMethod = this.ruleSet.getComparisonMethod();
        int bestGroupIdScore = Integer.MAX_VALUE;
        int bestArtifactIdScore = Integer.MAX_VALUE;
        boolean exactGroupId = false;
        boolean exactArtifactId = false;
        Iterator i = rules.iterator();
        while (i.hasNext()) {
            int artifactIdScore;
            boolean exactMatch;
            boolean match;
            Rule rule = (Rule)i.next();
            int groupIdScore = RegexUtils.getWildcardScore(rule.getGroupId());
            if (groupIdScore > bestGroupIdScore || !(match = (exactMatch = DefaultVersionsHelper.exactMatch(rule.getGroupId(), groupId)) || DefaultVersionsHelper.match(rule.getGroupId(), groupId)) || exactGroupId && !exactMatch) continue;
            if (bestGroupIdScore > groupIdScore) {
                bestArtifactIdScore = Integer.MAX_VALUE;
                exactArtifactId = false;
            }
            bestGroupIdScore = groupIdScore;
            if (exactMatch && !exactGroupId) {
                exactGroupId = true;
                bestArtifactIdScore = Integer.MAX_VALUE;
                exactArtifactId = false;
            }
            if ((artifactIdScore = RegexUtils.getWildcardScore(rule.getArtifactId())) > bestArtifactIdScore || !(match = (exactMatch = DefaultVersionsHelper.exactMatch(rule.getArtifactId(), artifactId)) || DefaultVersionsHelper.match(rule.getArtifactId(), artifactId)) || exactArtifactId && !exactMatch) continue;
            bestArtifactIdScore = artifactIdScore;
            if (exactMatch && !exactArtifactId) {
                exactArtifactId = true;
            }
            comparisonMethod = rule.getComparisonMethod();
        }
        return VersionComparators.getVersionComparator(comparisonMethod);
    }

    /*
     * Exception decompiling
     */
    private static RuleSet getRuleSet(Wagon wagon, String remoteURI) throws IOException, AuthorizationException, TransferFailedException, ResourceDoesNotExistException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static boolean exactMatch(String wildcardRule, String value) {
        Pattern p = Pattern.compile(RegexUtils.convertWildcardsToRegex(wildcardRule, true));
        return p.matcher(value).matches();
    }

    static boolean match(String wildcardRule, String value) {
        Pattern p = Pattern.compile(RegexUtils.convertWildcardsToRegex(wildcardRule, false));
        return p.matcher(value).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RuleSet loadRuleSet(String serverId, Settings settings, WagonManager wagonManager, String rulesUri, Log logger) throws MojoExecutionException {
        RuleSet ruleSet = new RuleSet();
        if (rulesUri != null && rulesUri.trim().length() != 0) {
            try {
                String fileUri;
                String baseUri;
                int split = rulesUri.lastIndexOf(47);
                if (split != -1) {
                    baseUri = rulesUri.substring(0, split) + '/';
                    fileUri = split + 1 < rulesUri.length() ? rulesUri.substring(split + 1) : "";
                } else {
                    baseUri = rulesUri;
                    fileUri = "";
                }
                try {
                    Wagon wagon = WagonUtils.createWagon(serverId, baseUri, wagonManager, settings, logger);
                    try {
                        logger.debug((CharSequence)("Trying to load ruleset from file \"" + fileUri + "\" in " + baseUri));
                        ruleSet.setRules(DefaultVersionsHelper.getRuleSet(wagon, fileUri).getRules());
                        logger.debug((CharSequence)"Rule set loaded");
                    }
                    finally {
                        if (wagon != null) {
                            try {
                                wagon.disconnect();
                            }
                            catch (ConnectionException e) {
                                logger.warn((CharSequence)"Could not disconnect wagon!", (Throwable)e);
                            }
                        }
                    }
                }
                catch (TransferFailedException e) {
                    throw new MojoExecutionException("Could not transfer rules from " + rulesUri, (Exception)((Object)e));
                }
                catch (AuthorizationException e) {
                    throw new MojoExecutionException("Authorization failure trying to load rules from " + rulesUri, (Exception)((Object)e));
                }
                catch (ResourceDoesNotExistException e) {
                    throw new MojoExecutionException("Could not load specified rules from " + rulesUri, (Exception)((Object)e));
                }
                catch (AuthenticationException e) {
                    throw new MojoExecutionException("Authentication failure trying to load rules from " + rulesUri, (Exception)((Object)e));
                }
                catch (UnsupportedProtocolException e) {
                    throw new MojoExecutionException("Unsupported protocol for " + rulesUri, (Exception)((Object)e));
                }
                catch (ConnectionException e) {
                    throw new MojoExecutionException("Could not establish connection to " + rulesUri, (Exception)((Object)e));
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not load specified rules from " + rulesUri, (Exception)e);
            }
        }
        return ruleSet;
    }

    public Artifact createPluginArtifact(String groupId, String artifactId, VersionRange versionRange) {
        return this.artifactFactory.createPluginArtifact(groupId, artifactId, versionRange);
    }

    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, boolean optional) {
        return this.artifactFactory.createDependencyArtifact(groupId, artifactId, versionRange, type, classifier, scope, optional);
    }

    public Artifact createDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope) {
        return this.artifactFactory.createDependencyArtifact(groupId, artifactId, versionRange, type, classifier, scope);
    }

    public Artifact createDependencyArtifact(Dependency dependency) throws InvalidVersionSpecificationException {
        return this.createDependencyArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion() == null ? VersionRange.createFromVersionSpec((String)"[0,]") : VersionRange.createFromVersionSpec((String)dependency.getVersion()), dependency.getType(), dependency.getClassifier(), dependency.getScope(), dependency.isOptional());
    }

    public Set extractArtifacts(Collection mavenProjects) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        Iterator i = mavenProjects.iterator();
        while (i.hasNext()) {
            Object next = i.next();
            if (!(next instanceof MavenProject)) continue;
            MavenProject project = (MavenProject)next;
            result.add(project.getArtifact());
        }
        return result;
    }

    public ArtifactVersion createArtifactVersion(String version) {
        return new DefaultArtifactVersion(version);
    }

    public ArtifactVersions lookupArtifactUpdates(Artifact artifact, Boolean allowSnapshots, boolean usePluginRepositories) throws ArtifactMetadataRetrievalException {
        ArtifactVersions artifactVersions = this.lookupArtifactVersions(artifact, usePluginRepositories);
        artifactVersions.setIncludeSnapshots(Boolean.TRUE.equals(allowSnapshots));
        return artifactVersions;
    }

    public Map lookupDependenciesUpdates(Set dependencies, boolean usePluginRepositories) throws ArtifactMetadataRetrievalException, InvalidVersionSpecificationException {
        TreeMap<Dependency, ArtifactVersions> dependencyUpdates = new TreeMap<Dependency, ArtifactVersions>(new DependencyComparator());
        Iterator i = dependencies.iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            ArtifactVersions details = this.lookupDependencyUpdates(dependency, usePluginRepositories);
            dependencyUpdates.put(dependency, details);
        }
        return dependencyUpdates;
    }

    public ArtifactVersions lookupDependencyUpdates(Dependency dependency, boolean usePluginRepositories) throws ArtifactMetadataRetrievalException, InvalidVersionSpecificationException {
        this.getLog().debug((CharSequence)("Checking " + ArtifactUtils.versionlessKey((String)dependency.getGroupId(), (String)dependency.getArtifactId()) + " for updates newer than " + dependency.getVersion()));
        VersionRange versionRange = VersionRange.createFromVersionSpec((String)dependency.getVersion());
        return this.lookupArtifactVersions(this.createDependencyArtifact(dependency.getGroupId(), dependency.getArtifactId(), versionRange, dependency.getType(), dependency.getClassifier(), dependency.getScope()), usePluginRepositories);
    }

    public Map lookupPluginsUpdates(Set plugins, Boolean allowSnapshots) throws ArtifactMetadataRetrievalException, InvalidVersionSpecificationException {
        TreeMap<Plugin, PluginUpdatesDetails> pluginUpdates = new TreeMap<Plugin, PluginUpdatesDetails>(new PluginComparator());
        Iterator i = plugins.iterator();
        while (i.hasNext()) {
            Plugin plugin = (Plugin)i.next();
            PluginUpdatesDetails details = this.lookupPluginUpdates(plugin, allowSnapshots);
            pluginUpdates.put(plugin, details);
        }
        return pluginUpdates;
    }

    public PluginUpdatesDetails lookupPluginUpdates(Plugin plugin, Boolean allowSnapshots) throws ArtifactMetadataRetrievalException, InvalidVersionSpecificationException {
        this.getLog().debug((CharSequence)("Checking " + ArtifactUtils.versionlessKey((String)plugin.getGroupId(), (String)plugin.getArtifactId()) + " for updates newer than " + plugin.getVersion()));
        VersionRange versionRange = VersionRange.createFromVersion((String)plugin.getVersion());
        boolean includeSnapshots = Boolean.TRUE.equals(allowSnapshots);
        ArtifactVersions pluginArtifactVersions = this.lookupArtifactVersions(this.createPluginArtifact(plugin.getGroupId(), plugin.getArtifactId(), versionRange), true);
        TreeSet pluginDependencies = new TreeSet(new DependencyComparator());
        if (plugin.getDependencies() != null) {
            pluginDependencies.addAll(plugin.getDependencies());
        }
        Map pluginDependencyDetails = this.lookupDependenciesUpdates(pluginDependencies, false);
        return new PluginUpdatesDetails(pluginArtifactVersions, pluginDependencyDetails, includeSnapshots);
    }

    public ExpressionEvaluator getExpressionEvaluator(MavenProject project) {
        return new VersionsExpressionEvaluator(this.mavenSession, this.pathTranslator, project);
    }

    public Map getVersionPropertiesMap(MavenProject project, Property[] propertyDefinitions, String includeProperties, String excludeProperties, boolean autoLinkItems) throws MojoExecutionException {
        HashMap<String, Property> properties = new HashMap<String, Property>();
        if (propertyDefinitions != null) {
            for (int i = 0; i < propertyDefinitions.length; ++i) {
                properties.put(propertyDefinitions[i].getName(), propertyDefinitions[i]);
            }
        }
        HashMap<String, PropertyVersionsBuilder> builders = new HashMap<String, PropertyVersionsBuilder>();
        if (autoLinkItems) {
            PropertyVersionsBuilder[] propertyVersionsBuilders;
            try {
                propertyVersionsBuilders = PomHelper.getPropertyVersionsBuilders(this, project);
            }
            catch (ExpressionEvaluationException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            for (int i = 0; i < propertyVersionsBuilders.length; ++i) {
                String name = propertyVersionsBuilders[i].getName();
                builders.put(name, propertyVersionsBuilders[i]);
                if (properties.containsKey(name)) continue;
                Property value = new Property(name);
                this.getLog().debug((CharSequence)("Property ${" + name + "}: Adding inferred version range of " + propertyVersionsBuilders[i].getVersionRange()));
                value.setVersion(propertyVersionsBuilders[i].getVersionRange());
                properties.put(name, value);
            }
        }
        this.getLog().debug((CharSequence)"Searching for properties associated with builders");
        Iterator i = properties.values().iterator();
        while (i.hasNext()) {
            Property property = (Property)i.next();
            if (includeProperties != null && includeProperties.indexOf(property.getName()) < 0) {
                this.getLog().debug((CharSequence)("Skipping property ${" + property.getName() + "}"));
                i.remove();
            }
            if (excludeProperties == null || excludeProperties.indexOf(property.getName()) < 0) continue;
            this.getLog().debug((CharSequence)("Ignoring property ${" + property.getName() + "}"));
            i.remove();
        }
        i = properties.values().iterator();
        LinkedHashMap<Property, PropertyVersions> propertyVersions = new LinkedHashMap<Property, PropertyVersions>(properties.size());
        while (i.hasNext()) {
            Dependency[] dependencies;
            Property property = (Property)i.next();
            this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}"));
            PropertyVersionsBuilder builder = (PropertyVersionsBuilder)builders.get(property.getName());
            if (builder == null || !builder.isAssociated()) {
                this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Looks like this property is not " + "associated with any dependency..."));
                builder = new PropertyVersionsBuilder(null, property.getName(), this);
            }
            if (!property.isAutoLinkDependencies()) {
                this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Removing any autoLinkDependencies"));
                builder.clearAssociations();
            }
            if ((dependencies = property.getDependencies()) != null) {
                for (int j = 0; j < dependencies.length; ++j) {
                    try {
                        this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Adding association to " + dependencies[j]));
                        builder.addAssociation(this.createDependencyArtifact(dependencies[j]), false);
                        continue;
                    }
                    catch (InvalidVersionSpecificationException e) {
                        throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                    }
                }
            }
            try {
                PropertyVersions versions = builder.newPropertyVersions();
                if (property.isAutoLinkDependencies() && StringUtils.isEmpty((String)property.getVersion()) && !StringUtils.isEmpty((String)builder.getVersionRange())) {
                    this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Adding inferred version range of " + builder.getVersionRange()));
                    property.setVersion(builder.getVersionRange());
                }
                versions.setCurrentVersion(project.getProperties().getProperty(property.getName()));
                propertyVersions.put(property, versions);
            }
            catch (ArtifactMetadataRetrievalException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return propertyVersions;
    }
}

