/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.unix;

import org.codehaus.plexus.util.StringUtils;

public final class PackageVersion {
    public final String version;
    public final String timestamp;
    public final boolean snapshot;
    public final int revision;

    private PackageVersion(String version, String timestamp, boolean snapshot, int revision) {
        this.version = version;
        this.timestamp = timestamp;
        this.snapshot = snapshot;
        this.revision = revision;
    }

    static PackageVersion fromMavenProject(String version, String timestamp, boolean snapshot) {
        if (snapshot && timestamp == null) {
            throw new RuntimeException("The timestamp can't be null when creating a snapshot version");
        }
        version = PackageVersion.stripSnapshot(snapshot, version);
        int maintainerRevision = -1;
        int index = version.lastIndexOf(45);
        if (index != -1) {
            try {
                maintainerRevision = Integer.parseInt(version.substring(index + 1));
                version = version.substring(0, index);
            }
            catch (NumberFormatException e) {
                maintainerRevision = -1;
            }
        }
        return new PackageVersion(version, timestamp, snapshot, maintainerRevision);
    }

    private static String stripSnapshot(boolean snapshot, String version) {
        if (!snapshot) {
            return version;
        }
        if (!version.endsWith("-SNAPSHOT")) {
            throw new RuntimeException("Expected the version string to end with '-SNAPSHOT' when the version is a snapshot version.");
        }
        return version.substring(0, version.length() - 9);
    }

    public static PackageVersion create(String version, String timestamp, boolean snapshot, String configuredVersion, Integer configuredRevision) {
        if (version == null) {
            throw new RuntimeException("version == null");
        }
        if (timestamp == null) {
            throw new RuntimeException("timestamp == null");
        }
        if (configuredRevision != null) {
            return new PackageVersion(PackageVersion.stripSnapshot(snapshot, version), timestamp, snapshot, configuredRevision);
        }
        PackageVersion v = PackageVersion.fromMavenProject(version, timestamp, snapshot);
        version = StringUtils.isNotEmpty((String)configuredVersion) ? configuredVersion : v.version;
        switch (v.revision) {
            case -1: 
            case 0: {
                return new PackageVersion(version, v.timestamp, v.snapshot, 1);
            }
        }
        return new PackageVersion(version, v.timestamp, v.snapshot, v.revision);
    }

    public String getMavenVersion() {
        String v = this.version + "-" + this.revision;
        if (this.snapshot) {
            return v + "-SNAPSHOT";
        }
        return v;
    }
}

