/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.settings;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.io.download.DownloadFailedException;
import org.apache.maven.shared.io.download.DownloadManager;
import org.apache.maven.shared.io.logging.DefaultMessageHolder;
import org.apache.maven.shared.io.logging.MessageHolder;
import org.codehaus.mojo.settings.Interpolator;
import org.codehaus.mojo.settings.PrompterValueSource;
import org.codehaus.mojo.settings.SplitterValueSource;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.interpolation.MapBasedValueSource;

public class RSyncSettingsMojo
extends AbstractMojo {
    public static final String SETTINGS_TYPE = ".settings";
    private String url;
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private boolean doBackup;
    private List remoteRepositories;
    private ArtifactRepository localRepository;
    private ArtifactResolver resolver;
    private ArtifactFactory factory;
    private DownloadManager downloadManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File newSettings = null;
        newSettings = this.getSettingsFromUrl();
        if (newSettings == null) {
            this.getLog().info((CharSequence)"Could not get settings template from URL. Attempting artifact resolution...");
            newSettings = this.getSettingsFromRepository();
        }
        if (newSettings == null) {
            throw new MojoFailureException((Object)this, "Cannot synchronize settings.", "Failed to retrieve new settings file. Cannot synchronize.");
        }
        String userHome = System.getProperty("user.home");
        File settingsFile = new File(userHome, ".m2/settings.xml");
        if (settingsFile.exists()) {
            this.getLog().info((CharSequence)("ATTENTION: The Maven settings at: " + settingsFile.getAbsolutePath() + " is about to be replaced. Pausing 3 seconds..."));
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                this.getLog().warn((CharSequence)"3 second pause was interrupted! Continuing settings synchronization...");
            }
            if (this.doBackup) {
                File backupSettingsFile = new File(settingsFile.getAbsolutePath() + ".sync-backup");
                this.getLog().info((CharSequence)("Your original settings.xml will be backed up to: " + backupSettingsFile.getPath()));
                if (backupSettingsFile.exists()) {
                    backupSettingsFile.delete();
                }
                if (!settingsFile.renameTo(backupSettingsFile)) {
                    throw new MojoFailureException((Object)this, "Cannot backup old settings.", "Failed to backup old settings file. Cannot synchronize.");
                }
            }
        }
        try {
            PrompterValueSource pvs = new PrompterValueSource();
            MapBasedValueSource mbvs = new MapBasedValueSource((Map)System.getProperties());
            ArrayList<List<Object>> segments = new ArrayList<List<Object>>();
            segments.add(Collections.singletonList(mbvs));
            segments.add(Collections.singletonList(pvs));
            SplitterValueSource svs = new SplitterValueSource(":", segments);
            Interpolator interpolator = new Interpolator(Collections.singletonList(svs));
            interpolator.interpolate(newSettings, settingsFile, "prompt");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to transfer new settings to user's settings file. Reason: " + e.getMessage(), (Exception)e);
        }
    }

    private File getSettingsFromRepository() {
        File result = null;
        if (this.checkForArtifactViability()) {
            Artifact artifact = null;
            artifact = StringUtils.isNotEmpty((String)this.classifier) ? this.factory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, SETTINGS_TYPE, this.classifier) : this.factory.createArtifact(this.groupId, this.artifactId, this.version, "runtime", SETTINGS_TYPE);
            try {
                this.getLog().info((CharSequence)("Attempting to retrieve settings template from artifact: " + artifact.getId()));
                this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
                this.getLog().info((CharSequence)("Settings template artifact was resolved to: " + artifact.getFile()));
                result = artifact.getFile();
            }
            catch (ArtifactResolutionException e) {
                this.getLog().error((CharSequence)("Failed to resolve settings from artifact: " + e.getArtifactId()));
                this.getLog().debug((CharSequence)("Failed to resolve settings from artifact: " + e.getArtifactId()), (Throwable)e);
            }
            catch (ArtifactNotFoundException e) {
                this.getLog().error((CharSequence)("Failed to resolve settings from artifact: " + e.getArtifactId()));
                this.getLog().debug((CharSequence)("Failed to resolve settings from artifact: " + e.getArtifactId()), (Throwable)e);
            }
        }
        return result;
    }

    private File getSettingsFromUrl() {
        File result = null;
        if (StringUtils.isNotEmpty((String)this.url)) {
            try {
                this.getLog().info((CharSequence)("Attempting to retrieve settings template from: " + this.url));
                DefaultMessageHolder mh = new DefaultMessageHolder();
                result = this.downloadManager.download(this.url, (MessageHolder)mh);
                if (!mh.isEmpty()) {
                    this.getLog().debug((CharSequence)("DownloadManager gave the following debug output:\n\n" + mh.render()));
                }
            }
            catch (DownloadFailedException e) {
                this.getLog().error((CharSequence)("Failed to download settings from URL: " + this.url));
                this.getLog().debug((CharSequence)("Failed to download settings from URL: " + this.url), (Throwable)e);
            }
        }
        return result;
    }

    private boolean checkForArtifactViability() {
        boolean groupIdViable = StringUtils.isNotEmpty((String)this.groupId);
        boolean artifactIdViable = StringUtils.isNotEmpty((String)this.artifactId);
        boolean versionViable = StringUtils.isNotEmpty((String)this.version);
        return groupIdViable && artifactIdViable && versionViable;
    }
}

