/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.scmchangelog.scm.svn;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.codehaus.mojo.scmchangelog.AbstractBufferedConsumer;
import org.codehaus.mojo.scmchangelog.changelog.log.ScmLogEntry;
import org.codehaus.mojo.scmchangelog.changelog.log.grammar.GrammarEnum;
import org.codehaus.mojo.scmchangelog.scm.svn.xml.LogDocument;
import org.codehaus.mojo.scmchangelog.scm.svn.xml.LogentryDocument;

public class SvnChangeLogConsumer
extends AbstractBufferedConsumer {
    private List elements = new ArrayList();
    private GrammarEnum grammar;

    public SvnChangeLogConsumer(GrammarEnum commentGrammar) {
        this.grammar = commentGrammar;
    }

    public List analyse() {
        try {
            LogDocument doc = LogDocument.Factory.parse(new StringReader(this.getOutput()));
            for (int i = 0; i < doc.getLog().getLogentryArray().length; ++i) {
                LogentryDocument.Logentry logEntry = doc.getLog().getLogentryArray()[i];
                this.getLogger().debug("Log entry: " + logEntry.getMsg());
                this.getLogger().debug("has message: " + this.grammar.hasMessage(logEntry.getMsg()));
                if (!this.grammar.hasMessage(logEntry.getMsg())) continue;
                ScmLogEntry entry = new ScmLogEntry();
                entry.setRevision(logEntry.getRevision().toString());
                entry.setAuthor(logEntry.getAuthor());
                entry.setDate(logEntry.getDate().getTime());
                entry.setMessage(this.grammar.extractMessage(logEntry.getMsg()));
                this.elements.add(entry);
            }
            return this.elements;
        }
        catch (XmlException ex) {
            this.getLogger().error((Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            this.getLogger().error((Throwable)ex);
            throw new RuntimeException(ex);
        }
    }
}

