/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.scmchangelog.scm.hg.command.list;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.hg.command.HgConsumer;
import org.codehaus.mojo.scmchangelog.tags.Tag;

class HgTagsConsumer
extends HgConsumer {
    private final List repositoryStatus = new ArrayList();
    private Pattern filter;

    HgTagsConsumer(ScmLogger logger, Pattern filter) {
        super(logger);
        this.filter = filter;
    }

    public void doConsume(ScmFileStatus status, String trimmedLine) {
        this.getLogger().debug(trimmedLine);
        int startRevisionIndex = trimmedLine.lastIndexOf(32);
        int endRevisionIndex = trimmedLine.lastIndexOf(58);
        String title = trimmedLine.substring(0, startRevisionIndex);
        String revisionId = trimmedLine.substring(startRevisionIndex + 1, endRevisionIndex);
        if (this.isTagAccepted(title)) {
            Tag tag = new Tag(title);
            tag.setStartRevision("0");
            tag.setEndRevision(revisionId);
            this.repositoryStatus.add(tag);
        }
    }

    List getStatus() {
        return this.repositoryStatus;
    }

    protected boolean isTagAccepted(String title) {
        if (this.filter != null) {
            Matcher matcher = this.filter.matcher(title);
            this.getLogger().debug("Filtering " + title + " against " + this.filter.pattern() + " : " + matcher.matches());
            return matcher.matches();
        }
        return true;
    }
}

