/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jsimport;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;

public class LocalRepositoryCollector {
    private final List<String> localRepositoryPaths = new ArrayList<String>();

    public LocalRepositoryCollector(MavenProject project, ArtifactRepository localRepository, File wwwZipFolderBase) {
        File[] wwwZipFolders;
        List modules;
        this.localRepositoryPaths.add(localRepository.getBasedir());
        String projectArtifactId = project.getArtifactId();
        for (MavenProject parentProject = project.getParent(); parentProject != null && (modules = parentProject.getModules()).contains(projectArtifactId); parentProject = parentProject.getParent()) {
            projectArtifactId = parentProject.getArtifactId();
            String parentProjectPath = parentProject.getBasedir().getAbsolutePath();
            this.localRepositoryPaths.add(parentProjectPath);
        }
        if (wwwZipFolderBase != null && (wwwZipFolders = wwwZipFolderBase.listFiles()) != null) {
            for (File wwwZipFolder : wwwZipFolders) {
                this.localRepositoryPaths.add(wwwZipFolder.getAbsolutePath());
            }
        }
    }

    public String findLocalRepository(String filePath) {
        String localRepositoryPathFound = null;
        for (String localRepositoryPath : this.localRepositoryPaths) {
            if (!filePath.startsWith(localRepositoryPath)) continue;
            localRepositoryPathFound = localRepositoryPath;
            break;
        }
        return localRepositoryPathFound;
    }

    public void addLocalRepositoryPath(String path) {
        this.localRepositoryPaths.add(path);
    }
}

