/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.idlj;

import [Ljava.lang.String;;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.idlj.AbstractTranslator;
import org.codehaus.mojo.idlj.CompilerTranslator;
import org.codehaus.mojo.idlj.Define;
import org.codehaus.mojo.idlj.PackagePrefix;
import org.codehaus.mojo.idlj.Source;

public class JacorbTranslator
extends AbstractTranslator
implements CompilerTranslator {
    private void invokeCompiler(Class compilerClass, List args) throws MojoExecutionException {
        boolean fork = true;
        if (!fork) {
            try {
                Object[] arguments = args.toArray(new String[args.size()]);
                if (this.isDebug()) {
                    String command = "compile";
                    for (int i = 0; i < arguments.length; ++i) {
                        command = command + " " + (String)arguments[i];
                    }
                    this.getLog().info((CharSequence)command);
                }
                Method compileMethod = compilerClass.getMethod("compile", String;.class);
                compileMethod.invoke((Object)compilerClass, arguments);
            }
            catch (InvocationTargetException e) {
                throw new MojoExecutionException("Compilation failed", e.getTargetException());
            }
            catch (Throwable t) {
                throw new MojoExecutionException("Compilation failed", t);
            }
        }
        File javaHome = new File(System.getProperty("java.home"));
        File javaBin = new File(new File(javaHome, "bin"), "java");
        URLClassLoader cl = (URLClassLoader)this.getClass().getClassLoader();
        URL[] classPathUrls = cl.getURLs();
        ArrayList<String> binArgs = new ArrayList<String>();
        binArgs.add(javaBin.getPath());
        binArgs.add("-classpath");
        String classPath = "" + new File(classPathUrls[0].getPath().replaceAll("%20", " "));
        for (int i = 1; i < classPathUrls.length; ++i) {
            classPath = classPath + File.pathSeparator + new File(classPathUrls[i].getPath().replaceAll("%20", " "));
        }
        classPath = classPath + "";
        binArgs.add(classPath);
        binArgs.add(compilerClass.getName());
        Iterator it = args.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            binArgs.add(o.toString());
        }
        String[] argArray = new String[binArgs.size()];
        for (int i = 0; i < argArray.length; ++i) {
            argArray[i] = binArgs.get(i).toString();
        }
        if (this.isDebug()) {
            String command = "";
            for (int i = 0; i < argArray.length; ++i) {
                command = command + " " + argArray[i];
            }
            this.getLog().info((CharSequence)command);
        }
        try {
            Process p = Runtime.getRuntime().exec(argArray);
            JacorbTranslator.redirectStream(p.getErrorStream(), System.err, "");
            JacorbTranslator.redirectStream(p.getInputStream(), System.out, "");
            p.waitFor();
            if (this.isFailOnError() && p.exitValue() != 0) {
                throw new MojoExecutionException("IDL Compilation failure");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error forking compiler", (Exception)e);
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Thread interrupted unexpectedly", (Exception)e);
        }
    }

    public void invokeCompiler(String sourceDirectory, File[] includeDirs, String targetDirectory, String idlFile, Source source) throws MojoExecutionException {
        Class<?> compilerClass;
        ArrayList<String> args = new ArrayList<String>();
        args.add("-sloppy_names");
        args.add("-I" + sourceDirectory);
        if (includeDirs != null && includeDirs.length > 0) {
            for (int i = 0; i < includeDirs.length; ++i) {
                args.add("-I" + includeDirs[i]);
            }
        }
        args.add("-d");
        args.add(targetDirectory);
        if (source.emitSkeletons() != null && !source.emitSkeletons().booleanValue()) {
            args.add("-noskel");
        }
        if (source.emitStubs() != null && !source.emitStubs().booleanValue()) {
            args.add("-nostub");
        }
        if (source.getPackagePrefix() != null) {
            args.add("-i2jpackage");
            args.add(":" + source.getPackagePrefix());
        }
        if (source.getPackagePrefixes() != null) {
            Iterator prefixes = source.getPackagePrefixes().iterator();
            while (prefixes.hasNext()) {
                PackagePrefix prefix = (PackagePrefix)prefixes.next();
                args.add("-i2jpackage");
                args.add(prefix.getType() + ":" + prefix.getPrefix() + "." + prefix.getType());
            }
        }
        if (source.getDefines() != null) {
            Iterator defs = source.getDefines().iterator();
            while (defs.hasNext()) {
                Define define = (Define)defs.next();
                String arg = "-D" + define.getSymbol();
                if (define.getValue() != null) {
                    arg = arg + "=" + define.getValue();
                }
                args.add(arg);
            }
        }
        if (source.getAdditionalArguments() != null) {
            Iterator it = source.getAdditionalArguments().iterator();
            while (it.hasNext()) {
                args.add((String)it.next());
            }
        }
        args.add(idlFile);
        try {
            compilerClass = Class.forName("org.jacorb.idl.parser");
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("JacORB IDL compiler not found", (Exception)e);
        }
        this.invokeCompiler(compilerClass, args);
    }

    public static void redirectStream(final InputStream in, final OutputStream out, String streamName) {
        Thread stdoutTransferThread = new Thread(){

            public void run() {
                PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(out), true);
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    while ((line = reader.readLine()) != null) {
                        pw.println(line);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        stdoutTransferThread.start();
    }
}

