/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.svnlib;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.maven.changelog.AbstractChangeLogGenerator;
import org.apache.maven.changelog.ChangeLog;
import org.apache.maven.plugin.logging.Log;
import org.apache.tools.ant.types.Commandline;

class SvnChangeLogGenerator
extends AbstractChangeLogGenerator {
    private static final Log LOG = ChangeLog.getLog();

    SvnChangeLogGenerator() {
    }

    protected Commandline getScmLogCommand() {
        Commandline command = new Commandline();
        command.setExecutable("svn");
        command.createArgument().setValue("log");
        command.createArgument().setValue("-v");
        if (this.dateRange != null) {
            command.createArgument().setValue(this.dateRange);
        }
        return command;
    }

    protected String getScmDateArgument(Date before, Date to) {
        SimpleDateFormat outputDate = new SimpleDateFormat("yyyy-MM-dd");
        String cmd = "-r{" + outputDate.format(to) + "}:{" + outputDate.format(before) + "}";
        if (System.getProperty("os.name").startsWith("Windows")) {
            cmd = "\"" + cmd + "\"";
        }
        return cmd;
    }

    protected String getScmTagArgument(String tagStart, String tagEnd) {
        throw new UnsupportedOperationException("This plugin currently does not support generating logs from tags with Subversion.");
    }

    protected void handleParserException(IOException ioe) throws IOException {
        if (ioe.getMessage().indexOf("CreateProcess") == -1 && ioe.getMessage().indexOf("svn: not found") == -1) {
            throw ioe;
        }
        LOG.error((CharSequence)"Unable to find svn executable. Changelog will be empty");
    }
}

