/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.axistools.wsdl2java;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.maven.artifact.Artifact;
import org.codehaus.mojo.axistools.axis.AbstractAxisPlugin;
import org.codehaus.mojo.axistools.axis.AxisPluginException;
import org.codehaus.mojo.axistools.axis.Mapping;
import org.codehaus.mojo.axistools.wsdl2java.WSDL2JavaPlugin;
import org.codehaus.mojo.axistools.wsdl2java.WSDL2JavaWrapper;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;

public class DefaultWSDL2JavaPlugin
extends AbstractAxisPlugin
implements WSDL2JavaPlugin {
    private ArrayList urls;
    private ArrayList wsdlFiles;
    private ArrayList sourceDependencies;
    private File urlDownloadDirectory;
    private File sourceDependencyDirectory;
    private boolean useEmitter;
    private ArrayList mappings;
    private boolean serverSide;
    private String packageSpace;
    private boolean verbose;
    private boolean testCases;
    private boolean runTestCasesAsUnitTests;
    private boolean allElements;
    private boolean debug;
    private Integer timeout;
    private boolean noImports;
    private boolean noWrapped;
    private boolean wrapArrays;
    private boolean skeletonDeploy;
    private String namespaceToPackage;
    private File fileNamespaceToPackage;
    private String deployScope;
    private String typeMappingVersion;
    private String factory;
    private ArrayList nsIncludes;
    private ArrayList nsExcludes;
    private boolean helperGen;
    private String username;
    private String password;
    private String implementationClassName;
    private boolean subPackageByFileName;
    private File testSourceDirectory;

    public void execute() throws AxisPluginException {
        Set wsdlSet;
        Iterator i;
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        this.getLog().info((CharSequence)"about to add compile source root");
        if (this.project != null) {
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
        if (this.urls != null) {
            i = this.urls.iterator();
            while (i.hasNext()) {
                this.downloadWSDLFromUrl((String)i.next());
            }
        }
        if (this.sourceDependencies != null) {
            i = this.sourceDependencies.iterator();
            while (i.hasNext()) {
                this.extractWSDLFromSourceDependency((String)i.next());
            }
        }
        if ((wsdlSet = this.computeStaleWSDLs()).isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to generate. All WSDL files are up to date.");
        } else if (this.wsdlFiles == null) {
            Iterator i2 = wsdlSet.iterator();
            while (i2.hasNext()) {
                File wsdl = (File)i2.next();
                this.processWsdl(wsdl);
            }
        } else {
            Iterator i3 = this.wsdlFiles.iterator();
            while (i3.hasNext()) {
                String wsdlFileName = (String)i3.next();
                File wsdl = this.getFile(wsdlSet, wsdlFileName);
                if (wsdl == null) {
                    this.getLog().info((CharSequence)("Skipping up to date wsdl: " + wsdlFileName + "."));
                    continue;
                }
                this.processWsdl(wsdl);
            }
        }
        if (this.runTestCasesAsUnitTests) {
            this.migrateTestSource();
        }
    }

    private void processWsdl(File wsdl) throws AxisPluginException {
        this.getLog().info((CharSequence)("Processing wsdl: " + wsdl.toString()));
        if (!this.useEmitter) {
            WSDL2JavaWrapper wsdlWrapper = new WSDL2JavaWrapper();
            wsdlWrapper.execute(this.generateWSDLArgumentList(wsdl.getAbsoluteFile()));
        } else {
            this.runEmitter(wsdl);
        }
        try {
            FileUtils.copyFileToDirectory((File)wsdl, (File)this.timestampDirectory);
        }
        catch (IOException e) {
            throw new AxisPluginException("Error while copying the WSDL to timestamp directory.", e);
        }
    }

    private File getFile(Set fileSet, String fileName) {
        Iterator iterator = fileSet.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.getName().equals(fileName)) continue;
            return file;
        }
        return null;
    }

    private void downloadWSDLFromUrl(String urlStr) throws AxisPluginException {
        URLConnection urlConnection;
        try {
            URL url = new URL(urlStr);
            urlConnection = url.openConnection();
        }
        catch (Exception e) {
            throw new AxisPluginException("unable to open connection for download of WSDL file from URL " + urlStr + ". Reason: " + e.getClass().getName() + ": " + e.getMessage(), e);
        }
        File localWsdl = new File(this.urlDownloadDirectory, this.createSafeFileName(urlStr));
        if (localWsdl.exists() && localWsdl.lastModified() == urlConnection.getLastModified()) {
            this.getLog().debug((CharSequence)("local copy of WSDL file from URL " + urlStr + " is up to date."));
            return;
        }
        if (!this.urlDownloadDirectory.exists()) {
            this.urlDownloadDirectory.mkdirs();
        }
        InputStream urlInput = null;
        FileOutputStream localWsdlOutput = null;
        try {
            urlInput = urlConnection.getInputStream();
            localWsdlOutput = new FileOutputStream(localWsdl);
            IOUtil.copy((InputStream)urlInput, (OutputStream)localWsdlOutput);
            localWsdlOutput.flush();
            this.getLog().info((CharSequence)("downloaded WSDL from URL " + urlStr + " (" + localWsdl.length() + " Bytes)."));
        }
        catch (Exception e) {
            try {
                throw new AxisPluginException("unable to download WSDL file from " + urlStr + " to " + localWsdl.getAbsolutePath() + ". Reason: " + e.getClass().getName() + ": " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close((InputStream)urlInput);
                IOUtil.close(localWsdlOutput);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)urlInput);
        IOUtil.close((OutputStream)localWsdlOutput);
        localWsdl.setLastModified(urlConnection.getLastModified());
    }

    private void extractWSDLFromSourceDependency(String sourceDependencyString) throws AxisPluginException {
        JarEntry entry;
        JarURLConnection jarConnection;
        StringTokenizer strtok = new StringTokenizer(sourceDependencyString, ":");
        if (strtok.countTokens() != 4) {
            throw new AxisPluginException("invalid sourceDependency: " + sourceDependencyString + ". Expected format: groupId:artifactId:version:file");
        }
        String groupId = strtok.nextToken();
        String artifactId = strtok.nextToken();
        String version = strtok.nextToken();
        String wsdlFileString = strtok.nextToken();
        try {
            Artifact artifact = this.artifactFactory.createArtifact(groupId, artifactId, version, null, "jar");
            URL url = new URL("jar:file:" + this.localRepository.getBasedir() + File.separator + this.localRepository.pathOf(artifact) + "!" + wsdlFileString);
            jarConnection = (JarURLConnection)url.openConnection();
            entry = jarConnection.getJarEntry();
            if (entry == null) {
                throw new AxisPluginException("unable to find " + wsdlFileString + " in artifact of sourceDependency " + sourceDependencyString + ".");
            }
        }
        catch (Exception e) {
            throw new AxisPluginException("unable to open JAR URL connection for extraction of WSDL file from artifact of sourceDependency " + sourceDependencyString + ". Reason: " + e.getClass().getName() + ": " + e.getMessage(), e);
        }
        File localWsdl = new File(this.sourceDependencyDirectory, this.createSafeFileName(sourceDependencyString));
        if (localWsdl.exists() && entry.getTime() == localWsdl.lastModified()) {
            this.getLog().debug((CharSequence)("local copy of WSDL file from artifact of sourceDependency " + sourceDependencyString + " is up to date."));
            return;
        }
        if (!this.sourceDependencyDirectory.exists()) {
            this.sourceDependencyDirectory.mkdirs();
        }
        InputStream jarWsdlInput = null;
        FileOutputStream localWsdlOutput = null;
        try {
            jarWsdlInput = jarConnection.getInputStream();
            localWsdlOutput = new FileOutputStream(localWsdl);
            IOUtil.copy((InputStream)jarWsdlInput, (OutputStream)localWsdlOutput);
            localWsdlOutput.flush();
            this.getLog().info((CharSequence)("extracted WSDL from sourceDependency " + sourceDependencyString + " (" + localWsdl.length() + " Bytes)."));
        }
        catch (Exception e) {
            try {
                throw new AxisPluginException("unable to retrieve " + wsdlFileString + " from artifact of sourceDependency " + sourceDependencyString + ".", e);
            }
            catch (Throwable throwable) {
                IOUtil.close((InputStream)jarWsdlInput);
                IOUtil.close(localWsdlOutput);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)jarWsdlInput);
        IOUtil.close((OutputStream)localWsdlOutput);
        localWsdl.setLastModified(entry.getTime());
    }

    private void migrateTestSource() throws AxisPluginException {
        if (!this.testSourceDirectory.exists()) {
            this.testSourceDirectory.mkdirs();
        }
        Set testSources = this.locateTestSources();
        Iterator iter = testSources.iterator();
        while (iter.hasNext()) {
            File source = (File)iter.next();
            try {
                FileUtils.copyFileToDirectory((File)source, (File)this.getDestinationDirectory(source));
                FileUtils.fileDelete((String)source.getAbsolutePath());
            }
            catch (IOException ioe) {
                throw new AxisPluginException("error copying test sources", ioe);
            }
        }
        this.project.addTestCompileSourceRoot(this.testSourceDirectory.getPath());
    }

    private File getDestinationDirectory(File source) {
        String relativeFilePath = PathTool.getRelativeFilePath((String)this.outputDirectory.getAbsolutePath(), (String)source.getAbsolutePath());
        String relativePath = FileUtils.getPath((String)relativeFilePath);
        if (StringUtils.isEmpty((String)relativePath) && this.packageSpace != null) {
            relativePath = StringUtils.replace((String)this.packageSpace, (char)'.', (char)File.separatorChar);
        }
        return new File(this.testSourceDirectory, relativePath);
    }

    private String[] generateWSDLArgumentList(File wsdl) throws AxisPluginException {
        Iterator i;
        ArrayList<String> argsList = new ArrayList<String>();
        if (this.debug) {
            argsList.add("--Debug");
        }
        if (this.verbose) {
            argsList.add("-v");
        }
        argsList.add("-o");
        argsList.add(this.outputDirectory.getAbsolutePath());
        if (this.serverSide) {
            argsList.add("-s");
        }
        if (this.testCases) {
            argsList.add("-t");
        }
        if (this.allElements) {
            argsList.add("-a");
        }
        if (this.noImports) {
            argsList.add("-n");
        }
        if (this.timeout != null) {
            argsList.add("-O");
            argsList.add(this.timeout.toString());
        }
        if (this.noWrapped) {
            argsList.add("-W");
        }
        if (this.wrapArrays) {
            argsList.add("-w");
        }
        if (this.skeletonDeploy) {
            argsList.add("-S");
            argsList.add("true");
        }
        if (this.mappings != null && this.mappings.size() > 0) {
            if (this.packageSpace == null) {
                Iterator iter = this.mappings.iterator();
                while (iter.hasNext()) {
                    Mapping mapping = (Mapping)iter.next();
                    argsList.add("-N" + mapping.getNamespace() + "=" + mapping.getTargetPackage());
                }
            } else {
                throw new AxisPluginException("mappings and packageSpace can not be used together");
            }
        }
        if (this.fileNamespaceToPackage != null) {
            argsList.add("-f");
            argsList.add(this.fileNamespaceToPackage.getAbsolutePath());
        }
        if (this.deployScope != null) {
            argsList.add("-d");
            argsList.add(this.deployScope);
        }
        if (this.typeMappingVersion != null) {
            if ("1.1".equals(this.typeMappingVersion) || "1.2".equals(this.typeMappingVersion)) {
                argsList.add("-T");
                argsList.add(this.typeMappingVersion);
            } else {
                throw new AxisPluginException("invalid typeMappingVersion (1.1 or 1.2)");
            }
        }
        if (this.factory != null) {
            argsList.add("-F");
            argsList.add(this.factory);
        }
        if (this.nsIncludes != null) {
            i = this.nsIncludes.iterator();
            while (i.hasNext()) {
                argsList.add("-i");
                argsList.add((String)i.next());
            }
        }
        if (this.nsExcludes != null) {
            i = this.nsExcludes.iterator();
            while (i.hasNext()) {
                argsList.add("-x");
                argsList.add((String)i.next());
            }
        }
        if (this.helperGen) {
            argsList.add("-H");
        }
        if (this.username != null) {
            argsList.add("-U");
            argsList.add(this.username);
        }
        if (this.password != null) {
            argsList.add("-P");
            argsList.add(this.password);
        }
        if (this.implementationClassName != null) {
            argsList.add("-c");
            argsList.add(this.implementationClassName);
        }
        if (this.packageSpace != null && !this.subPackageByFileName) {
            argsList.add("-p");
            argsList.add(this.packageSpace);
        } else if (this.packageSpace != null && this.subPackageByFileName) {
            argsList.add("-p");
            argsList.add(this.packageSpace + "." + FileUtils.basename((String)wsdl.getAbsolutePath(), (String)".wsdl"));
        }
        argsList.add(wsdl.toURI().toString());
        this.getLog().debug((CharSequence)("argslist: " + argsList.toString()));
        return argsList.toArray(new String[argsList.size()]);
    }

    private Set locateTestSources() throws AxisPluginException {
        SuffixMapping mapping = new SuffixMapping("TestCase.java", "TestCase.class");
        StaleSourceScanner scanner = new StaleSourceScanner();
        scanner.addSourceMapping((SourceMapping)mapping);
        HashSet testSources = new HashSet();
        try {
            testSources.addAll(scanner.getIncludedSources(this.outputDirectory, this.testSourceDirectory));
        }
        catch (InclusionScanException e) {
            throw new AxisPluginException("Error scanning source root: '" + this.outputDirectory + "' for stale wsdls to reprocess.", e);
        }
        return testSources;
    }

    private Set computeStaleWSDLs() throws AxisPluginException {
        SuffixMapping mapping = new SuffixMapping(".wsdl", ".wsdl");
        StaleSourceScanner scanner = new StaleSourceScanner((long)this.staleMillis);
        scanner.addSourceMapping((SourceMapping)mapping);
        HashSet staleSources = new HashSet();
        try {
            if (this.sourceDirectory != null && this.sourceDirectory.exists()) {
                staleSources.addAll(scanner.getIncludedSources(this.sourceDirectory, this.timestampDirectory));
            }
            if (this.urlDownloadDirectory != null && this.urlDownloadDirectory.exists()) {
                staleSources.addAll(scanner.getIncludedSources(this.urlDownloadDirectory, this.timestampDirectory));
            }
            if (this.sourceDependencyDirectory != null && this.sourceDependencyDirectory.exists()) {
                staleSources.addAll(scanner.getIncludedSources(this.sourceDependencyDirectory, this.timestampDirectory));
            }
        }
        catch (InclusionScanException e) {
            throw new AxisPluginException("Error scanning source root: '" + this.sourceDirectory + "' for stale wsdls to reprocess.", e);
        }
        return staleSources;
    }

    private void runEmitter(File wsdl) throws AxisPluginException {
        URL wsdlUrl;
        Emitter emitter = new Emitter();
        if (this.mappings != null) {
            this.getLog().debug((CharSequence)("mappings size : " + this.mappings.size()));
            HashMap mappingMap = this.getNamespaceMap(this.mappings);
            this.getLog().debug((CharSequence)("mappingMap size : " + mappingMap.size()));
            emitter.setNamespaceMap(mappingMap);
        }
        try {
            wsdlUrl = wsdl.toURL();
        }
        catch (MalformedURLException e) {
            throw new AxisPluginException("error processing " + wsdl.getAbsolutePath(), e);
        }
        this.getLog().debug((CharSequence)("wsdlUrl.toExternalForm() " + wsdlUrl.toExternalForm()));
        emitter.setAllWanted(this.allElements);
        emitter.setDebug(this.debug);
        if (StringUtils.isNotEmpty((String)this.factory)) {
            emitter.setFactory(this.factory);
        }
        emitter.setHelperWanted(this.helperGen);
        if (StringUtils.isNotEmpty((String)this.implementationClassName)) {
            emitter.setImplementationClassName(this.implementationClassName);
        }
        emitter.setImports(!this.noImports);
        emitter.setNamespaceExcludes(this.nsExcludes == null ? Collections.EMPTY_LIST : this.nsExcludes);
        emitter.setNamespaceIncludes(this.nsIncludes == null ? Collections.EMPTY_LIST : this.nsIncludes);
        emitter.setNowrap(this.noWrapped);
        if (StringUtils.isNotEmpty((String)this.namespaceToPackage)) {
            emitter.setNStoPkg(this.namespaceToPackage);
        }
        emitter.setOutputDir(this.outputDirectory.getPath());
        if (StringUtils.isNotEmpty((String)this.packageSpace)) {
            emitter.setPackageName(this.packageSpace);
        }
        emitter.setPassword(this.password);
        emitter.setServerSide(this.serverSide);
        emitter.setSkeletonWanted(this.skeletonDeploy);
        emitter.setTestCaseWanted(this.testCases);
        emitter.setTypeMappingVersion(this.typeMappingVersion);
        emitter.setUsername(this.username);
        emitter.setVerbose(this.verbose);
        emitter.setWrapArrays(this.wrapArrays);
        try {
            emitter.run(wsdlUrl.toExternalForm());
        }
        catch (Exception e) {
            throw new AxisPluginException("error running " + wsdlUrl.toExternalForm(), e);
        }
    }

    protected HashMap getNamespaceMap(List mappings) {
        HashMap<String, String> namespaceMap = new HashMap<String, String>(mappings.size());
        int size = mappings.size();
        for (int i = 0; i < size; ++i) {
            Mapping mapping = (Mapping)mappings.get(i);
            this.getLog().debug((CharSequence)("mapping " + mappings.toString()));
            namespaceMap.put(mapping.getNamespace(), mapping.getTargetPackage());
        }
        return namespaceMap;
    }

    public void setUrls(ArrayList urls) {
        this.urls = urls;
    }

    public void setWsdlFiles(ArrayList wsdlFiles) {
        this.wsdlFiles = wsdlFiles;
    }

    public void setSourceDependencies(ArrayList sourceDependencies) {
        this.sourceDependencies = sourceDependencies;
    }

    public void setUrlDownloadDirectory(File urlDownloadDirectory) {
        this.urlDownloadDirectory = urlDownloadDirectory;
    }

    public void setSourceDependencyDirectory(File sourceDependencyDirectory) {
        this.sourceDependencyDirectory = sourceDependencyDirectory;
    }

    public void setUseEmitter(boolean useEmitter) {
        this.useEmitter = useEmitter;
    }

    public void setMappings(ArrayList mappings) {
        this.mappings = mappings;
    }

    public void setServerSide(boolean serverSide) {
        this.serverSide = serverSide;
    }

    public void setPackageSpace(String packageSpace) {
        this.packageSpace = packageSpace;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setTestCases(boolean testCases) {
        this.testCases = testCases;
    }

    public void setRunTestCasesAsUnitTests(boolean runTestCasesAsUnitTests) {
        this.runTestCasesAsUnitTests = runTestCasesAsUnitTests;
    }

    public void setAllElements(boolean allElements) {
        this.allElements = allElements;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setNoImports(boolean noImports) {
        this.noImports = noImports;
    }

    public void setNoWrapped(boolean noWrapped) {
        this.noWrapped = noWrapped;
    }

    public void setWrapArrays(boolean wrapArrays) {
        this.wrapArrays = wrapArrays;
    }

    public void setSkeletonDeploy(boolean skeletonDeploy) {
        this.skeletonDeploy = skeletonDeploy;
    }

    public void setNamespaceToPackage(String namespaceToPackage) {
        this.namespaceToPackage = namespaceToPackage;
    }

    public void setFileNamespaceToPackage(File fileNamespaceToPackage) {
        this.fileNamespaceToPackage = fileNamespaceToPackage;
    }

    public void setDeployScope(String deployScope) {
        this.deployScope = deployScope;
    }

    public void setTypeMappingVersion(String typeMappingVersion) {
        this.typeMappingVersion = typeMappingVersion;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public void setNsIncludes(ArrayList nsIncludes) {
        this.nsIncludes = nsIncludes;
    }

    public void setNsExcludes(ArrayList nsExcludes) {
        this.nsExcludes = nsExcludes;
    }

    public void setHelperGen(boolean helperGen) {
        this.helperGen = helperGen;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setImplementationClassName(String implementationClassName) {
        this.implementationClassName = implementationClassName;
    }

    public void setSubPackageByFileName(boolean subPackageByFileName) {
        this.subPackageByFileName = subPackageByFileName;
    }

    public void setTestSourceDirectory(File testSourceDirectory) {
        this.testSourceDirectory = testSourceDirectory;
    }
}

